/*$Id:$*/
/*25.12.2025	22.12.2025	Белых А.И.	iceb_printw_from_thread.cpp
Функция обновления UI из потока
*/
#include "iceb_libbuh.h"
#include "iceb_printw_from_thread.h"

gboolean iceb_printw_thread(gpointer data);

void iceb_printw_from_thread(class iceb_printw_from_thread_data *data)
{


//g_print("%s start\n",__FUNCTION__);



// Безопасно добавляем в очередь
g_mutex_lock(&data->queue_mutex);
g_queue_push_tail(data->text_queue,data->str);
g_mutex_unlock(&data->queue_mutex);

// Ставим задачу на обновление UI в очередь главного цикла
g_idle_add(iceb_printw_thread,data);
//g_print("%s END\n",__FUNCTION__);

}

/*************************************************************/
gboolean iceb_printw_thread(gpointer data)
{
//g_print("%s start\n",__FUNCTION__);

class iceb_printw_from_thread_data *kkk=(class iceb_printw_from_thread_data*)data;

g_mutex_lock(&kkk->queue_mutex);

while (!g_queue_is_empty(kkk->text_queue)) 
{
    // Явное приведение gpointer -> char* для C++
    char *message = (char*)g_queue_pop_head(kkk->text_queue);
    if (message) 
     {
      GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(kkk->view));
      GtkTextIter iter;
        // Вставляем текст в конец буфера
        gtk_text_buffer_get_end_iter(buffer, &iter);
        gtk_text_buffer_insert(buffer, &iter, message, -1);
           //            gtk_text_buffer_insert(kkk->buffer, &iter, "\n", -1);
        // Освобождаем память, выделенную через g_strdup_print - это в подпрограмму которая запустила эту функсцию
        g_free(message);
    }
}
   
g_mutex_unlock(&kkk->queue_mutex);

//g_print("%s end\n",__FUNCTION__);

return G_SOURCE_REMOVE; // Остановить вызовы этого idle-события


}
