/*$Id:$*/
/*10.12.2014	10.12.2014	Белых А.И.	iceb_print_operation.h
эти данные используются в разных подпрограммах 

Ширина символов в пунктах для всех режимов печати
при масштабе 1. помещается 12 знаков на дюм для шрифта 10 пунктов
масштаб для 10 знаков на дюйм 12/10=1.2
Остальные масштабы вычисляются отношением предыдущей ширины шрифта к новой ширине шрифта

Для шрифта другого размера устанавливатеся базовый размер этого шрифта для 10 знаков на дюйм
остальные ширины вычисляются умножением базового на коэффициент
Базовый размер шрифта определён при печтати шрифта с масштабом 1.(12 знаков на дюйм) Смотрим сколько символов помещается на размере 1 дюйма (25.4мм)
Для шрифта 8 в масштабе 1. помещается 15 символов на дюйм - отпечатал на бумаге строку и посчитал количество символов на дюйме

Базовая ширина шрифта 8 вычисляется по формуле  25.4/(15/(12/10))
где 15/(12/10) вычисляется количество знаков при режиме печати 10 знаков на дюйм

*/

const double PEREVOD_V_PUNKT=72./25.4;
const double hir_simv_10 = (25.4/10.)*PEREVOD_V_PUNKT; /*ширина символа в пунктах в режиме 10 знаков на дюйм*/

const double hir_simv_8 = (25.4/(15./1.2))*PEREVOD_V_PUNKT; /*при масштабе 1. получается 15 знаков тогда 15/1.2=12.5 при масштабе для 10 знаков для шрифта в 10 пунктов*/

/*Для того чтобы вычислить ширину символа нужно ширину базового символа (10 знаков на дюйм) разделить на коэффициент*/
const double koef10u=17./10.; /*при ужатии 10 символов получается 17 символов для шрифта 10 пунктов*/
const double koef12=12./10.; /*вместо 10 символов получается 12 символов для шрифта 10 пунктов*/
const double koef12u=20./10.; /*вместо 10 символов получается 20 символов для шрифта 10 пунктов*/
const double koef15=15./10.; /*вместо 10 символов получается 15 символов для шрифта 10 пунктов*/
const double koef15u=22./10.; /*вместо 10 символов получается 22 символов для шрифта 10 пунктов*/
