/*$Id:$*/
/*23.05.2016	24.04.2005	Белых А.И. 	xmurndsopw_r.c
Расчёт реестра проводок по видам операций
*/
#include <math.h>
#include <errno.h>
#include "buhg_g.h"
#include "xmurndsopw.h"

class xmurndsopw_r_data
 {

  public:

  GtkWidget *knopka;
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *bar;
  GtkWidget *view;
  GtkTextBuffer *buffer;
  class iceb_u_str name_window;

  class xmurndsop_rp *rk;
  class spis_oth *oth;
    
  short kon_ras; //0-расчёт завершен 1-нет
  int voz;

  xmurndsopw_r_data()
   {
    voz=1;
    kon_ras=1;
   }
 };
gboolean   xmurndsopw_r_key_press(GtkWidget *widget,GdkEventKey *event,class xmurndsopw_r_data *data);
gint xmurndsopw_r1(class xmurndsopw_r_data *data);
void  xmurndsopw_r_v_knopka(GtkWidget *widget,class xmurndsopw_r_data *data);

extern SQL_baza bd;

int xmurndsopw_r(class xmurndsop_rp *datark,class spis_oth *oth,GtkWidget *wpredok)
{
char strsql[512];
int gor=0;
int ver=0;
class iceb_u_str repl;
class xmurndsopw_r_data data;

data.rk=datark;
data.oth=oth;
data.name_window.plus(__FUNCTION__);

data.window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_modal(GTK_WINDOW(data.window),TRUE);
gtk_window_set_position( GTK_WINDOW(data.window),ICEB_POS_CENTER);
if(iceb_sizwr(data.name_window.ravno(),&gor,&ver) == 0)
   gtk_window_set_default_size (GTK_WINDOW  (data.window),gor,ver);
else
  gtk_window_set_default_size (GTK_WINDOW  (data.window),400,400);

sprintf(strsql,"%s %s",iceb_get_namesystem(),gettext("Распечатать распределение НДС по видам операций"));
gtk_window_set_title(GTK_WINDOW(data.window),strsql);

g_signal_connect(data.window,"delete_event",G_CALLBACK(gtk_widget_destroy),NULL);
g_signal_connect(data.window,"destroy",G_CALLBACK(gtk_main_quit),NULL);
g_signal_connect_after(data.window,"key_press_event",G_CALLBACK(xmurndsopw_r_key_press),&data);

if(wpredok != NULL)
 {
  gdk_window_set_cursor(gtk_widget_get_window(wpredok),gdk_cursor_new_for_display(gtk_widget_get_display(wpredok),ICEB_CURSOR_GDITE));
  //Удерживать окно над породившем его окном всегда
  gtk_window_set_transient_for(GTK_WINDOW(data.window),GTK_WINDOW(wpredok));
  //Закрыть окно если окно предок удалено
  gtk_window_set_destroy_with_parent(GTK_WINDOW(data.window),TRUE);
 }

GtkWidget *vbox=gtk_box_new(GTK_ORIENTATION_VERTICAL, 2);
gtk_box_set_homogeneous (GTK_BOX(vbox),FALSE); //Устанавливает одинакоый ли размер будут иметь упакованные виджеты-TRUE-одинаковые FALSE-нет

gtk_container_add(GTK_CONTAINER(data.window), vbox);

data.label=gtk_label_new(gettext("Ждите !!!"));

gtk_box_pack_start(GTK_BOX(vbox),data.label,FALSE,FALSE,0);

repl.plus(gettext("Распечатать распределение НДС по видам операций"));
sprintf(strsql,"%s:%s %s\n",gettext("База данных"),iceb_get_namebase(),iceb_get_pnk("00",0,wpredok));
repl.ps_plus(strsql);

GtkWidget *label=gtk_label_new(repl.ravno());

gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

data.view=gtk_text_view_new();

gtk_text_view_set_editable(GTK_TEXT_VIEW(data.view),FALSE); //Запрет на редактирование текста

data.buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(data.view));

GtkWidget *sw=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);
gtk_container_add(GTK_CONTAINER(sw),data.view);


data.bar=gtk_progress_bar_new();
gtk_progress_bar_set_show_text(GTK_PROGRESS_BAR(data.bar),TRUE); /*Показывать текст в строке*/



gtk_box_pack_start (GTK_BOX (vbox), data.bar, FALSE, FALSE, 2);



sprintf(strsql,"F10 %s",gettext("Выход"));
data.knopka=gtk_button_new_with_label(strsql);
gtk_widget_set_tooltip_text(data.knopka,gettext("Завершение работы в этом окне"));
g_signal_connect(data.knopka,"clicked",G_CALLBACK(xmurndsopw_r_v_knopka),&data);
gtk_widget_set_name(data.knopka,iceb_u_inttochar(0));
gtk_box_pack_start (GTK_BOX (vbox), data.knopka, FALSE, FALSE, 2);

gtk_widget_set_sensitive(GTK_WIDGET(data.knopka),FALSE);//Недоступна

gtk_widget_show_all(data.window);


//gtk_window_set_decorated(GTK_WINDOW(data.window),FALSE); //Убирает рамку вокруг окна

//gtk_widget_set_sensitive(GTK_WIDGET(data.knopka),FALSE);//Недоступна

g_idle_add((GSourceFunc)xmurndsopw_r1,&data);

gtk_main();

if(wpredok != NULL)
  gdk_window_set_cursor(gtk_widget_get_window(wpredok),gdk_cursor_new_for_display(gtk_widget_get_display(wpredok),ICEB_CURSOR));

return(data.voz);
}
/*****************************/
/*Обработчик нажатия кнопок  */
/*****************************/
void  xmurndsopw_r_v_knopka(GtkWidget *widget,class xmurndsopw_r_data *data)
{
if(data->kon_ras == 1)
 return;
iceb_sizww(data->name_window.ravno(),data->window);
gtk_widget_destroy(data->window);
return;
}
/*********************************/
/*Обработка нажатия клавиш       */
/*********************************/

gboolean   xmurndsopw_r_key_press(GtkWidget *widget,GdkEventKey *event,class xmurndsopw_r_data *data)
{
switch(event->keyval)
 {
  case GDK_KEY_Escape:
  case GDK_KEY_F10:
    g_signal_emit_by_name(data->knopka,"clicked");
    break;
 }
return(TRUE);
}

/***************************************/
/*распечатка массивов*/
/****************************************/

void xmurndsop_rm(int tipz, /*1-приходы 2-расходы*/
class iceb_u_spisok *kod_op, /*коды операций*/
class iceb_u_spisok *all_proc_nds,
class iceb_u_double *suma_dok,
class iceb_u_double *suma_nds,
FILE *ff,
GtkWidget *wpredok)
{
class iceb_u_str liniq("-----------------------------------------------"); /*линия над кодом и наименованием*/


if(tipz == 1)
 fprintf(ff,"%s\n",gettext("Приходные операции"));
else
 fprintf(ff,"%s\n",gettext("Расходные операции"));
 

int kolih_nds=all_proc_nds->kolih();
int kolih_oper=kod_op->kolih();

for(int nom=0; nom < kolih_nds; nom++) /*линия над числами*/
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
   liniq.plus("-----------------------");
 }

fprintf(ff,"%s\n",liniq.ravno());

/*первая строка шапки*/
fprintf(ff,"%s",gettext("\
 Код |         Наименование операции          |"));

/***********************
12345|1234567890123456789012345678901234567890|12345678901|1234567890|
*************/

for(int nom=0; nom < kolih_nds; nom++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
    fprintf(ff,"%-22s|",all_proc_nds->ravno(nom));
 }

fprintf(ff,"\n");

/*вторая строка шапки*/
fprintf(ff,"\
     |                                        |");

for(int nom=0; nom < kolih_nds; nom++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
   fprintf(ff,"%s",gettext("Сумма с НДС|    НДС   |"));
 }

fprintf(ff,"\n");

fprintf(ff,"%s\n",liniq.ravno());

class iceb_u_str naim_op("");
class iceb_u_str kop("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double suma_d=0.;
double suma_n=0.;

for(int nom_oper=0; nom_oper < kod_op->kolih(); nom_oper++)
 {
  if(suma_dok->prov_str(kolih_oper,kolih_nds,nom_oper) == 0)
   continue;
  kop.new_plus(kod_op->ravno(nom_oper));

  if(tipz == 1)
   sprintf(strsql,"select naik from Prihod where kod='%s'",kop.ravno()); 

  if(tipz == 2)
   sprintf(strsql,"select naik from Rashod where kod='%s'",kop.ravno()); 

  if(iceb_sql_readkey(strsql,&row,&cur,wpredok) == 1)
   naim_op.new_plus(row[0]);
  else
   naim_op.new_plus("");

  fprintf(ff,"%-*s|%-*.*s|",
  iceb_u_kolbait(5,kop.ravno()),
  kop.ravno(),
  iceb_u_kolbait(40,naim_op.ravno()),
  iceb_u_kolbait(40,naim_op.ravno()),
  naim_op.ravno());
          
  for(int nomer_nds=0; nomer_nds < kolih_nds; nomer_nds++)
   {
    if(suma_dok->prov_kol(kolih_oper,kolih_nds,nomer_nds) == 0)
     continue;  
    suma_d=suma_dok->ravno(nom_oper*kolih_nds+nomer_nds);
    suma_n=suma_nds->ravno(nom_oper*kolih_nds+nomer_nds);

    if(suma_d != 0.)
     fprintf(ff,"%11.2f|",suma_d);
    else
     fprintf(ff,"%11s|","");

    if(suma_n != 0.)
     fprintf(ff,"%10.2f|",suma_n);
    else
     fprintf(ff,"%10s|","");
     
   }

  fprintf(ff,"\n");

 }
fprintf(ff,"%s\n",liniq.ravno());

fprintf(ff,"%*s|",iceb_u_kolbait(46,gettext("Итого")),gettext("Итого"));

for(int nomer_nds=0; nomer_nds < kolih_nds; nomer_nds++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nomer_nds) == 0)
     continue;  
  suma_d=suma_dok->suma_kol(kolih_oper,kolih_nds,nomer_nds);
  suma_n=suma_nds->suma_kol(kolih_oper,kolih_nds,nomer_nds);

  if(suma_d != 0.)
     fprintf(ff,"%11.2f|",suma_d);
  else
     fprintf(ff,"%11s|","");

  if(suma_n != 0.)
   fprintf(ff,"%10.2f|",suma_n);
  else
   fprintf(ff,"%10s|","");

 }
 
fprintf(ff,"\n%s\n",liniq.ravno());


}
/*********************************/
/*распечатка реквизитов поиска*/
/*******************************/
void xmurndsop_rrp(class xmurndsop_rp *rp,FILE *ff)
{
if(rp->sklad.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Склад"),rp->sklad.ravno());

if(rp->prih_rash == 1)
 fprintf(ff,"%s:%s\n",gettext("Приход/расход"),gettext("Только приход"));

if(rp->prih_rash == 2)
 fprintf(ff,"%s:%s\n",gettext("Приход/расход"),gettext("Только расход"));

if(rp->kod_op.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rp->kod_op.ravno());
if(rp->kod_kontr.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код контрагента"),rp->kod_kontr.ravno());
if(rp->nom_dok.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Номер документа"),rp->nom_dok.ravno());

}
/**************************************/
/*шапка*/
/**************************************/
void xmurndsop_hap(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"\
----------------------------------------------------------------------------------------\n");

fprintf(ff,"%s\n",gettext("\
 |  Дата    |Склад|Код кон.|Номер документа|Код оп.|НДС|   Сумма  |   НДС  |Сумма с НДС|"));
/****************
1234567890|12345|12345678|123456789012345|1234567|123|1234567890|12345678|12345678901|
*****************/
fprintf(ff,"\
----------------------------------------------------------------------------------------\n");

}




/*************************************************/
/*расчёт*/
/*********************/

int xmurndsop_rash(class xmurndsopw_r_data *data)
{
char strsql[1024];

time_t tmm;

time(&tmm);

short dn,mn,gn;
short dk,mk,gk;

iceb_rsdatp(&dn,&mn,&gn,data->rk->datan.ravno(),&dk,&mk,&gk,data->rk->datak.ravno(),data->window);

gtk_text_buffer_create_tag(data->buffer,"naim_shrift","family","monospace","foreground",NULL,NULL);

sprintf(strsql,"%s %d.%d.%d%s %s %d.%d.%d%s\n",
gettext("Расчёт распределения НДС по видам операций\nза период с"),
dn,mn,gn,
gettext("г."),
gettext("до"),
dk,mk,gk,
gettext("г."));

iceb_printw(strsql,data->buffer,data->view);




/*Создаем массивы операций-материалов*/
sprintf(strsql,"select kod from Prihod");

class SQLCURSOR cur;
class SQLCURSOR cur1;
class iceb_u_spisok kod_op_prih;
class iceb_u_spisok kod_op_rash;
int kolstr=0;
SQL_str row,row1;

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,data->window);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
  kod_op_prih.plus(row[0]);

sprintf(strsql,"select kod from Rashod");

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,data->window);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
  kod_op_rash.plus(row[0]);

int kolopp=kod_op_prih.kolih();
int kolopr=kod_op_rash.kolih();

sprintf(strsql,"%s:%d\n",gettext("Количество операций приходов"),kolopp);
iceb_printw(strsql,data->buffer,data->view);

sprintf(strsql,"%s:%d\n",gettext("Количество операций расходов"),kolopr);
iceb_printw(strsql,data->buffer,data->view);

if(kolopp == 0 && kolopr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одной записи кодов операций !"),data->window);
  return(1);
 }

/*создаём список процентов НДС*/

class iceb_u_spisok all_proc_nds;

sprintf(strsql,"select distinct pn from Dokummat where datd >= '%04d-%02d-%02d' \
and datd <= '%04d-%02d-%02d' and pod=1 and pn != 0.",
gn,mn,dn,gk,mk,dk);
 
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,data->window);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
 {
  all_proc_nds.plus(row[0]);
 }

all_proc_nds.plus("0-1");
all_proc_nds.plus("0-2");
all_proc_nds.plus("0-3");


int kolih_proc_nds=all_proc_nds.kolih();

class iceb_u_double suma_dok_prih;
class iceb_u_double suma_nds_prih;

class iceb_u_double suma_dok_rash;
class iceb_u_double suma_nds_rash;

suma_dok_prih.make_class(kolopp*kolih_proc_nds);
suma_nds_prih.make_class(kolopp*kolih_proc_nds);

suma_dok_rash.make_class(kolopr*kolih_proc_nds);
suma_nds_rash.make_class(kolopr*kolih_proc_nds);

sprintf(strsql,"select tip,datd,sklad,kontr,nomd,kodop,pn from Dokummat where datd >= '%04d-%02d-%02d' \
and datd <= '%04d-%02d-%02d' and pod=1 order by datd asc",
gn,mn,dn,gk,mk,dk);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,data->window);
  return(1);
 }

int vt=0;
iceb_poldan("Код группы возвратная тара",&vt,"matnast.alx",data->window);

int kolstr1=0;
class iceb_u_str vid_nds("");
int nomer_nds=0;
int nomer_oper=0;
double suma=0;
double sumabn=0.;
double sumkor=0.;
double kolihmat=0.;
short dd=0,md=0,gd=0;
double suma_nds=0.;
double suma_dok=0.;
double suma_bez_nds=0.;
class iceb_u_str proc_nds("");  
char imaf_prot[64];

sprintf(imaf_prot,"rndsp%d.lst",getpid());

class iceb_fopen fil;
if(fil.start(imaf_prot,"w",data->window) != 0)
 return(1);


iceb_zagolov(gettext("Список документов вошедших в расчёт"),dn,mn,gn,dk,mk,gk,fil.ff,data->window);
xmurndsop_rrp(data->rk,fil.ff);

class iceb_rnl_c rh;
xmurndsop_hap(&rh,NULL,fil.ff);

char metka_td[2];
int tipz=0;


sprintf(strsql,"\
----------------------------------------------------------------------------------------\n");
iceb_printw(strsql,data->buffer,data->view,"naim_shrift");

sprintf(strsql,"%s\n",gettext("\
 |  Дата    |Склад|Код кон.|Номер документа|Код оп.|НДС|   Сумма  |   НДС  |Сумма с НДС|"));

/****************
1234567890|12345|12345678|123456789012345|1234567|123|1234567890|12345678|12345678901|
*****************/
iceb_printw(strsql,data->buffer,data->view,"naim_shrift");

sprintf(strsql,"\
----------------------------------------------------------------------------------------\n");
iceb_printw(strsql,data->buffer,data->view,"naim_shrift");








while(cur.read_cursor(&row) != 0)
 {
//  strzag(LINES-1,0,kolstr,++kolstr1);
  iceb_pbar(data->bar,kolstr,++kolstr1);    

  tipz=atoi(row[0]);

  if(data->rk->prih_rash == 1 && tipz == 2)
   continue;
  if(data->rk->prih_rash == 2 && tipz == 1)
   continue;

  if(iceb_u_proverka(data->rk->sklad.ravno(),row[2],0,0) != 0)
    continue;  

  if(iceb_u_proverka(data->rk->kod_op.ravno(),row[5],0,0) != 0)
    continue;  

  if(iceb_u_proverka(data->rk->kod_kontr.ravno(),row[3],0,0) != 0)
    continue;  

  if(iceb_u_proverka(data->rk->nom_dok.ravno(),row[4],0,0) != 0)
    continue;  

  proc_nds.new_plus(row[6]);

  if(proc_nds.ravno_atof() == 0.)
   {
    /*узнаём вид НДС этого документа*/
    sprintf(strsql,"select sodz from Dokummat2 where god=%d and nomd='%s' and sklad=%s and nomerz=11",
    atoi(row[1]),row[4],row[2]);

    if(iceb_sql_readkey(strsql,&row1,&cur1,data->window) <= 0)
     {
      iceb_menu_soob(gettext("Не найден вид нулевого НДС"),data->window);
      continue;
     }
    else   
     {
      proc_nds.new_plus("0-");
      proc_nds.plus(row1[0]);
     }
   }


  if(tipz == 1)
   strcpy(metka_td,"+");
  else   
   strcpy(metka_td,"-");

  iceb_u_rsdat(&dd,&md,&gd,row[1],2);
    
  sumzap1w(dd,md,gd,row[4],atoi(row[2]),&suma,&sumabn,vt,&sumkor,tipz,&kolihmat,data->window);

  suma_nds=suma*proc_nds.ravno_atof()/100.;
  suma_nds=iceb_u_okrug(suma_nds,0.01);

  suma_bez_nds=suma+sumabn;
  suma_dok=suma+suma_nds+sumabn;

/********************
+|  Дата    |Склад|Код кон.|Номер документа|Код оп.|НДС|   Сумма  |   НДС  |Сумма с НДС|\n");
1|1234567890|12345|12345678|123456789012345|1234567|123|1234567890|12345678|12345678901|
           tip,datd,sklad,kontr,nomd,kodop,pn
******************/
  sprintf(strsql,"%s|%s|%-5s|%-*s|%-*s|%-*s|%3.3g|%10.2f|%8.2f|%11.2f|\n",
  metka_td,
  iceb_u_datzap(row[1]),
  row[2],
  iceb_u_kolbait(8,row[3]),
  row[3],
  iceb_u_kolbait(15,row[4]),
  row[4],
  iceb_u_kolbait(7,row[5]),
  row[5],
  atof(row[6]),
  suma_bez_nds,
  suma_nds,
  suma_dok);
  
  iceb_printw(strsql,data->buffer,data->view,"naim_shrift");
  
  fprintf(fil.ff,"%s|%s|%-5s|%-*s|%-*s|%-*s|%3.3g|%10.2f|%8.2f|%11.2f|\n",
  metka_td,
  iceb_u_datzap(row[1]),
  row[2],
  iceb_u_kolbait(8,row[3]),
  row[3],
  iceb_u_kolbait(15,row[4]),
  row[4],
  iceb_u_kolbait(7,row[5]),
  row[5],
  atof(row[6]),
  suma_bez_nds,
  suma_nds,
  suma_dok);
  
  if((nomer_nds=all_proc_nds.find(proc_nds.ravno())) < 0)
   {
    sprintf(strsql,"%s %s %s!",gettext("Не нашли вид НДС"),vid_nds.ravno(),gettext("в списке видов НДС"));
    iceb_menu_soob(strsql,data->window);
    continue;
   }

  if(tipz == 1)
   {
    if((nomer_oper=kod_op_prih.find(row[5])) < 0)
     {
      sprintf(strsql,"%s %s %s!",gettext("Не нашли код операции"),row[5],gettext("в списке приходных кодов операций"));
      iceb_menu_soob(strsql,data->window);
      continue;
     }
    suma_dok_prih.plus(suma_dok,nomer_oper*kolih_proc_nds+nomer_nds);    
    suma_nds_prih.plus(suma_nds,nomer_oper*kolih_proc_nds+nomer_nds);    
   }
  else
   {
    if((nomer_oper=kod_op_rash.find(row[5])) < 0)
     {
      sprintf(strsql,"%s %s %s!",gettext("Не нашли код операции"),row[5],gettext("в списке расходных кодов операций"));
      iceb_menu_soob(strsql,data->window);
      continue;
     }
    suma_dok_rash.plus(suma_dok,nomer_oper*kolih_proc_nds+nomer_nds);    
    suma_nds_rash.plus(suma_nds,nomer_oper*kolih_proc_nds+nomer_nds);    

   }


 }

fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"\
----------------------------------------------------------------------------------------\n");

iceb_podpis(fil.ff,data->window);
fil.end();

char imaf[64];
sprintf(imaf,"rnds%d.lst",getpid());
if(fil.start(imaf,"w",data->window) != 0)
 return(1);


iceb_zagolov(gettext("Распределение НДС по видам операций"),dn,mn,gn,dk,mk,gk,fil.ff,data->window);
xmurndsop_rrp(data->rk,fil.ff);


fprintf(fil.ff,"\n");

if(data->rk->prih_rash == 0 || data->rk->prih_rash == 1)
 xmurndsop_rm(1,&kod_op_prih,&all_proc_nds,&suma_dok_prih,&suma_nds_prih,fil.ff,data->window);

fprintf(fil.ff,"\n");

if(data->rk->prih_rash == 0 || data->rk->prih_rash == 2)
 xmurndsop_rm(2,&kod_op_rash,&all_proc_nds,&suma_dok_rash,&suma_nds_rash,fil.ff,data->window);




iceb_podpis(fil.ff,data->window);
fil.end();



data->oth->spis_imaf.plus(imaf);
data->oth->spis_naim.plus(gettext("Распределение НДС по видам операций"));
data->oth->spis_imaf.plus(imaf_prot);
data->oth->spis_naim.plus(gettext("Список документов вошедших в расчёт"));

iceb_ustpeh(data->oth->spis_imaf.ravno(0),0,data->window);

iceb_ustpeh(imaf_prot,3,&rh.orient,data->window);
iceb_rnl(imaf_prot,&rh,&xmurndsop_hap,data->window);



iceb_printw_vr(tmm,data->buffer,data->view);


return(0);






}



/******************************************/
/******************************************/

gint xmurndsopw_r1(class xmurndsopw_r_data *data)
{
class iceb_clock sss(data->window);








data->voz=xmurndsop_rash(data);





gtk_label_set_text(GTK_LABEL(data->label),gettext("Расчёт закончен"));

data->kon_ras=0;
gtk_widget_set_sensitive(GTK_WIDGET(data->knopka),TRUE);//доступна
gtk_widget_grab_focus(data->knopka);
gtk_widget_show_all(data->window);



return(FALSE);

}
