/*$Id: $*/
/*26.01.2026	15.01.2011	Белых А.И.	ras_podoh1w.c
Расчёт подоходного налога
Возвращает сумму подоходного налога
*/
#include        "buhg_g.h"

extern double   okrg; /*Округление*/
extern short    *kodmp;   /*Коды благотворит. помощи*/
extern short    *kn_bsl; //Коды начислений на которые не распространяется льгота по подоходному налогу
extern short    kodpn;   /*Код подоходного налога*/
extern short	metkarnb; //0-Расчёт налогов для бюджета пропорциональный 1-последовательный
extern short kodpn_sbol; /*Код подоходного с больничного*/
extern short   *kodbl; /*Код больничного*/
extern float  kof_prog_min; //Коэффициент прожиточного минимума

extern class iceb_u_spisok skndr; /*список кодов начисления для любого количества настроек расчёта*/
extern class iceb_u_int kudzr;    /*код удержания для каждой строки списка начислений*/

double ras_podor1_rpnsb(int tbn,short mr,short gr,int podr,int metka_zap,double suma_nahisl,double lgota,GtkWidget *wpredok);
double podohrs2016w(int tabn,short mr,short gr,int metka_zap_lgot,int metka_p_boln,class zar_sumtn *tnsum,GtkWidget *wpredok);
double prosmas(short*,short,short,double*);
double zarsbslw(int tabnom,short mp,short gp,double *suma_bsl_b,double *suma_bsl_start,double *suma_bsl_start_b);
double ras_podoh1_stip(short mr,short gr,int tabn,class zar_sumtn *tnsum,GtkWidget *wpredok);
double ras_podoh1_dpn(short mr,short gr,int tabn,class zar_sumtn *tnsum,double suma_pod_nal,int podr,GtkWidget *wpredok);

extern SQL_baza bd;

double ras_podoh1w(int tn, //Табельный номер*/
short mp,short gp,
int podr,
double suma_esv,
double suma_esvb,
int metka_zap, //0-делать запись 1-нет
double suma_boln,
const char *uder_only,
GtkWidget *wpredok)
{
char strsql[1024];
SQL_str row;
SQLCURSOR cur; 
class iceb_u_str shet("");
class iceb_u_str shetb("");
struct ZARP     zp;
short		d;
int metka_p_boln=0;
if(suma_boln != 0.)
 metka_p_boln=1;
iceb_u_dpm(&d,&mp,&gp,5);
zp.tabnom=tn;
zp.prn=2;
zp.knu=kodpn;
zp.dz=d;
zp.mz=mp;
zp.gz=gp;
zp.mesn=mp; zp.godn=gp;
zp.nomz=0;
zp.podr=podr;
double nah=0.;
double bb=0.;
class zar_sumtn tnsum; 

double suma_s_soc_lg=0.;
double sumanb=0.;
double sumabu=0.;


sprintf(strsql,"\n%s-Рачёт подоходного налога после 1.1.2011\n\
---------------------------------------------------\n",__FUNCTION__);
zar_pr_insw(strsql,wpredok);

if(iceb_u_proverka(uder_only,kodpn,0,0) != 0)
 {
  sprintf(strsql,"%s-Код %d исключён из расчёта\n",__FUNCTION__,kodpn);
  zar_pr_insw(strsql,wpredok);
  return(0.);    
 }



/*Проверяем есть ли код удержания подоходного налога в списке*/

sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tn,kodpn);
if(sql_readkey(&bd,strsql,&row,&cur) <= 0)
 {
  sprintf(strsql,"%s-Не введено удержание подоходного налога !\n",__FUNCTION__);
  zar_pr_insw(strsql,wpredok);
  return(0.);
 }

shet.new_plus(row[0]);

sprintf(strsql,"select shet,shetb from Uder where kod=%d",kodpn);
if(iceb_sql_readkey(strsql,&row,&cur,wpredok) != 1)
 {
  sprintf(strsql,"%s-Не найден код удержания %d в справочнике удержаний!\n",__FUNCTION__,kodpn);
  zar_pr_insw(strsql,wpredok);
  return(0.);
 }
shetb.new_plus(row[1]);
if(shetb.getdlinna() > 1)
  shet.new_plus(row[0]);

zar_sumtnw(mp,gp,tn,0,&tnsum,wpredok); /*читаем всё что нужно для расчёта*/

/*для студентов со стипендии налог считается по другому*/
sprintf(strsql,"select harac from Kartb where tabn=%d",tn);
if(iceb_sql_readkey(strsql,&row,&cur,wpredok) <= 0)
 {
  sprintf(strsql,"%s-Не найден карточка для табельного номера %d",__FUNCTION__,tn);
  zar_pr_insw(strsql,wpredok);
 }

sprintf(strsql,"%s-Характер работы-%s\n",__FUNCTION__,row[0]);
zar_pr_insw(strsql,wpredok);

if(iceb_u_strstrm(row[0],"студент") == 1)
  nah=ras_podoh1_stip(mp,gp,tn,&tnsum,wpredok);
else
  nah=podohrs2016w(tn,mp,gp,0,metka_p_boln,&tnsum,wpredok);

double nah_zap=nah;






if(kodpn_sbol != 0 && suma_boln == 0.) /*нужно определить сколько подоходного налога приходится на больничные и записать их отдельно*/
 {
  nah_zap-=ras_podor1_rpnsb(tn,mp,gp,podr,metka_zap,suma_s_soc_lg,tnsum.suma_lgot,wpredok);
 }

if(shetb.getdlinna() <= 1)
 {
  strcpy(zp.shet,shet.ravno());
  if(metka_zap == 0)
   {
    double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum,nah_zap,podr,wpredok);
    nah_zap-=pod_nal;
    zapzarpw(&zp,nah_zap,d,mp,gp,0,shet.ravno(),"",0,podr,"",wpredok);
   }
 }
else
 {
  class zar_sumtn tnsum_b; 

  zar_sumtnw(mp,gp,tn,1,&tnsum_b,wpredok); /*читаем всё что нужно для расчёта бюджета*/

  
  double bb2=0.;
  if(metkarnb == 1) //Последовательный метод расчёта налогов
   {
    sprintf(strsql,"\n%s-Расчёт подоходного для бюджетных начислентий\n",__FUNCTION__);
    zar_pr_insw(strsql,wpredok);
      
    sprintf(strsql,"%s-Сумма единого соц.взноса=%.2f\n",__FUNCTION__,suma_esvb);
    zar_pr_insw(strsql,wpredok);

    bb2=podohrs2016w(tn,mp,gp,1,metka_p_boln,&tnsum_b,wpredok);

    sprintf(strsql,"%s-Бюджет последовательный:%.2f Счёт:%s\n",__FUNCTION__,bb2,shetb.ravno());
    zar_pr_insw(strsql,wpredok);
   } 

  if(metkarnb == 0) //Пропорциональный метод расчёта налогов
   {

    sprintf(strsql,"%s-Пропорционально:Разбивка суммы:%.2f не бюджет=%.2f бюджет:%.2f\n",
    __FUNCTION__,bb,sumanb,sumabu);

    zar_pr_insw(strsql,wpredok);

    sumabu=tnsum_b.suma_nah_all_podoh;


    if(sumabu != 0.)
     {
      
      if(tnsum.suma_nah_all_podoh != 0.)
       {
        bb=tnsum.suma_nah_all_podoh-tnsum_b.suma_nah_all_podoh;
        //Если хозрасчёт не равен нолю то долю определять надо
        if(bb != 0.)
         bb2=nah_zap*sumabu/tnsum.suma_nah_all_podoh;
        else
         bb2=nah_zap;
       }
     }

   }

  bb2=iceb_u_okrug(bb2,okrg);
//  iceb_u_polen(shpnb,&shet,2,',');

  sprintf(strsql,"%s-Бюджет:%.2f Счёт:%s\n",__FUNCTION__,bb2,shetb.ravno());
  zar_pr_insw(strsql,wpredok);

  if(shetb.getdlinna() > 1)
   {
    if(metka_zap == 0)
     {
      double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum_b,bb2,podr,wpredok);
      double pn=bb2-pod_nal;
      strcpy(zp.shet,shetb.ravno());
      zapzarpw(&zp,pn,d,mp,gp,0,shetb.ravno(),gettext("Бюджет"),0,podr,"",wpredok);
     }
   }

//  iceb_u_polen(shpnb,&shet,1,',');
  bb2=nah_zap-bb2;
  bb2=iceb_u_okrug(bb2,okrg);

  sprintf(strsql,"%s-Хозрасчёт:%.2f(%.2f) Счёт:%s\n",__FUNCTION__,bb2,nah_zap,shet.ravno());
  zar_pr_insw(strsql,wpredok);

  if(shet.getdlinna() > 1)
   {
    if(metka_zap == 0)
     {
      class zar_sumtn tnsum_h; 

      zar_sumtnw(mp,gp,tn,2,&tnsum_h,wpredok); /*читаем всё что нужно для расчёта только хозрасчёта*/
   
      double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum_h,bb2,podr,wpredok);
      bb2-=pod_nal;
      strcpy(zp.shet,shet.ravno());
      zapzarpw(&zp,bb2,d,mp,gp,0,shet.ravno(),gettext("Хозрасчёт"),0,podr,"",wpredok);
     }
   }
  
 }


return(nah);
}
/********************************/
/*Узнаём сумму больничных в счёт расчётного месяца*/
/***********************************************/
double ras_podog1_sb(int tabn,
short mr,short gr,double *suma_esv_s_bol,GtkWidget *wpredok)
{
extern int kod_esv_bol; /*Код удержания единого социального взноса с больничного*/
extern int kod_esv_bol_inv; /*Код удержания единого социального взноса с больничных для инвалидов*/
SQL_str row;
class SQLCURSOR cur;
char strsql[1024];
int kolstr=0;
*suma_esv_s_bol=0.;
double boln=0.;
sprintf(strsql,"select prn,knah,suma,mesn from Zarp where tabn=%d and datz >= '%04d-%02d-01' and datz <= '%04d-%02d-31' \
and suma <> 0.",tabn,gr,mr,gr,mr);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,__FUNCTION__,strsql,wpredok);
  return(0.);
 }

if(kolstr == 0)
 {
  return(0.);
 }
double nah_suma_bol=0.;
while(cur.read_cursor(&row) != 0)
 {
  if(atoi(row[0]) == 1)
   {  
    if(provkodw(kodbl,atoi(row[1])) >= 0)
     {
      if(mr == atoi(row[3]))
       nah_suma_bol+=atof(row[2]);
      boln+=atof(row[2]);
     }
   }
  else
   {
    int knah=atoi(row[1]);
    if(kod_esv_bol == knah || kod_esv_bol_inv == knah)
     *suma_esv_s_bol+=atof(row[2]);
   }
 }
if(nah_suma_bol > 0.)
 {
  double bb=*suma_esv_s_bol;
  *suma_esv_s_bol=*suma_esv_s_bol*nah_suma_bol/boln;

  sprintf(strsql,"%s-Вычисляем сумму единого социального взноса приходящююся на больничный=%.2f*%.2f/%.2f=%.2f\n",
  __FUNCTION__,bb,nah_suma_bol,boln,*suma_esv_s_bol);
  zar_pr_insw(strsql,wpredok);
 }

return(nah_suma_bol);

}
/*******************************/
/*Расчёт доли подоходного налога с больничного*/
/*************************************************/
double ras_podor1_rpnsb(int tbn,short mr,short gr,int podr,int metka_zap,double suma_nahisl,double lgota,GtkWidget *wpredok)
{
extern float  ppn; //Процент подоходного налога
float proc_pn=ppn;
char strsql[1024];
double suma_esv_s_bol=0.;
double suma_boln= ras_podog1_sb(tbn,mr,gr,&suma_esv_s_bol,wpredok);
double suma_pn_s_bol=0.;

if(iceb_u_sravmydat(1,1,2016,1,mr,gr) <= 0)
 proc_pn=ICEB_PROCENT_PODOH_NAL_2016;

if(suma_boln != 0.)
 {  
  double suma_lgot_for_bol=0.;
  if(lgota > 0.)
   {
    if(suma_nahisl > 0.)
      suma_lgot_for_bol=lgota*suma_boln/suma_nahisl;
    else
      suma_lgot_for_bol=lgota;
   }  

  suma_pn_s_bol=(suma_boln-suma_lgot_for_bol+suma_esv_s_bol)*proc_pn/100.;
  if(suma_pn_s_bol < 0.)
   suma_pn_s_bol=0.;
  else
   suma_pn_s_bol*=-1;

  sprintf(strsql,"%s-Определяем сколько подоходного налога приходится на больничные\n",__FUNCTION__);
  zar_pr_insw(strsql,wpredok);

  suma_pn_s_bol=iceb_u_okrug(suma_pn_s_bol,okrg);  

  sprintf(strsql,"%s-(%.2f-%.2f+%.2f)*%.2f=%.2f\n",__FUNCTION__,suma_boln,suma_lgot_for_bol,suma_esv_s_bol,proc_pn/100.,suma_pn_s_bol);
  zar_pr_insw(strsql,wpredok);
 }

short d=1;

iceb_u_dpm(&d,&mr,&gr,5);

struct ZARP     zp;

zp.tabnom=tbn;
zp.prn=2;
zp.knu=kodpn;
zp.dz=d;
zp.mz=mr;
zp.gz=gr;
zp.mesn=mr; zp.godn=gr;
zp.nomz=0;
zp.podr=podr;

class iceb_u_str shet("");
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tbn,kodpn_sbol);
if(sql_readkey(&bd,strsql,&row,&cur) > 0)
  shet.new_plus(row[0]);
else
 {
  sprintf(strsql,"select shet from Uder where kod=%d",kodpn_sbol);
  if(iceb_sql_readkey(strsql,&row,&cur,wpredok) == 1)
   shet.new_plus(row[0]);
 }

if(shet.getdlinna() <= 1)
 {
  sprintf(strsql,"%s-Не нашли счёт для кода удержания подоходного налога с больничного %d\n",__FUNCTION__,kodpn_sbol);
  zar_pr_insw(strsql,wpredok);
 }
else
 if(metka_zap == 0)
  {
   strcpy(zp.shet,shet.ravno());
   zapzarpw(&zp,suma_pn_s_bol,d,mr,gr,0,shet.ravno(),gettext("с больничного"),0,podr,"",wpredok);
  }

return(suma_pn_s_bol);

}
/************************************************************/
/*расчёт подоходного со стипендии*/
/*********************************/
double ras_podoh1_stip(short mr,short gr,int tabn,class zar_sumtn *tnsum,GtkWidget *wpredok)
{
char strsql[1024];
class zar_read_tn1h nast_mz;
double suma_podoh=0.;

sprintf(strsql,"%s-Расчёт для стипендии\n",__FUNCTION__);
zar_pr_insw(strsql,wpredok);
zar_read_tn1w(1,mr,gr,&nast_mz,wpredok);

sprintf(strsql,"%s-Коэффициент прожиточного минимума=%.2f\n",__FUNCTION__,kof_prog_min);
zar_pr_insw(strsql,wpredok);

sprintf(strsql,"%s-Сумма всех начислений %.2f\n",__FUNCTION__,tnsum->suma_nah_all_podoh);
zar_pr_insw(strsql,wpredok);

double maxsum_bn=nast_mz.prog_min_ng*kof_prog_min;
maxsum_bn=iceb_u_okrug(maxsum_bn,10.);

sprintf(strsql,"%s-Максимальная стипендия с которой не берётся налог %.2f*%.2f=%.2f\n",__FUNCTION__,nast_mz.prog_min_ng,kof_prog_min,maxsum_bn);
zar_pr_insw(strsql,wpredok);

if(maxsum_bn >= tnsum->suma_nah_all_podoh)
 {
  sprintf(strsql,"%s-Налог не берётся так как %.2f > %.2f\n",__FUNCTION__,maxsum_bn,tnsum->suma_nah_all_podoh);
  zar_pr_insw(strsql,wpredok);
  return(0.);  
 }

double proc_podoh=18.;
suma_podoh=(tnsum->suma_nah_all_podoh-maxsum_bn)*proc_podoh/100.;
suma_podoh=iceb_u_okrug(suma_podoh,okrg);

sprintf(strsql,"%s-Сумма налога (%.2f-%.2f)*%.2f/100.=%.2f\n",__FUNCTION__,tnsum->suma_nah_all_podoh,maxsum_bn,proc_podoh,suma_podoh);
zar_pr_insw(strsql,wpredok);

return(suma_podoh*-1);

}
/********************************************/
/*Расчёт долей подоходного налога на заданные коды начисления*/
/*****************************************************************/

double ras_podoh1_dpn(short mr,short gr,int tabn,class zar_sumtn *tnsum,double suma_pod_nal,int podr,
GtkWidget *wpredok)
{
class SQLCURSOR cur;
SQL_str row;
double suma_podoh_zap=0.; /*Записанная сумма подоходного налога*/
double suma_podoh_r=0.; /*сумма доли на одно начисление*/
class iceb_u_str shet("");
char strsql[1024];
class ZARP     zp;
short d=0;

if(tnsum->sndrdpn.kolih() <= 0)
 return(0.);
 
iceb_u_dpm(&d,&mr,&gr,5);

zp.tabnom=tabn;
zp.prn=2;
zp.knu=0;
zp.dz=d;
zp.mz=mr;
zp.gz=gr;
zp.mesn=mr; 
zp.godn=gr;
zp.nomz=0;
zp.podr=podr;
 
sprintf(strsql,"%s-%s\n",__FUNCTION__,gettext("Расчёт долей подоходного налога на заданные коды начислений"));
zar_pr_insw(strsql,wpredok);

for(int nom=0; nom < tnsum->sndrdpn.kolih(); nom++)
 {
  if(tnsum->sndrdpn.ravno(nom) == 0.)
   continue;

  gchar *koment;
  koment=g_strdup_printf("%s-Код начисления %s Сумма начисления %.2f\n",__FUNCTION__,skndr.ravno(nom),tnsum->sndrdpn.ravno(nom));
  zar_pr_insw(koment,wpredok);
  g_free(koment);      

  /*Проверяем есть ли код удержания подоходного налога в списке*/

  sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tabn,kudzr.ravno(nom));
  if(sql_readkey(&bd,strsql,&row,&cur) <= 0)
   {
    sprintf(strsql,"%s-%s %d\n",__FUNCTION__,gettext("Не введено код удержания"),kudzr.ravno(nom));
    zar_pr_insw(strsql,wpredok);
    return(0.);
   }
  shet.new_plus(row[0]);

  strcpy(zp.shet,shet.ravno()); 
 /*******
 расчёт доли

 пропорция:
 suma_nah_all_podoh    suma_pod_nal
 sndrdpn                   X
 
    формула расчёта
  suma_podoh_r = sndrdpn  * suma_pod_nal / suma_nah_all_podoh
******/ 

  suma_podoh_r=0.;
  if(tnsum->sndrdpn.ravno(nom) != 0. && suma_pod_nal != 0. && tnsum->suma_nah_all_podoh != 0.)
   {
    suma_podoh_r=tnsum->sndrdpn.ravno(nom)*suma_pod_nal/tnsum->suma_nah_all_podoh;
    suma_podoh_r=iceb_u_okrug(suma_podoh_r,okrg);

    koment=g_strdup_printf("%s-%f*%f/%f=%f\n",__FUNCTION__,tnsum->sndrdpn.ravno(nom),suma_pod_nal,tnsum->suma_nah_all_podoh,suma_podoh_r);
    zar_pr_insw(koment,wpredok);
    g_free(koment);      

   }
  else
   {
     if(tnsum->sndrdpn.ravno(nom) == 0.)
      {
       koment=g_strdup_printf("%s-Нулевая сумма на данное начисление!\n",__FUNCTION__);
       zar_pr_insw(koment,wpredok);
       g_free(koment);      

       koment=g_strdup_printf("%s-Сумма подоходного налога для распределения равна нолю!\n",__FUNCTION__);
       zar_pr_insw(koment,wpredok);
       g_free(koment);      

       koment=g_strdup_printf("%s-Сумма всех начислений равна нолю!\n",__FUNCTION__);
       zar_pr_insw(koment,wpredok);
       g_free(koment);      
      }
   
   }
       
  zp.knu=kudzr.ravno(nom);

  koment=g_strdup_printf("%s-Записываем на код удержания %d\n",__FUNCTION__,kudzr.ravno(nom));
  zar_pr_insw(koment,wpredok);
  g_free(koment);      

  koment=g_strdup_printf("%s-%s",gettext("Доля подоходного на код начисления"),skndr.ravno(nom));

  zapzarpw(&zp,suma_podoh_r,d,mr,gr,0,shet.ravno(),koment,0,podr,"",0,wpredok); 
  g_free(koment);
 
  suma_podoh_zap+=suma_podoh_r;
 
 }
 



return(suma_podoh_zap);
}
