/*$Id: l_sptbn_p.c,v 1.14 2013/08/25 08:26:39 sasa Exp $*/
/*08.05.2019	15.09.2006	Белых А.И.	l_sptbn_p.c
Меню для ввода реквизитов поиска
*/
#include "buhg_g.h"
#include "l_sptbn.h"

enum
{
  FK2,
  FK4,
  FK10,
  KOL_F_KL
};

enum
 {
  E_FIO,
  E_INN,
  E_METKA_NKS,
  E_NOMKS,
  KOLENTER  
 };

class l_sptbn_p_data
 {
  public:
  class l_sptbn_p *rpoi;
    
  GtkWidget *entry[KOLENTER];
  GtkWidget *knopka[KOL_F_KL];
  GtkWidget *window;
  GtkWidget *opt;
  short kl_shift;
  
  
  l_sptbn_p_data() //Конструктор
   {
    kl_shift=0;
  
   }

  void read_rek()
   {
    for(int i=0; i < KOLENTER; i++)
      g_signal_emit_by_name(entry[i],"activate");
   }
  void clear_rek()
   {
    for(int i=0; i < KOLENTER; i++)
      gtk_entry_set_text(GTK_ENTRY(entry[i]),"");
    rpoi->clear_rek();
   }
 };

gboolean   l_sptbn_p_key_press(GtkWidget *widget,GdkEventKey *event,class l_sptbn_p_data *data);
void    l_sptbn_p_vvod(GtkWidget *widget,class l_sptbn_p_data *data);
void  l_sptbn_p_knopka(GtkWidget *widget,class l_sptbn_p_data *data);

extern SQL_baza bd;

int l_sptbn_p(class l_sptbn_p *datap,GtkWidget *wpredok)
{
l_sptbn_p_data data;
data.rpoi=datap;

char strsql[512];

data.window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_position( GTK_WINDOW(data.window),ICEB_POS_CENTER);
gtk_window_set_modal(GTK_WINDOW(data.window),TRUE);

sprintf(strsql,"%s %s",iceb_get_namesystem(),gettext("Поиск"));
gtk_window_set_title (GTK_WINDOW (data.window),strsql);
gtk_container_set_border_width (GTK_CONTAINER (data.window), 5);

g_signal_connect(data.window,"delete_event",G_CALLBACK(gtk_widget_destroy),NULL);
g_signal_connect(data.window,"destroy",G_CALLBACK(gtk_main_quit),NULL);

g_signal_connect_after(data.window,"key_press_event",G_CALLBACK(l_sptbn_p_key_press),&data);

if(wpredok != NULL)
 {
  gdk_window_set_cursor(gtk_widget_get_window(wpredok),gdk_cursor_new_for_display(gtk_widget_get_display(wpredok),ICEB_CURSOR_GDITE));
  //Удерживать окно над породившем его окном всегда
  gtk_window_set_transient_for(GTK_WINDOW(data.window),GTK_WINDOW(wpredok));
  //Закрыть окно если окно предок удалено
  gtk_window_set_destroy_with_parent(GTK_WINDOW(data.window),TRUE);
 }


GtkWidget *label=gtk_label_new(gettext("Поиск"));

GtkWidget *vbox = gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
gtk_box_set_homogeneous (GTK_BOX(vbox),FALSE); //Устанавливает одинакоый ли размер будут иметь упакованные виджеты-TRUE-одинаковые FALSE-нет
GtkWidget *hbox[KOLENTER];
for(int i=0; i < KOLENTER; i++)
 {
  hbox[i] = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
gtk_box_set_homogeneous (GTK_BOX(  hbox[i]),FALSE); //Устанавливает одинакоый ли размер будут иметь упакованные виджеты-TRUE-одинаковые FALSE-нет
 }

GtkWidget *hboxknop = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
gtk_box_set_homogeneous (GTK_BOX(hboxknop),FALSE); //Устанавливает одинакоый ли размер будут иметь упакованные виджеты-TRUE-одинаковые FALSE-нет

gtk_container_add (GTK_CONTAINER (data.window), vbox);
gtk_container_add (GTK_CONTAINER (vbox), label);

for(int i=0; i < KOLENTER; i++)
  gtk_container_add (GTK_CONTAINER (vbox), hbox[i]);

gtk_container_add (GTK_CONTAINER (vbox), hboxknop);

sprintf(strsql,"%s (,,)",gettext("Фамилия"));
label=gtk_label_new(strsql);
data.entry[E_FIO] = gtk_entry_new ();
gtk_entry_set_max_length(GTK_ENTRY(data.entry[E_FIO]),100);
gtk_box_pack_start (GTK_BOX (hbox[E_FIO]), label, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (hbox[E_FIO]), data.entry[E_FIO], TRUE, TRUE, 0);
g_signal_connect(data.entry[E_FIO], "activate",G_CALLBACK(l_sptbn_p_vvod),&data);
gtk_entry_set_text(GTK_ENTRY(data.entry[E_FIO]),data.rpoi->fio.ravno());
gtk_widget_set_name(data.entry[E_FIO],iceb_u_inttochar(E_FIO));

sprintf(strsql,"%s (,,)",gettext("Идентификационный номер"));
label=gtk_label_new(strsql);
data.entry[E_INN] = gtk_entry_new ();
gtk_entry_set_max_length(GTK_ENTRY(data.entry[E_INN]),60);
gtk_box_pack_start (GTK_BOX (hbox[E_INN]), label, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (hbox[E_INN]), data.entry[E_INN], TRUE, TRUE, 0);
g_signal_connect(data.entry[E_INN], "activate",G_CALLBACK(l_sptbn_p_vvod),&data);
gtk_entry_set_text(GTK_ENTRY(data.entry[E_INN]),data.rpoi->inn.ravno());
gtk_widget_set_name(data.entry[E_INN],iceb_u_inttochar(E_INN));

sprintf(strsql,"%s (+/-)",gettext("Наличие карт-счёта"));
label=gtk_label_new(strsql);
data.entry[E_METKA_NKS] = gtk_entry_new ();
gtk_entry_set_max_length(GTK_ENTRY(data.entry[E_METKA_NKS]),1);
gtk_box_pack_start (GTK_BOX (hbox[E_METKA_NKS]), label, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (hbox[E_METKA_NKS]), data.entry[E_METKA_NKS], TRUE, TRUE, 0);
g_signal_connect(data.entry[E_METKA_NKS], "activate",G_CALLBACK(l_sptbn_p_vvod),&data);
gtk_entry_set_text(GTK_ENTRY(data.entry[E_METKA_NKS]),data.rpoi->inn.ravno());
gtk_widget_set_name(data.entry[E_METKA_NKS],iceb_u_inttochar(E_METKA_NKS));

sprintf(strsql,"%s (,,)",gettext("Номер карт-счёта"));
label=gtk_label_new(strsql);
data.entry[E_NOMKS] = gtk_entry_new ();
gtk_entry_set_max_length(GTK_ENTRY(data.entry[E_NOMKS]),100);
gtk_box_pack_start (GTK_BOX (hbox[E_NOMKS]), label, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (hbox[E_NOMKS]), data.entry[E_NOMKS], TRUE, TRUE, 0);
g_signal_connect(data.entry[E_NOMKS], "activate",G_CALLBACK(l_sptbn_p_vvod),&data);
gtk_entry_set_text(GTK_ENTRY(data.entry[E_NOMKS]),data.rpoi->nomks.ravno());
gtk_widget_set_name(data.entry[E_NOMKS],iceb_u_inttochar(E_NOMKS));

sprintf(strsql,"F2 %s",gettext("Поиск"));
data.knopka[FK2]=gtk_button_new_with_label(strsql);
gtk_widget_set_tooltip_text(data.knopka[FK2],gettext("Начать поиск нужных записей"));
g_signal_connect(data.knopka[FK2],"clicked",G_CALLBACK(l_sptbn_p_knopka),&data);
gtk_widget_set_name(data.knopka[FK2],iceb_u_inttochar(FK2));
gtk_box_pack_start(GTK_BOX(hboxknop), data.knopka[FK2], TRUE, TRUE, 0);

sprintf(strsql,"F4 %s",gettext("Очистить"));
data.knopka[FK4]=gtk_button_new_with_label(strsql);
gtk_widget_set_tooltip_text(data.knopka[FK4],gettext("Очистить меню от введенной информации"));
g_signal_connect(data.knopka[FK4],"clicked",G_CALLBACK(l_sptbn_p_knopka),&data);
gtk_widget_set_name(data.knopka[FK4],iceb_u_inttochar(FK4));
gtk_box_pack_start(GTK_BOX(hboxknop), data.knopka[FK4], TRUE, TRUE, 0);


sprintf(strsql,"F10 %s",gettext("Выход"));
data.knopka[FK10]=gtk_button_new_with_label(strsql);
gtk_widget_set_tooltip_text(data.knopka[FK10],gettext("Завершение работы в этом окне"));
g_signal_connect(data.knopka[FK10],"clicked",G_CALLBACK(l_sptbn_p_knopka),&data);
gtk_widget_set_name(data.knopka[FK10],iceb_u_inttochar(FK10));
gtk_box_pack_start(GTK_BOX(hboxknop), data.knopka[FK10], TRUE, TRUE, 0);

gtk_widget_grab_focus(data.entry[0]);

gtk_widget_show_all (data.window);


gtk_main();
//printf("l_l_sptbn_p-metka_poi=%d\n",data.rpoi->metka_poi);

return(0);
}

/*********************************/
/*Обработка нажатия клавиш       */
/*********************************/

gboolean   l_sptbn_p_key_press(GtkWidget *widget,GdkEventKey *event,class l_sptbn_p_data *data)
{

//printf("l_sptbn_p_key_press\n");
switch(event->keyval)
 {

  case GDK_KEY_F2:
    g_signal_emit_by_name(data->knopka[FK2],"clicked");
    return(TRUE);

  case GDK_KEY_F4:
    g_signal_emit_by_name(data->knopka[FK4],"clicked");
    return(TRUE);

    
  case GDK_KEY_Escape:
  case GDK_KEY_F10:
    g_signal_emit_by_name(data->knopka[FK10],"clicked");
    return(FALSE);

  case ICEB_REG_L:
  case ICEB_REG_R:
//    printf("Нажата клавиша Shift\n");

    data->kl_shift=1;

    return(TRUE);
 }

return(TRUE);
}
/*****************************/
/*Обработчик нажатия кнопок  */
/*****************************/
void  l_sptbn_p_knopka(GtkWidget *widget,class l_sptbn_p_data *data)
{

int knop=atoi(gtk_widget_get_name(widget));

switch (knop)
 {
  case FK2:
    data->read_rek(); //Читаем реквизиты меню

    gtk_widget_destroy(data->window);
    data->window=NULL;
    data->rpoi->metka_poi=1;
    return;  


  case FK4:
    data->clear_rek();
    return;
    
  case FK10:
    data->read_rek(); //Читаем реквизиты меню
    gtk_widget_destroy(data->window);
    data->window=NULL;
    data->rpoi->metka_poi=0;
    return;
 }
}
/********************************/
/*Перевод чтение текста и перевод фокуса на следующюю строку ввода*/
/******************************************/

void    l_sptbn_p_vvod(GtkWidget *widget,class l_sptbn_p_data *data)
{
//short d,m,g;

int enter=atoi(gtk_widget_get_name(widget));
//g_print("l_sptbn_p_vvod enter=%d\n",enter);

switch (enter)
 {
  case E_FIO:
    data->rpoi->fio.new_plus(gtk_entry_get_text(GTK_ENTRY(widget)));
    break;

  case E_INN:
    data->rpoi->inn.new_plus(gtk_entry_get_text(GTK_ENTRY(widget)));
    break;

  case E_METKA_NKS:
    data->rpoi->metka_nks.new_plus(gtk_entry_get_text(GTK_ENTRY(widget)));
    break;

  case E_NOMKS:
    data->rpoi->nomks.new_plus(gtk_entry_get_text(GTK_ENTRY(widget)));
    break;


 }

enter+=1;

if(enter >= KOLENTER)
enter=0;


gtk_widget_grab_focus(data->entry[enter]);
 
}
