/*$Id: b_skarbw.c,v 1.12 2013/08/13 06:09:31 sasa Exp $*/
/*18.03.2012	15.10.2008	Белых А.И.	b_skarbw.c
Экспорт платёжек в систему АБС "СКАРБ" для Сбербанка

Имя файла произвольное с обязательным первым символом "$"
Кодировка файла cp866


Структура информационной строки
-----------------------------------------------------------
N   Наименование          Тип   Позиция   Содержимое
-----------------------------------------------------------
1   МФО банка А           N9    1-9       Имеет не меньше 6 цифр. Равно МФО банка - отправителя
2   Лицевой счёт клиента  N14   10-23     Имеет не меньше 5 цифр
    банка А
3   МФО банка Б           N9    24-33     Имеет не меньше 6 цифр. Равно МФО банка - получателя
4   Лицевой счёт клиента  N14   33-46     Имеет не меньше 5 цифр
    банка Б
5   Флаг "дебет/кредит"   С1    47-47     Признак определяестя по отношению к банку-получателю
    платежа                               платёжного документа (тоесть, кредитовый документ - 
                                          банк А переводит деньги банку Б)
                                          Может принимать значения 0,1,2,3
                                          0-дебет
                                          1-кредит
                                          2-дебет (информационный запрос)
                                          3-кредит (информационный запрос)
6   Сумма платежа         N16   48-63     
7   Вид документа         N2    64-65     1-платёжное поручение
                                          2-платёжное требование
                                          6-мемориальный ордер
8   Номер (операционный)  С10   66-75     
    платежа                                        
9   Валюта платежа        N3    76-78     
10  Дата платёжного док-  D6    79-84     Дата указанная в первичном платёжном документе
    умента
11  Дата поступлени пла-  D6    85-90
    тёжног документа в
    банк А
12  Наименование платель- С38   91-128
    щика (клиент А)
13  Наименование получа-  С38   129-166
    теля (клиет Б)
14  Назначение платежа    С160  167-326
15  Вспомогательные       С60   327-386
    реквизиты
16  Код назначения пла-   С3    387-389
    тежа
17  Способ заполнения     С2    390-391
    реквизитов 14-16
18  Идентефикатор клиента С14   392-405
    А
19  Идентефикатор клиента С14   406-419
    Б
20  Идентефикатор доку-   N9    420-428  Уникальный номер в течении дня
    мента
21  Время проводки доку-  N4    429-432
    мента
22  CRLF                  B2    593-594  Возврат каретки + перевод строки

Пример файла

375218   26000301454   315643   260045013010521         1138803 11961      980081013081013ТОВ "Шепетiвський м"ясокомбiнат"      П-ць Вознюк Лiлiя Петрiвна            за прийняту худобу по кв. N   3224 вiд 10.10.2008   Без ПДВ. трансп. i оргвитр.  2695.41                                                                                                                                       1400444257      2718402683           11                                                                                                                                                                    
375218   26000301454   375155   26006305086   1         2306582 11962      980081013081013ТОВ "Шепетiвський м"ясокомбiнат"      Гаврилюк Микола Васильовч             за прийняту худобу по кв. N   3238 вiд 10.10.2008   Без ПДВ. трансп. i оргвитр.  2150.13                                                                                                                                       1400444257      2615508957           12                                                                                                                                                                    
375218   26000301454   375218   2600950895    1         1571921 11963      980081013081013ТОВ "Шепетiвський м"ясокомбiнат"      П-ЦЬ ДЕМЧИШИН ВАСИЛЬ ДМИТ             за прийняту худобу по кв. N   3241 вiд 10.10.2008   Без ПДВ. трансп. i оргвитр.  1349.57                                                                                                                                       1400444257      2015722510           13                                                                                                                                                                    

*/

#include        <errno.h>
#include        <math.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern struct REC rec;
extern SQL_baza bd;

int b_skarbw(const char *tabl,GtkWidget *wpredok)
{
char		imaf1[32];
FILE		*ff1;
class iceb_u_str koment("");
char		strsql[512];
short		d,m,g;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }
sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  iceb_er_op_fil(imaf1,"",errno,wpredok);
  return(1);
 }
int suma_int=0;
double suma_double=0.;
double bb=0.;
while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);

  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;

  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_u_okrug(rec.sumd,0.01);

  bb=rec.sumd*100.;
 
  modf(bb,&suma_double);
  suma_int=(int)suma_double;

  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);

  fprintf(ff1,"%-9.9s\
%-14.14s\
%-9.9s\
%-14.14s\
%1d\
%16d\
%2d\
%-10.10s\
%3d\
%02d%02d%02d\
%02d%02d%02d\
%-*.*s\
%-*.*s\
%-*.*s\
%-60.60s\
%-3.3s\
%-2.2s\
%-14.14s\
%-14.14s\
%173s\r\n",
  rec.mfo.ravno(),
  rec.nsh.ravno(),
  rec.mfo1.ravno(),
  rec.nsh1.ravno(),
  1,
  suma_int,
  1,
  rec.nomdk.ravno(),
  980,
  g-2000,m,d,
  g-2000,m,d,
  iceb_u_kolbait(38,rec.naior.ravno()),iceb_u_kolbait(38,rec.naior.ravno()),rec.naior.ravno(),
  iceb_u_kolbait(38,rec.naior1.ravno()),iceb_u_kolbait(38,rec.naior1.ravno()),rec.naior1.ravno(),
  iceb_u_kolbait(160,koment.ravno()),iceb_u_kolbait(160,koment.ravno()),koment.ravno(),
  "",
  "",
  "14",
  rec.kod.ravno(),
  rec.kod1.ravno(),
  "");
  
 }

fclose(ff1);
iceb_perecod(2,imaf1,wpredok);
return(0);
}
