/*$Id:$*/
/*26.02.2021	26.02.2021	Белых А.И.	b_privat_csvw.cpp
Платёжка в формате csv

Шановний клієнт! Просимо звернути увагу, якщо у одержувача відсутній Код
ЄДРПОУ/ІПН, обов'язково введіть у поле OKPO_B - 0000000000 та коректно заповніть
поля “Серія паспорту отримувача (SER_PAS_В)” та “Номер паспорту отримувача
(NOM_PAS_В.)”. Якщо Ви маєте "Електронний паспорт громадянина України" коректно
заповніть “Номер паспорту отримувача (NOM_PAS_В.)”, а поле “Серія паспорту
отримувача (SER_PAS_В)” залиште пустим.




Назва поля     Опис поля                                                      Приклад

N_D            Номер документу                                                77
SUMMA          Сума платежу                                                   2015.99
COUNT_A        Номер рахунку платника                                         UA003052990000026001555777001
NAME_B         Найменування отримувача                                        ТОВ Львів
COUNT_B        Номер рахунку/картки (рахунок тільки уформаті IBAN) отримувача UA003052990000026001555777001/1234123412341234
N_P            Призначення платежу                                            Оплата згідно угоди 22 від 01.01.2015р., ПДВ ...
OKPO_B         Код ЄДРПОУ / ІПН отримувача                                    13422702
SER_PAS_В      Серія паспорту отримувача АК
NOM_PAS_В      Номер паспорту/id паспортуотримувача                           126126 (126126126 для id паспорту)

*/

#include        <errno.h>
#include        <math.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern class REC rec;
extern SQL_baza bd;

int b_privat_csvw(const char *tabl,GtkWidget *wpredok) /*выгрузка в csv файл*/
{
char		imaf1[64];
FILE		*ff1;
class iceb_u_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }







sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  iceb_er_op_fil(imaf1,__FUNCTION__,errno,wpredok);
  return(1);
 }

fprintf(ff1,"\
N_D;SUMMA;COUNT_A;NAME_B;COUNT_B;N_P;OKPO_B;SER_PAS_B;NOM_PAS_B\n");

while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);

  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;

  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);

  fprintf(ff1,"%s;%.2f;%s;%s;%s;\"%s\";%s;%s;%s;\n",
  rec.nomdk.ravno(),
  rec.sumd,
  rec.nsh.ravno(),
  rec.naior1.ravno(),
  rec.nsh1.ravno(),
  koment.ravno(),
  rec.kod1.ravno(),
  "",
  "");
 }

fclose(ff1);

return(0);
}
 