/*$Id: b_iBank_2_UA.c,v 5.17 2013/08/13 05:49:46 sasa Exp $*/
/*03.09.2021	02.09.2021	Белых А.И.	b_iFOBS_xmlw.c


<?xml version= «1.0» encoding= «windows-1251»?>
<ROWDATA>
<ROW ... />
—
...
<ROW ... /> —
</ROWDATA>





RU_Импорт из XML-файла фиксированной структуры в формате
ANSI
ROWDATA – корневой узел XML документа, содержит все импортируемые документы. Каждому документу соответствует один тэг
<ROW ... />. Внутри тэга <ROW ... /> должны быть указаны значения всех требуемых атрибутов.
Допустимые имена атрибутов и их назначение приведены в следующей таблице. Реквизиты, необязательные для заполнения,
выделены серым цветом.
Порядок следования атрибутов в тэге <ROW ... /> значения не имеет. Атрибуты, которые отличаются от описанных
игнорируются. Регистр написания атрибута (все заглавные буквы) учитывается при импорте в Web-приложение iFOBS. В теле
XML документа допускаются комментарии согласно спецификации XML ( http://www.w3.org/TR/2004/REC-xml-20040204/ ).
Для успешного проведения процедуры импорта исходный файл должен соответствовать стандарту XML (простейшую проверку
на правильность XML-документа можно произвести открыв файл в Internet Explorer).
В случае если импорт документа завершается неудачно, создается XML файл с ошибками. Структура файла ошибок такая же,
как и структура файла импорта, корневой узел называется RowImportErrors, а текст ошибки приводится в виде текстового поля
соответствующего узла ROW, например: <ROW … >Ошибка при обработке значения поля «CorrBankId»: «Банк с кодом «32000»
не найден в справочнике банков» </ROW>.

AMOUNT           Сумма платежа в копейках             Целое число
CORRSNAME        Наименование получателя платежа 
DETAILSOFPAYMENT Назначение платежа 
CORRACCOUNTNO    № счета получателя платежа
CORRIBAN         IBAN получателя платежа              Строго 29 символов. Только латинские буквы и цифры.
ACCOUNTNO        № счета плательщика
IBAN             IBAN плательщика                     Строго 29 символов. Только латинские буквы и цифры.
CORRBANKID       Код банка получателя платежа (МФО)
CORRIDENTIFYCODE Идентификационный код получателя платежа 
                 (ЕГРПОУ)
CORRCOUNTRYID    Код страны корреспондента            При отсутствии автоматически выбирается Украина (804)
DOCUMENTNO       № документа                          Если номер не указан, будет использоваться автонумерация
VALUEDATE        Дата валютирования
PRIORITY         Приоритет                            По умолчанию 50
DOCUMENTDATE     Дата документа                       ГГГГММДД
ADDENTRIES       Дополнительные реквизиты платежа
PURPOSEPAYMENTID Код назначения платежа               Целое 3-значное число
BANKID           Код банка плательщика (МФО)
CORRCLIENTTYPE   Тип клиента-получателя

*/

#include        <errno.h>
#include        <math.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern class REC rec;
extern SQL_baza bd;

int b_iFOBS_xmlw(const char *tabl,GtkWidget *wpredok)
{
char		imaf1[64];
class iceb_u_str koment("");
char		strsql[1024];
short		d,m,g;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }

class iceb_fopen fil_ff;

sprintf(imaf1,"plat.txt");
if(fil_ff.start(imaf1,"w",wpredok) != 0)
 return(1);

fprintf(fil_ff.ff,"<?xml version= \"1.0\" encoding= \"windows-1251\"?>\n\
<ROWDATA>\n");

/*****************
fprintf(fil_ff.ff,"<?xml version= \"1.0\" encoding= \"UTF8\"?>\n\
<ROWDATA>\n");
*************/

/*Так как в системе предусморено только 40 символов для наименования организации то нужно брать короткое наименование*/

while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);
  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;
  
  class iceb_u_str naior(rec.naior.ravno());
  class iceb_u_str naior1(rec.naior1.ravno());
 
  if(iceb_u_strlen(rec.naior.ravno()) > 40)
   {
    naior.new_plus(iceb_get_pnk(rec.kodor.ravno(),0,wpredok));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 40 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_menu_soob(strsql,wpredok);

   }

#if 0
#########################
  if(iceb_u_strlen(rec.naior1.ravno()) > 40)
   {
    if(rec.kodor1.getdlinna() > 1) /*При выборе контрагента из файла код контрагента может быть не определён*/
     {
      naior1.new_plus(iceb_get_pnk(rec.kodor1.ravno(),0));

      sprintf(strsql,"%s %s %s\n%s %s",
      gettext("Наименование контрагента"),
      rec.naior1.ravno(),
      gettext("больше 40 символов"),
      gettext("заменили на короткое"),
      naior1.ravno());

      iceb_soob(strsql);


     }
   }
####################
#endif

  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);

/*********************************
  dv=rec.dv;
  mv=rec.mv;
  gv=rec.gv;
  if(dv == 0)
   {
    dv=d;
    mv=m;
    gv=g;
   }
  fprintf(fil_ff.ff,"\
DATE_DOC=%02d.%02d.%04d\n\
NUM_DOC=%s\n\
AMOUNT=%.2f\n\
CLN_NAME=%.*s\n\
CLN_OKPO=%s\n\
CLN_ACCOUNT=%s\n\
CLN_BANK_NAME=%.*s\n\
CLN_BANK_MFO=%s\n\
RCPT_NAME=%.*s\n\
RCPT_OKPO=%s\n\
RCPT_ACCOUNT=%s\n\
RCPT_BANK_NAME=%.*s\n\
RCPT_BANK_MFO=%.6s\n\
PAYMENT_DETAILS=%.*s\n\
VALUE_DATE=%02d.%02d.%04d\n\n",
  d,m,g,
  row[1],
  rec.sumd,
  iceb_u_kolbait(40,naior.ravno()),naior.ravno(),
  rec.kod.ravno(),
  rec.nsh.ravno(),
  iceb_u_kolbait(45,rec.naiban.ravno()),rec.naiban.ravno(),
  rec.mfo.ravno(),
  iceb_u_kolbait(40,naior1.ravno()),naior1.ravno(),
  rec.kod1.ravno(),
  rec.nsh1.ravno(),
  iceb_u_kolbait(45,rec.naiban1.ravno()),rec.naiban1.ravno(),
  rec.mfo1.ravno(),
  iceb_u_kolbait(160,koment.ravno()),koment.ravno(),
  dv,mv,gv);
*********************/


  int summa=0;
  double cel=0.;
  modf(rec.sumd*100.,&cel);
  summa=(int)cel;

  class iceb_u_str naim_kontr(iceb_u_filtr_xml(naior1.ravno()));

  fprintf(fil_ff.ff,"<ROW\n\
 AMOUNT=\"%d\" \n\
 CORRSNAME=\"%s\" \n\
 DETAILSOFPAYMENT=\"%s\" \n\
 CORRIBAN=\"%s\" \n\
 IBAN=\"%s\" \n\
 CORRBANKID=\"%s\" \n\
 CORRIDENTIFYCODE=\"%s\" \n\
 CORRCOUNTRYID=\"%s\" \n\
 DOCUMENTNO=\"%s\" \n\
 PRIORITY=\"%s\" \n\
 DOCUMENTDATE=\"%04d%02d%02d\" \n\
 PURPOSEPAYMENTID=\"%s\" \n\
 BANKID=\"%s\"/>\n\n",
  summa,
  naim_kontr.ravno(),
  iceb_u_filtr_xml(koment.ravno()),
  rec.nsh1.ravno(),
  rec.nsh.ravno(),
  rec.mfo1.ravno(),
  rec.kod1.ravno(),
  "804",
  row[1],
  "50",
  g,m,d,
  "777",
  rec.mfo.ravno());

/******************  
AMOUNT           Сумма платежа в копейках             Целое число
CORRSNAME        Наименование получателя платежа 
DETAILSOFPAYMENT Назначение платежа 
#CORRACCOUNTNO    № счета получателя платежа
CORRIBAN         IBAN получателя платежа              Строго 29 символов. Только латинские буквы и цифры.
#ACCOUNTNO        № счета плательщика
IBAN             IBAN плательщика                     Строго 29 символов. Только латинские буквы и цифры.
CORRBANKID       Код банка получателя платежа (МФО)
CORRIDENTIFYCODE Идентификационный код получателя платежа 
                 (ЕГРПОУ)
CORRCOUNTRYID    Код страны корреспондента            При отсутствии автоматически выбирается Украина (804)
DOCUMENTNO       № документа                          Если номер не указан, будет использоваться автонумерация
#VALUEDATE        Дата валютирования
PRIORITY         Приоритет                            По умолчанию 50
DOCUMENTDATE     Дата документа                       ГГГГММДД
#ADDENTRIES       Дополнительные реквизиты платежа
PURPOSEPAYMENTID Код назначения платежа               Целое 3-значное число
BANKID           Код банка плательщика (МФО)
#CORRCLIENTTYPE   Тип клиента-получателя
*************/
 }

fprintf(fil_ff.ff,"</ROWDATA>\n");


fil_ff.end();
iceb_perecod(2,imaf1,wpredok);
return(0);
}
