/*$Id: b_iBank_2_UAw.c,v 1.13 2013/08/13 06:09:31 sasa Exp $*/
/*14.01.2024	09.06.2006	Белых А.И.	b_iBank_2_UA.c

Экспорт платёжек для системы iBank 2 UA
Кодировка Сp1251
---------------------------------------------------------------
Наименование    Описание                        Тип        
поля
---------------------------------------------------------------
DATE_DOC        Дата документа                  date     10
NUM_DOC         Номер документа                 string   10
AMOUNT          Сумма документа                 decimal  11.2
CLN_NAME        Наименование плательщика        string   40
CLN_OKPO        ЕГРПОУ плательщика              string   10
CLN_ACCOUNT     Счёт плательщика                string   14
CLN_BANK_NAME   Наименование банка плательщика  string   45
CLN_BANK_MFO    МФО банка плательщика           string   6
RCPT_NAME       Наименование получателя         string   40
RCPT_OKPO       ЕГРПОУ получателя               string   10
RCPT_ACCOUNT    Счёт получателя                 string   14
RCPT_BANK_NAME  Наименование банка получателя   string   45
RCPT_BANK_MFO   МФО банка получателя            string   6
PAYMENT_DETAILS Назначение платежа              string   160
VALUE_DATE      Дата валютирования              date     10

BP_TAXCODE      код виду сплати бюджетного платежу. Число, до 6 знакiв. Обов’язкове
                для бюджетних платежiв (в яких не заповнене поле PAYMENT_DETAILS ) з шаблоном
                «Сплата на бюджетнi/небюджетнi рахунки». Повинен вiдповiдати значенню з довiдникiв
                видiв сплати бюджету, що налаштовується на сторонi банку. Також в цьому випадку iгно-
                руються i не заповнюються поля BP_INCOME_CODE, BP_ACCOUNT та BP_TAXMSG.
                Поле BP_TAXCODE iгнорується та не заповнюється для бюджетних платежiв з iншими
                шаблонами або для не бюджетних платежiв (в яких заповнене поле PAYMENT_DETAILS ).



BP_ADD_INFO    додаткова iнформацiя запису структурованого призначення бюдже-
               тного платежу, не бiльше 140 символiв. Обов’язкове для бюджетних платежiв (в яких не
               заповнене поле PAYMENT_DETAILS ). Iгнорується i не заповнюється для не бюджетних
               платежiв.

BP_INCOME_CODE код доходу бюджету. Число, до 8 знакiв. Обов’язкове для бюдже-
               тних платежiв (в яких не заповнене поле PAYMENT_DETAILS ) з шаблоном «Сплата до
               бюджету за оренду державного майна». Також в цьому випадку iгноруються i не заповню-
               ються поля BP_TAXCODE, BP_ACCOUNT та BP_TAXMSG. Поле BP_INCOME_CODE
               iгнорується та не заповнюється для бюджетних платежiв з iншими шаблонами або для не
               бюджетних платежiв (в яких заповнене поле PAYMENT_DETAILS )

BP_ACCOUNT     номер бюджетного рахунка. Може бути вказаний тiльки у форматi IBAN
               (значення довжиною 29 символiв, що мiстить: символи «UA», 2-значну цифрову контроль-
               ну суму, 6-значний цифровий код МФО банка, в якому вiдкритий рахунок та 19-значний
               цифровий номер рахунка. Перевiряється наявнiсть на початку символiв «UA», коректнiсть
               контрольної суми, наявнiсть контрольної суми, наявнiсть вказаного МФО у довiднику МФО,
               а також формат номера рахунка та його ключування з кодом МФО). Обов’язкове для бю-
               джетних платежiв (в яких не заповнене поле PAYMENT_DETAILS ) з шаблоном «Спла-
               та до бюджету на єдиний рахунок» (iз зазначенням напряму коштiв). Також в цьому ви-
               падку iгноруються i не заповнюються поля BP_INCOME_CODE та BP_TAXCODE. Поле
               BP_ACCOUNT iгнорується та не заповнюється для бюджетних платежiв з iншими шабло-
               нами або для не бюджетних платежiв (в яких заповнене поле PAYMENT_DETAILS ).

BP_TAXMSG      iнформацiя про податкове повiдомлення (рiшення), не бiльше 140 симво-
               лiв. Необов’язкове для бюджетних платежiв (в яких не заповнене поле PAYMENT_DETAILS )
               з шаблоном «Сплата до бюджету на єдиний рахунок» (iз зазначенням напряму коштiв).
               Також в цьому випадку iгноруються i не заповнюються поля BP_INCOME_CODE та
               BP_TAXCODE. Поле BP_TAXMSG iгнорується та не заповнюється для бюджетних пла-
               тежiв з iншими шаблонами або для не бюджетних платежiв (в яких заповнене поле
               PAYMENT_DETAILS ).

*/

#include        <errno.h>
#include        <math.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern struct REC rec;
extern SQL_baza bd;

int b_iBank_2_UAw(const char *tabl,GtkWidget *wpredok)
{
char		imaf1[64];
FILE		*ff1;
class iceb_u_str koment("");
char		strsql[1024];
short		d,m,g;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;
class iceb_u_str bp_taxcode("");

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }


if(iceb_menu_vvod1(gettext("Введите код уплаты бюджетного платежа\nЕсли код не введёте то это небюждетный платёж"),&bp_taxcode,6,"",wpredok) != 0)
  return(1);


sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  iceb_er_op_fil(imaf1,"",errno,wpredok);
  return(1);
 }
fprintf(ff1,"Content-Type=doc/ua_payment\n\n");
short dv,mv,gv;


while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);

  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;

  /*Так как в системе предусморено только 40 символов для наименования организации то нужно брать короткое наименование*/
  class iceb_u_str naior(rec.naior.ravno());
  class iceb_u_str naior1(rec.naior1.ravno());
 
  if(iceb_u_strlen(rec.naior.ravno()) > 40)
   {
    naior.new_plus(iceb_get_pnk(rec.kodor.ravno(),0,wpredok));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 40 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_menu_soob(strsql,wpredok);

   }
  if(iceb_u_strlen(rec.naior1.ravno()) > 40)
   {
    if(rec.kodor1.getdlinna() > 1) /*При выборе контрагента из файла код контрагента может быть не определён*/
     {
      naior1.new_plus(iceb_get_pnk(rec.kodor1.ravno(),0,wpredok));

      sprintf(strsql,"%s %s %s\n%s %s",
      gettext("Наименование контрагента"),
      rec.naior1.ravno(),
      gettext("больше 40 символов"),
      gettext("заменили на короткое"),
      naior1.ravno());

      iceb_menu_soob(strsql,wpredok);


     }
   }



  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);

  dv=rec.dv;
  mv=rec.mv;
  gv=rec.gv;
  if(dv == 0)
   {
    dv=d;
    mv=m;
    gv=g;
   }

  if(bp_taxcode.getdlinna() <= 1)
   fprintf(ff1,"\
DATE_DOC=%02d.%02d.%04d\n\
NUM_DOC=%s\n\
AMOUNT=%.2f\n\
CLN_NAME=%.*s\n\
CLN_OKPO=%s\n\
CLN_ACCOUNT=%s\n\
CLN_BANK_NAME=%.*s\n\
CLN_BANK_MFO=%s\n\
RCPT_NAME=%.*s\n\
RCPT_OKPO=%s\n\
RCPT_ACCOUNT=%s\n\
RCPT_BANK_NAME=%.*s\n\
RCPT_BANK_MFO=%.6s\n\
PAYMENT_DETAILS=%.*s\n\
BP_TAXCODE=\n\
BP_ADD_INFO=\n\
BP_INCOME_CODE=\n\
BP_ACCOUNT=\n\
BP_TAXMSG=\n\
VALUE_DATE=%02d.%02d.%04d\n\n",
   d,m,g,
   row[1],
   rec.sumd,
   iceb_u_kolbait(40,naior.ravno()),naior.ravno(),
   rec.kod.ravno(),
   rec.nsh.ravno(),
   iceb_u_kolbait(45,rec.naiban.ravno()),rec.naiban.ravno(),
   rec.mfo.ravno(),
   iceb_u_kolbait(40,naior1.ravno()),naior1.ravno(),
   rec.kod1.ravno(),
   rec.nsh1.ravno(),
   iceb_u_kolbait(45,rec.naiban1.ravno()),rec.naiban1.ravno(),
   rec.mfo1.ravno(),
   iceb_u_kolbait(420,koment.ravno()),koment.ravno(),
   dv,mv,gv);
  else
   fprintf(ff1,"\
DATE_DOC=%02d.%02d.%04d\n\
NUM_DOC=%s\n\
AMOUNT=%.2f\n\
CLN_NAME=%.*s\n\
CLN_OKPO=%s\n\
CLN_ACCOUNT=%s\n\
CLN_BANK_NAME=%.*s\n\
CLN_BANK_MFO=%s\n\
RCPT_NAME=%.*s\n\
RCPT_OKPO=%s\n\
RCPT_ACCOUNT=%s\n\
RCPT_BANK_NAME=%.*s\n\
RCPT_BANK_MFO=%.6s\n\
PAYMENT_DETAILS=\n\
BP_TAXCODE=%s\n\
BP_ADD_INFO=%.*s\n\
BP_INCOME_CODE=\n\
BP_ACCOUNT=\n\
BP_TAXMSG=\n\
VALUE_DATE=%02d.%02d.%04d\n\n",
   d,m,g,
   row[1],
   rec.sumd,
   iceb_u_kolbait(40,naior.ravno()),naior.ravno(),
   rec.kod.ravno(),
   rec.nsh.ravno(),
   iceb_u_kolbait(45,rec.naiban.ravno()),rec.naiban.ravno(),
   rec.mfo.ravno(),
   iceb_u_kolbait(40,naior1.ravno()),naior1.ravno(),
   rec.kod1.ravno(),
   rec.nsh1.ravno(),
   iceb_u_kolbait(45,rec.naiban1.ravno()),rec.naiban1.ravno(),
   rec.mfo1.ravno(),
   bp_taxcode.ravno(),   
   iceb_u_kolbait(140,koment.ravno()),koment.ravno(),
   dv,mv,gv);
  
 }

fclose(ff1);
iceb_perecod(2,imaf1,wpredok);
return(0);
}
