/*$Id:$*/
/*12.04.2023	02.02.2022	Белых А.И.	b_corpex_csvw.cpp
Платёжка в формате csv

Экспорт для подсистемы "CORPEX" 

         !!!!!!!!!!!   Новый формат    !!!!!!!!!!!!!!!!!!


Імпорт платіжної інструкції в національній валюті
(текстовий формат)
Файл імпорту – це текстовий файл фіксованої структури, в якому поля розділені окремим символом-
розподілювачем “|” (pipe), з кодуванням windows-1251. Файл імпорту містить блоки даних Загальні
платіжні реквізити, Отримувач, Фактичний Отримувач та Фактичний Платник. Зазначені блоки даних та
поля в цих блоках мають визначені умови використання та обробки. Основними умовами можна
виділити наступне:
1. Блоки Загальні платіжні реквізити та Отримувач завжди є обов’язковими в файлі
2. Блок Фактичний Отримувач є обов’язковим якщо поле наявності Фактичного Отримувача (№28)
має значення «1»
3. Блок Фактичний Платник є обов’язковим якщо поле наявності Фактичного Платника (№44) має
значення «1»
4. Поля даних адреси є обов’язковими, якщо будь-яку поле адреси заповнене, або якщо поле
Пропрієтарного значення має значення «NA» або «TRAN»
5. Поля даних дати та місця народження або поля даних адреси є обов’язковими, якщо поле
Пропрієтарного значення має значення «UNKN»

Опис полів

Тип даних 
------------------------------------------
N       Числовий
F       Логічне значення: 1 або 0
AN      Буквено-цифровий
D       Дата (DD.MM.YYYY)
M       Обов’язкове
O       Необов’язковий (опціональний)
№
Опис

Тип даних
                   Загальні платіжні реквізити
----------------------------------------------------------------
1  N,5        Порядковий номер рядка в файлі (починаючи з 1)
2  AN,29,M    Номер рахунку Платника
3  AN,35,O    Унікальний ідентифікатор (номер) платіжної інструкції
4  D,O        Дата валютування платіжної інструкції. Поточна дата, якщо поле незаповнене
5  N,16+2,M   Сума коштів переказу
6  AN,420,M   Призначення платіжної інструкції на переказ коштів, неструктурована форма
7  AN,40,M    Поле ПДВ

                    Отримувач
----------------------------------------------------------------
8  AN,34,M    Номер рахунку Отримувача
9  F,O        Наразі не заповнюється
10 AN,29,O    Наразі не заповнюється
11 AN,140,M   Найменування
12 N,3,M      Країна резидентності (ISO 3166-1 числовий)
13 AN,8,M     Пропрієтарне (власне) значення:
              для юридичних осіб - USCR, TRAN, NA
              для фізичних осіб - RNRCT, PSPT, OT, UNKN

14 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN
15 AN,140,O  Ім’я контактної особи, за яким можна ідентифікувати учасника
16 AN,14,O   Номер телефону контактної особи, в форматі +380-ХХХХХХХХХ

                     Дані адреси Отримувача (Місцезнаходження)
-------------------------------------------------------------------
17 AN,70,O   Вулиця
18 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
19 AN,70,O   Номер квартири або офісу
20 AN,16,O   Поштовий індекс
21 AN,35,M   Назва населеного пункту
22 AN,35,O   Назва району
23 AN,35,O   Назва області
24 N,3,O     Код країни (ISO 3166-1 числовий)

                  Дата і місце народження Отримувача
------------------------------------------------------------
25 D,M       Дата народження
26 AN,35,M   Населений пункт, в якому народилася особа
27 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                     Фактичний Отримувач
------------------------------------------------------------
28 F,O       0 або незаповнене – Фактичний Отримувач відсутній;
             1 – Фактичний Отримувач присутній, поля Фактичного Отримувача обов’язкові
29 AN,140,M  Найменування
30 N,3,M     Країна резидентності (ISO 3166-1 числовий)
31 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
32 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

            Дані адреси Фактичного Отримувача (Місцезнаходження)
-------------------------------------------------------------------
33 AN,70,O   Вулиця
34 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
35 AN,70,O   Номер квартири або офісу
36 AN,16,O   Поштовий індекс
37 AN,35,M   Назва населеного пункту
38 AN,35,O   Назва району
39 AN,35,O   Назва області
40 N,3,O     Код країни (ISO 3166-1 числовий)

             Дата і місце народження Фактичного Отримувача
-----------------------------------------------------------
41 D,M       Дата народження
42 AN,35,M   Населений пункт, в якому народилася особа
43 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                       Фактичний Платник
------------------------------------------------------------
44 F,O       0 або незаповнене – Фактичний Платник відсутній;
             1 – Фактичний Платник присутній, поля Фактичного Платника обов’язкові
45 AN,140,M  Найменування
46 N,3,M     Країна резидентності (ISO 3166-1 числовий)
47 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
48 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

             Дані адреси Фактичного Платника (Місцезнаходження)
-------------------------------------------------------------------
49 AN,70,O   Вулиця
50 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
51 AN,70,O   Номер квартири або офісу
52 AN,16,O   Поштовий індекс
53 AN,35,M   Назва населеного пункту
54 AN,35,O   Назва району
55 AN,35,O   Назва області
56 N,3,O     Код країни (ISO 3166-1 числовий)

            Дата і місце народження Фактичного Платника
--------------------------------------------------------------------
57 D,M       Дата народження
58 AN,35,M   Населений пункт, в якому народилася особа
59 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)


*/

#include        <errno.h>
#include        <math.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern class REC rec;
extern SQL_baza bd;

int b_corpex_csvw(const char *tabl,GtkWidget *wpredok) /*выгрузка в csv файл*/
{
char		imaf1[64];
class iceb_u_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }

class iceb_u_str metka_fop("");

sprintf(imaf1,"plat.txt");
class iceb_fopen fil_ff;

if(fil_ff.start(imaf1,"w",wpredok) != 0)
 return(1);

int nomer_str=0;

while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);

  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;

  class iceb_u_str naior(rec.naior.ravno());
  class iceb_u_str naior1(rec.naior1.ravno());
 
  if(iceb_u_strlen(rec.naior.ravno()) > 140)
   {
    naior.new_plus(iceb_get_pnk(rec.kodor.ravno(),0,wpredok));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 140 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_menu_soob(strsql,wpredok);

   }



  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);

  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_u_okrug(rec.sumd,0.01);

  if(iceb_u_strlen(rec.kod1.ravno()) <= 8)
   metka_fop.new_plus("USRC"); /*юридическое лицо*/
  else
   metka_fop.new_plus("RNRCT"); /*физическое лицо*/

  fprintf(fil_ff.ff,"%d|%.29s|%.35s|%02d.%02d.%04d|%.2f|%.*s|%.2f|\
%.34s|||%.*s|%.3s|%.8s|%.35s|||\
||||||||\
|||\
0|||||\
||||||||\
|||\
0||||\
||||||||\
|||\r\n",
  ++nomer_str,
  rec.nsh.ravno(),
  rec.nomdk.ravno(),  
  rec.dd,rec.md,rec.gd,
  rec.sumd,
  iceb_u_kolbait(420,koment.ravno()),
  koment.ravno(),
  rec.nds,      
  rec.nsh1.ravno(),
  iceb_u_kolbait(140,naior1.ravno()),
  naior1.ravno(),
  "804",
  metka_fop.ravno(),
  rec.kod1.ravno());
 }

fil_ff.end();

iceb_perecod(2,imaf1,wpredok);

return(0);
}
 