/*$Id:$*/
/*18.01.2022	15.12.2004	Белых А.И.	iceb_tu_int.c
Класс для работы с int-массивами переменной длинны
*/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"util.h"


/****************************/
/*Конструктор объекта       */
/****************************/
iceb_tu_int::iceb_tu_int(int optimz) //0-Без оптимизации 1-с оптимизацией
{
kolz=0;
optimiz=optimz;
masiv_int=NULL;
}

iceb_tu_int::iceb_tu_int() //конструктор без параметров
{
kolz=0;
optimiz=0;
masiv_int=NULL;
}
/****************************/
/*Деструктор класса*/
/****************************/
iceb_tu_int::~iceb_tu_int()
{
 iceb_tu_int::free_class();
}
/****************************************/
/*Записать в добавленный элемент массива*/
/*****************************************/
int iceb_tu_int::plus(int znah) //Значение 
{
return(plus(znah,-1));
}
/****************************************/
/*Записать в добавленный элемент массива*/
/*****************************************/
int iceb_tu_int::plus(const char *znah) //Значение 
{
return(plus(atoi(znah),-1));
}
/****************************************/
/*Записать в добавленный элемент массива*/
/*****************************************/
int iceb_tu_int::plus(char *znah) //Значение 
{
return(plus(atoi(znah),-1));
}
/******************/
/*Очистить массив*/
/******************/
void iceb_tu_int::clear_class()
{
for(int i=0; i < kolz;i++)
  masiv_int[i]=0.;
}

/******************************************************/
/*Добавить значение в масив с увеличением его размера*/
/*******************************************************/

int iceb_tu_int::plus(int znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{
/*
printf("iceb_tu_int::add_masiv_int znah=%f zapis=%d kol=%d kolz=%d\n",
znah,zapis,kol,kolz);
*/
if(zapis == -1)
 {
  if(kolz == 0)
   {
    if((masiv_int=(int *)calloc(1,sizeof(int))) == NULL)
     {
      printf("\n%s-Не могу выделить память для masiv_int int !!!\n",__FUNCTION__);
      return(-1);
     }
    kolz=1;
   }
  else
   {
    kolz++;
    if((masiv_int=(int *)realloc(masiv_int,kolz*sizeof(int))) == NULL)
     {
      printf("\n%s-Не могу добавить память для masiv_int int !!!\n",__FUNCTION__);
      return(-1);
     }  
   }
  masiv_int[kolz-1]=znah;
 }
else
 {
  if(zapis >= kolz)
   {
    printf("\n%s-Запрошенный елемент больше размера массива zapis=%d >= kolz=%d\n",__FUNCTION__,zapis,kolz);
    return(-1);
   }
  masiv_int[zapis]+=znah;
 } 
return(0);

}
/******************************************************/
/*Добавить значение в масив с увеличением его размера удалив предыдущее значение*/
/*******************************************************/

int iceb_tu_int::new_plus(int znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{
/*
printf("iceb_tu_int::add_masiv_int znah=%f zapis=%d kol=%d kolz=%d\n",
znah,zapis,kol,kolz);
*/
if(zapis == -1)
 {
  if(kolz == 0)
   {
    if((masiv_int=(int *)calloc(1,sizeof(int))) == NULL)
     {
      printf("\n%s-Не могу выделить память для masiv_int int !!!\n",__FUNCTION__);
      return(-1);
     }
    kolz=1;
   }
  else
   {
    kolz++;
    if((masiv_int=(int *)realloc(masiv_int,kolz*sizeof(int))) == NULL)
     {
      printf("\n%s-Не могу добавить память для masiv_int int !!!\n",__FUNCTION__);
      return(-1);
     }  
   }
  masiv_int[kolz-1]=znah;
 }
else
 {
  if(zapis >= kolz)
   {
    printf("\n%s-Запрошенный елемент больше размера массива zapis=%d >= kolz=%d\n",__FUNCTION__,zapis,kolz);
    return(-1);
   }
  masiv_int[zapis]=znah;
 } 
return(0);

}
/******************************************************/
/*Добавить значение в символьном виде в масив с увеличением его размера*/
/*******************************************************/

int iceb_tu_int::plus(const char *znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{

return(plus(atoi(znah),zapis));
}
/******************************************************/
/*Добавить значение в символьном виде в масив с увеличением его размера*/
/*******************************************************/

int iceb_tu_int::plus(char *znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{

return(plus(atoi(znah),zapis));
}

/*********************/
/*Уничтожение массива*/
/**********************/
void iceb_tu_int::free_class()
{

kolz=0;
if(masiv_int != NULL)
 {
  free(masiv_int);
  masiv_int=NULL;
 }
}

/*****************************************************/
/*Найти в каком елементе массива находится значение*/
/*****************************************************/
int iceb_tu_int::find(int znah)
{

for(int i=0; i < kolz; i++)
 if(znah == masiv_int[i])
  return(i);
return(-1);

}
/*****************************************************/
/*Найти в каком елементе массива находится значение в символьном виде*/
/*****************************************************/
int iceb_tu_int::find(const char *znah)
{
return(find(atoi(znah)));


}
/*****************************************************/
/*Найти в каком елементе массива находится значение в символьном виде*/
/*****************************************************/
int iceb_tu_int::find(char *znah)
{
return(find(atoi(znah)));


}
/*****************************************************/
/*Вернуть значение нужного елемента массива*/
/*****************************************************/
int iceb_tu_int::ravno(int elem)
{
if(elem > kolz)
 {
  printf("\n%s-Запрошенный елемент больше размера массива elem=%d > kolz=%d\n",__FUNCTION__,elem,kolz);
  return(0);  
 }
if(kolz == 0)
 {
  printf("\n%s-Количество элементов в массиве равно нолю !!!\n",__FUNCTION__);
  return(0);  
 }
return(masiv_int[elem]);

}
/*****************************************************/
/*Вернуть значение нужного елемента массива в символьном виде*/
/*****************************************************/
char *iceb_tu_int::ravno_char(int elem)
{
static char str[96];
sprintf(str,"%d",ravno(elem));
return(str);
}
/************************************/
/* Создать массив*/
/************************************/
int iceb_tu_int::make_class(int razmer) //Размер массива
{
if(razmer == 0)
 return(0);
kolz=razmer;
if((masiv_int=(int *)calloc(razmer,sizeof(int))) == NULL)
  {
   printf("\n%s-Не могу выделить память для masiv_int int !!!\n",__FUNCTION__);
   return(-1);
  }
return(0);
}
/*****************************/
/*Распечатать массив*/
/****************************/
void iceb_tu_int::print_class()
{
printf("%s: kolz=%d\n",__FUNCTION__,kolz);
for(int i=0; i < kolz; i++)
  printf("%d\n",masiv_int[i]);
}

/************************************************/
/*Вернуть максимальное значение елемента массива*/
/************************************************/
int iceb_tu_int::ravno_max()
{
int	max=0;
for(int i=0; i < kolz;i++)
 if(masiv_int[i] > max)
  max=masiv_int[i];
return(max);
}
/****************************************/
/*Вернуть количество элементов в массиве*/
/****************************************/
int iceb_tu_int::kolih()
{
return(kolz);
}
/*************************/
int iceb_tu_int::suma()
{
int suma=0.;
for(int i=0; i < kolz; i++)
  suma+=masiv_int[i];
return(suma);
}
