/*$Id:$*/
/*11.10.2024	13.10.2006	Белых А.И.	rnn_sap_xml.c
Шапка документов в xml формате
*/
#include "buhl.h"

void iceb_t_rnn_sap_xml(short gn,
short mk, /*отчётный месяц - последний месяц в отчётном периоде*/
const char *kod_dok,
int pnd,
int iceb_tu_period_type, //1-месяц, 2 квартал 3 полугодие 4-9 месяцев 5-год
class iceb_rnfxml_data *rek_zag_nn, /*Класс с данными для создания xml файлов*/
FILE *ff_xml)
{
char tip_dok[16];
char podtip[16];
char type_ver[16];
class iceb_tu_str imaf(kod_dok);
imaf.plus(".XSD");
memset(tip_dok,'\0',sizeof(tip_dok));
memset(podtip,'\0',sizeof(podtip));
memset(type_ver,'\0',sizeof(type_ver));

strncpy(tip_dok,kod_dok,3);
strncpy(podtip,&kod_dok[3],3);
strncpy(type_ver,&kod_dok[6],2);

time_t vrem;
time(&vrem);
struct tm *bf;
bf=localtime(&vrem);

fprintf(ff_xml,"<?xml version=\"1.0\" encoding=\"%s\"?>\n",rek_zag_nn->kod_tabl.ravno());
fprintf(ff_xml,"<!--this XML file generated by iceB %s %02d.%02d.%d %02d:%02d:%02d -->\n",
VERSION,
bf->tm_mday,bf->tm_mon+1,bf->tm_year+1900,
bf->tm_hour,bf->tm_min,bf->tm_sec);



fprintf(ff_xml,"<DECLAR xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"%s\">\n",imaf.ravno());
fprintf(ff_xml," <DECLARHEAD>\n");
fprintf(ff_xml,"  <TIN>%s</TIN>\n",rek_zag_nn->kod_edrpuo.ravno());
fprintf(ff_xml,"  <C_DOC>%s</C_DOC>\n",tip_dok);
fprintf(ff_xml,"  <C_DOC_SUB>%s</C_DOC_SUB>\n",podtip);
fprintf(ff_xml,"  <C_DOC_VER>%d</C_DOC_VER>\n",atoi(type_ver));
fprintf(ff_xml,"  <C_DOC_TYPE>0</C_DOC_TYPE>\n");
fprintf(ff_xml,"  <C_DOC_CNT>%d</C_DOC_CNT>\n",pnd);
fprintf(ff_xml,"  <C_REG>%d</C_REG>\n",rek_zag_nn->kod_oblasti.ravno_atoi());
fprintf(ff_xml,"  <C_RAJ>%s</C_RAJ>\n",rek_zag_nn->kod_admin_r.ravno());
fprintf(ff_xml,"  <PERIOD_MONTH>%d</PERIOD_MONTH>\n",mk);
fprintf(ff_xml,"  <PERIOD_TYPE>%d</PERIOD_TYPE>\n",iceb_tu_period_type);
fprintf(ff_xml,"  <PERIOD_YEAR>%d</PERIOD_YEAR>\n",gn);

fprintf(ff_xml,"  <C_STI_ORIG>%d</C_STI_ORIG>\n",rek_zag_nn->kod_oblasti.ravno_atoi()*100+rek_zag_nn->kod_admin_r.ravno_atoi());

fprintf(ff_xml,"  <C_DOC_STAN>1</C_DOC_STAN>\n");  /*1-Звітний 2-новий звітний 3-уточнюючий*/

if(rek_zag_nn->dzd == 0)
 fprintf(ff_xml,"  <D_FILL>%02d%02d%04d</D_FILL>\n",rek_zag_nn->dt,rek_zag_nn->mt,rek_zag_nn->gt);
else
 fprintf(ff_xml,"  <D_FILL>%02d%02d%04d</D_FILL>\n",rek_zag_nn->dzd,rek_zag_nn->mzd,rek_zag_nn->gzd);

fprintf(ff_xml,"  <SOFTWARE>iceB %s</SOFTWARE>\n",VERSION);
fprintf(ff_xml," </DECLARHEAD>\n");



}
