/*$Id: dbfhead.h,v 5.4 2013/05/17 14:56:27 sasa Exp $*/
/*29.10.1998	29.10.1998	Белых А.И.	dbfhead.h
Описание структуры заголовка dbf файла
Дбф файл состоит из 2-х частей
* заголовок
* записи
-------Заголовок-------------------------
32 байта заголовок
32 байта описание 1-го поля
- - - - - - - - - -  -
32 байта описание н-го поля
1 байт завершающий символ 0x0D (13)
-------конец заголовка-------------------
n байт первая запись из n-полей
n байт вторая запись из n-полей

1 байт завешающий символ 0x1A (26)


Описание заголовка 
-----------------------------------------------------------------------------------------
номер байта|Размер|Значение   |Описание                     |Используется
-----------------------------------------------------------------------------------------
   0          1    0x03(3)     простая таблица               FS, D3, D4, D5, Fb, Fp, CL
                   0x04(4)     простая таблица               D4, D5 (FS)
                   0x05(5)     простая таблица               D5, Fp (FS)
                   0x43(67)    с мемо-полем .dbv             FS
                   0xB3(179)   с мемо-полями .dbv .dbt       FS
                   0x83(131)   с мемо-полем .dbt             FS, D3, D4, D5, Fb, Fp, CL
                   0x8B(139)   с мемо-полем .dbt формат D4   D4, D5
                   0x8E(142)   SQL-таблица                   D4, D5
                   0xF5(245)   с мемо полем .fmp             Fp
   1          1    YY          год последнего обновления     Все                                                                                                                                                         
   2          1    ММ          месяц                         Все
   3          1    DD          день                          Все
   4          4    RecordsCou  Количество записей в файле    Все
   8          2    HeaderSize  Размер заголовка в байтах     Все
   10         2    RecordSize  Размер записи в байтах        Все
   12         2    0x00,0x00   Зарезервировано               Все
   14         1    0x01        Начало транзакции             D4, D5
                   0x00        Конец транзакции              D4, D5
                   0x00        Игнорируется                  FS, D3, Fb, Fp, CL
   15         1    0x01        Закодировано                  D4, D5
                   0x00        Нормальная видимость          Все
   16        12    0 (1)       Использование многопользовате D4, D5
                               льского окружения
   28         1    0x01        Используется индекс           Fp, D4, D5
                   0x00        Индекс не используется        Все
   29         1    n           Номер драйвера языка          D4, D5
                   0x01(1)     кодовая страница 437 DOS USA  Fp
                   0x02(2)     кодовая страница 850 DOS      Fp
                               Multilang  
                   0x26(38)    кодовая страница 866 DOS      Fp
                               Russian
                   0x57(87)    кодовая страница 1251 Windows Fp
                               ANSI
                   0xC8(200)   кодовая страница 1250         Fp
                               Windows EE
                   0x00(0)     игнорируется                  FS, D3, Fb, Fp, CL
   30        2     0x00,0x00   Зарезервировано               Все
                                                                               

Сокращения:
FS = FlagShip
Fb = FoxBase
Fp = FoxPro
CL = Clipper
D3 = dBaseIII+
D4 = dBaseIV
D5 = dBaseV
Таким образом мы сумели описать первых 32 байта DBF-файла. Начиная с 33 байта начинаются описания полей, каждое из которых также имеет размер в 32 байта.

Структура описания полей в заголовке
----------------------------------------------------------------------------------------
номер байта|Размер|Значение   |Описание                               |Используется
----------------------------------------------------------------------------------------

00            11   ASCII       Имя поля с 0x00 завершением             Все
11            1    ASCII       Тип поля см. Таблицу 4                  Все
12            4    n,n,n,n     Адрес поля в памяти                     D3
                   0,0,n,n     Смещение относительно начала записи     Fp
                   0,0,0,0     Игнорируется                            FS, D4, D5, Fb, CL
16            1    Byte        Размер поля см. Таблицу 4               Все
17            1    Byte        Количество знаков после запятой         Все
18            2    0,0         Зарезервировано                         Все
20            1    Byte        Идентификатор рабочей области           D4,D5
                   0x00        Не используется                         FS, D3, Fb, Fp, CL
21            2    n,n         Многопользовательский dBase             D3, D4, D5
                   0,0         Игнорируется                            FS Fb, Fp, CL
23            1    0x01        Установленные поля                      D3, D4, D5
                   0x00        Игнорируется                            FS Fb, Fp, CL
24            7    0..0        Зарезервировано                         Все
31            1    0x01        Поле включено в .mdx индекс             D4, D5
                   0x00        Игнорируется                            D3, FS, Fb, Fp, CL
Завершает описание заголовка символ 0x0D(13)

теперь уже можно сделать кое-какие вычисления. Например, определить количество полей в DBF-файле. 
Размер заголовка DBF-файла в байтах составляет: 
32+32xN+1 байт, где N - количество полей. 
Этот же размер можно извлечь из 8,9 байтов заголовка - HeaderSize 



Типы полей и из размеры
-------------------------------------------------------------------------------------------------------
Код | Тип |  Размер  | Описание/размер                                                 |Используется
-------------------------------------------------------------------------------------------------------
C    1..n  Char       n ASCII символов                                                  Все
                      пустые места - пробел 0x20(32)                                    Все
                      n = 1..64Kbt                                                      FS
                      n = 1..32Kbt                                                      Fp, CL
                      n = 1..254                                                        Все
D    8     Date       8 ASCII знаков (0..9) в формате YYYYMMDD                          Все
F    1..n  Float      ASCII символы(-.0123456789) переменная позиция                    FS, D4, D5, Fp
                      плавающей точки n = 1..20
N    1..n  Numeric    ASCII символы (-.0123456789) фиксированная позиция точки          Все
                      n = 1..20                                                         FS, Fp, CL
                      n = 1..18                                                         D3, D4, D5, Fb
L    1     Logical    ASCII символы (Yy Tt Nn Ff, пробел - не определено)               FS, D3, Fb, Fp, CL
                      ASCII символы (Yy Tt Nn Ff, ? - не определено)                    D4, D5 (FS)
M    10    Memo       10 цифр, определяющих начало блока данных в .dbt-файле            Все
                      или 10 пробелов, если поле мемо пусто
V    10    Variable   Переменная Bin/ASCII данных в .dbv-файле                          FS
                      4 Bin байтов - начало блока в мемо-файле 
                      4 Bin байтов - размер блока 
                      1 Bin байт - подтип данных 
                      1 Bin байт - зарезервировано 0x1A(26)
P    10    Picture    Binary данные в .ftp-файле структура такая же как и в Memo-типе   Fp
B    10    Binary     Binary данные в .dpt-файле структура такая же как и в Memo-типе   D5
G    10    General    OLE-объекты структура такая же как и в Memo-типе                  D5, Fp
2    2     short int  Binary int max +/- 32767                                          FS
4    4     long int   Binary int max +/- 2147483647                                     FS
8    8     double     Binary signed double IEEE                                         FS

*/



typedef struct dbase_head 
 {
    unsigned char	version;	/* 1 тип таблицы */
    unsigned char	l_update[3];	/* 3 yymmdd дата */
    guint32             count;          /* 4 количество записей в файле*/

    unsigned short	header;		/* 2 размер заголовка в байтах
					 *   includes the \r at end
					 */
    unsigned short	lrecl;		/* 2 размер записи в байтах
					 * включая первый пустой байт который используется для пометки удалённых записей
					 * 
					 */
    unsigned char   reserv[20];         //0-12 1-13 2-14 3-15 4-16 5-17 6-18 7-19 8-20 9-21 10-22 11-23 12-24 13-25 14-26 15-27 16-28 17-29 18-30 19-31
 } DBASE_HEAD;

typedef struct dbase_fld 
 {
    char    name[11];               /*Имя поля*/
    char    type;                   /*тип поля*/
    /* A-T uses large data model but drop it for now */
    char   data_ptr[4];               /*не заполняем*/
    unsigned char length;           /*размер поля*/
    char   dec_point;               /*количество знаков после запятой*/
    char   fill[14];                /* не заполняем*/
 } DBASE_FIELD;
