/*$Id: zvb_ibank2ua.c,v 5.14 2013/09/26 09:43:46 sasa Exp $*/
/*08.08.2025	18.09.2008	Белых А.И.	zvb_ibank2ua.c
Выгрузна в файл для экспорта в систему iBank2 UA

Важливо! Значення поля типу документів для зарплатних відомостей – doc/pay_sheet.

-------------------------------------------------------------------------------------------------
     Назва поля                  Тип даних      Обов'язковість  Опис 
------------------------------------------------------------------------------------------------- 
DATE_DOC                         Date          Так  Дата документа у форматі «ДД.ММ.РРРР»
NUM_DOC                          String(10)    Ні   Номер документа
CLN_NAME                         String(40)    Ні   Назва платника
PAYER_BANK_MFO                   String(6)     Так  МФО банку платника
PAYER_BANK_NAME                  String(45)    Ні  Назва банку платника
PAYER_ACCOUNT                    String(29)    Так Рахунок списання
CARD_HOLDERS.N.CARD_NUM *        String(29)    Так Номер карткового рахунку
CARD_HOLDERS.N.CARD_HOLDER *     String(80)    Так ПІБ власника картки
CARD_HOLDERS.N.CARD_HOLDER_INN * String(14)    Так ІПН власника картки
CARD_HOLDERS.N.AMOUNT *          Decimal(12.2) Так Сума зарахування
CARD_HOLDERS.N.STAFF_ID *        String(16)    Ні  ІД співробітника, якщо передбачено
CARD_HOLDERS.N.CARD_HOLDER_TABN *String(20)    Ні  Табельний номер власника картки, якщо передбачено
CARD_HOLDERS.N.DESCRIPTION *     String(45)    Ні  Примітки
CARD_HOLDERS.N.POSITION_CODE *   String(20)    Ні  Код посади співробітника
CARD_HOLDERS.N.POSITION_NAME *   String(45)    Ні  Назва посади співробітника
ONFLOW_TYPE                      String(65)    Так Тип перерахування**
AMOUNT                           Decimal(12.2) Так Сума перерахування
PAYER_BANK_ACCOUNT               String(14)    Ні  Рахунок банку платника
VALUE_DATE                       Date          Ні  Дата валютування
CLN_OKPO                         String(10)    Ні  ЄДРПОУ платника
ONFLOW_TYPE_ID                   Integer(2)    Ні  Код типу нарахування
BEGIN_MONTH                      Integer(2)    Так Місяць початку періоду нарахування
BEGIN_YEAR                       Integer(4)    Так Рік початку періоду нарахування
END_MONTH                        Integer(2)    Ні  Місяць завершення періоду
END_YEAR                         Integer(4)    Ні  Рік завершення періоду

*Для полів-списків (CARD_HOLDERS.N.***, де N – номер співробітника) використовується автонумерація, що починається з нуля.
**Для поля «Тип перерахування» доступні такі значення: • «Заробітна плата та аванси», • «Відпускні»,
• «Остаточний розрахунок при звільненні», • «Представницькі та господарські витрати», • «Відшкодування
витрат по відрядженню», • «Аванс на відрядження», • «Безвідсоткова поворотна позика працівникам»,
• «Видача безвідсоткової поворотної фінансової допомоги», • «Повернення безвідсоткової поворотної
фінансової допомоги», • «Повернення фінансової допомоги», • «Виплата одноразової неоподаткованої
допомоги без ПДФО та ВЗ», • «Виплата кредитних коштів, без ПДВ», • «Компенсація за невикористану
відпустку», • «Допомога при народженні дитини», • «Лікарняні», • «Лікарняні по вагітності та пологам»,
• «Премія», • «Стипендія», • «Аліменти», • «Інше».

Приклад.
Із мінімальним набором полів

Content-Type=doc/pay_sheet

DATE_DOC=06.07.2019
NUM_DOC=
CLN_NAME=ТОВ "Краща компанія"
PAYER_BANK_MFO=351005
PAYER_BANK_NAME=АТ "УкрСиббанк"
PAYER_ACCOUNT=UA533510050000026005171079500
CARD_HOLDERS.0.CARD_NUM=UA7035100500000262088
05728645
CARD_HOLDERS.0.CARD_HOLDER=Іванов Іван
Іванович
CARD_HOLDERS.0.CARD_HOLDER_INN=3057207523
CARD_HOLDERS.0.AMOUNT=502.00
CARD_HOLDERS.1.CARD_NUM=UA4235100500000262058
05703061
CARD_HOLDERS.1.CARD_HOLDER=Петренко Петро
Петрович
CARD_HOLDERS.1.CARD_HOLDER_INN=2918803840
CARD_HOLDERS.1.AMOUNT=303.32
ONFLOW_TYPE=Заробітна плата та аванси
AMOUNT=805.32
PAYER_BANK_ACCOUNT=
VALUE_DATE=
CLN_OKPO=35442481
ONFLOW_TYPE_ID=
BEGIN_MONTH=03
BEGIN_YEAR=2019
END_MONTH=04
END_YEAR=2019


*/
#include <math.h>
#include    "buhg.h"


void zvb_ibank2ua(short prn,const char *zapros,struct dirnupoi *poisk,const char *kod00)
{
char strsql[512];
char imaf[64];
char imafr[64];
FILE  *ff;
FILE  *ffr;
int   kolstr;
class zvb_menu_lst_r rm;

SQLCURSOR cur;
SQLCURSOR cur1;
SQLCURSOR curr;
SQL_str row,row1;

if((kolstr=cur.make_cursor(&bd,zapros)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),zapros);
  return;
 }
//class iceb_tu_str vidnahis(""); 

if(zvb_ibank2ua_start(imafr,imaf,kod00,&rm,&ff,&ffr) != 0)
 return;

class iceb_tu_str kartshet("");
class iceb_tu_str inn("");
int kolstr1=0;
class iceb_tu_str fio("");
double suma=0.;
double sumai=0.;
int nomer_zap=0;
while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);
  if(poidirnu(row,poisk,&fio) != 0)
     continue;
  suma=atof(row[4]);

  if(fabs(suma) < 0.01)
   continue;

  if(prn == 2)
    suma*=(-1);   

    
  sprintf(strsql,"select fio,bankshet,inn from Kartb where tabn=%s",row[1]);
  if(sql_readkey(&bd,strsql,&row1,&cur1) == 1)
   {
    kartshet.new_plus(row1[1]);
    inn.new_plus(row1[2]);
   }
  else
   {
    kartshet.new_plus("");
    inn.new_plus("");
   }
  if(kartshet.ravno()[0] == '\0')
   {
    VVOD SOOB(1);
    SOOB.VVOD_spisok_add_MD(gettext("Не введён счёт !"));
    sprintf(strsql,"%s:%s %s",gettext("Табельный номер"),row[1],fio.ravno());
    SOOB.VVOD_spisok_add_MD(strsql);
    soobshw(&SOOB,stdscr,-1,-1,0,1);
    continue;
   }


  sumai+=suma;

  zvb_ibank2ua_str(&nomer_zap,row[1],fio.ravno(),kartshet.ravno(),inn.ravno(),suma,ff,ffr);

 }
 
zvb_ibank2ua_end(imafr,sumai,&rm,ffr,ff);

class spis_oth oth;
oth.spis_imaf.plus(imafr);
oth.spis_naim.plus(gettext("Распечатка документов для перечисления на карт-счета"));

oth.spis_imaf.plus(imaf);
oth.spis_naim.plus(gettext("Документ в электронном формате"));


iceb_t_rabfil(&oth,"");

}
