/* $Id:$ */
/*18.12.2025	19.05.2000	Белых А.И.	zarindex.c
Расчёт индексации зарплаты
*/
#include        <errno.h>
#include        "buhg.h"
#include "read_nast_ind.h"

extern class index_ua tabl_ind; /*Таблица для индексации зарплаты*/

extern short	kodindex;  /*Код индексации*/
extern short    *kodnvrindex; //Коды не входящие в расчёт индексации
extern double   okrg; /*Округление*/
extern short    ggg,mmm;
double zarindex_tb(int tn,short mp,short gp,double suma_ind);

void zarindex(int tn, //Табельный номер*/
short mp,short gp,int podr,const char *nah_only)
{
int		i;
char            strsql[512];
short		mi,gi; /*месяц индексации*/
double		procind; /*процент индексации*/
double		sumaog=0;  /*Сумма ограничения индексации*/
double		suman;   /*Сумма начисленная в месяце индексации*/
double		sumain;  /*Сумма индексации*/
class iceb_tu_str shet("");
short		d;
long		kolstr;
class iceb_tu_str harac("");
SQL_str         row;
SQLCURSOR cur;
class ZARP     zp;
double		insum=0.; //Индексируемая сумма
double porog_ind=1.009999; /*1.01*/
if(iceb_tu_sravmydat(1,1,2016,1,mp,gp) <= 0)
 porog_ind=1.03; /*1.03*/
// porog_ind=1.029999; /*1.03*/
 
sprintf(strsql,"\n%s-Расчёт индексации начислений\n\
-----------------------------------------------\nПорог индексации %f\n",__FUNCTION__,porog_ind);
zar_pr_ins(strsql);

if(kodindex <= 0)
 {
  sprintf(strsql,"%s-В файле настройки zarnast.alx не введён код индексации!\n",__FUNCTION__);
  zar_pr_ins(strsql);
  return;
 }
if(iceb_tu_proverka(nah_only,kodindex,0,0) != 0)
 {
  sprintf(strsql,"%s-Код индексации %d исключён из расчёта\n",__FUNCTION__,kodindex);
  zar_pr_ins(strsql);
  return;
 }

/*Проверяем есть ли индексация в списке начислений*/
sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='1' and \
knah=%d",tn,kodindex);
if(sql_readkey(&bd,strsql,&row,&cur) != 1)
 {
  
  sprintf(strsql,"%s-Не введён код индексации %d в список начислений!\n",__FUNCTION__,kodindex);
  zar_pr_ins(strsql);
  return;

 }

shet.new_plus(row[0]);

sprintf(strsql,"%s-Коды не входящие в расчёт индексации:",__FUNCTION__);
zar_pr_ins(strsql);

if(kodnvrindex != NULL)
 for(i=1; i <= kodnvrindex[0]; i++)
  {
   sprintf(strsql,"%d ",kodnvrindex[i]);
   zar_pr_ins(strsql);
  }
sprintf(strsql,"\n");
zar_pr_ins(strsql);

//Читаем дату приёма на работу и дату последнего повышения зарплаты
sprintf(strsql,"select datn,datk,dppz,harac from Kartb where tabn=%d",tn);
if(sql_readkey(&bd,strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"%s-Не найдена карточка для табельного номера %d\n",__FUNCTION__,tn);
  zar_pr_ins(strsql);
  return;
 }


short dppz=0,mppz=0,gppz=0; //Дата последнего повышения зарплаты
short dnr=0,mnr=0,gnr=0;    //Дата начала работы
short mb=0,gb=0;       //базовый месяц для расчёта индексации
harac.new_plus(row[3]);

sprintf(strsql,"%s-Характер работы-%s\n",__FUNCTION__,harac.ravno());
zar_pr_ins(strsql);

short du=0,mu=0,gu=0;
iceb_tu_rsdat(&du,&mu,&gu,row[1],2);

if(iceb_tu_rsdat(&dppz,&mppz,&gppz,row[2],2) == 0)
 {
  sprintf(strsql,"%s-Дата последнего повышения зарплаты %d.%d\n",__FUNCTION__,mppz,gppz);
  zar_pr_ins(strsql);
 }
if(iceb_tu_rsdat(&dnr,&mnr,&gnr,row[0],2) == 0)
 {
  sprintf(strsql,"%s-Дата принятия на работу %d.%d.%d\n",__FUNCTION__,dnr,mnr,gnr);
  zar_pr_ins(strsql);
 } 

d=1;
iceb_tu_dpm(&d,&mp,&gp,5);
zp.dz=d;
zp.nomz=0;
zp.podr=podr;
zp.tabnom=tn;
zp.prn=1;
zp.knu=kodindex;
zp.mz=mp;
zp.gz=gp;

int kolih_mr=tabl_ind.mr.kolih();
if(kolih_mr == 0)
 {
  sprintf(strsql,"%s-Не найдено ни одного месяца расчёта индексации !\n",__FUNCTION__);
  zar_pr_ins(strsql);
  return;
 }
class zar_read_tn1h nast_mz;

for(int kol=0; kol < kolih_mr ; kol++)
 {
  mi=tabl_ind.mr.ravno(kol);
  gi=tabl_ind.gr.ravno(kol);

  


  if(gppz != 0)
   {
    if(iceb_tu_sravmydat(1,mppz,gppz,1,mi,gi) > 0)
     {
      mb=mnr; gb=gnr;
     }
    else
     {
      mb=mppz; gb=gppz;
     }
   }
  else
   {
    mb=mnr; gb=gnr;
    
   }  
  /*****************************
   С 1.1.2025 начали снова считать ранее отменённую индексацию
   поэтому если базовый месяц меньше этой даты то мы берём эту дату
   за базовый месяц
   ******************/

   if(iceb_tu_sravmydat(1,mb,gb,1,1,2025) < 0 && iceb_tu_sravmydat(1,mi,gi ,1,1,2025) >= 0)
    {
     mb=1;
     gb=2025;
    }

  sprintf(strsql,"%s-Месяц расчёта индексации:%d.%d\n",__FUNCTION__,mi,gi);
  zar_pr_ins(strsql);
  sprintf(strsql,"%s-Базовый месяц для расчёта:%d.%d\n",__FUNCTION__,mb,gb);
  zar_pr_ins(strsql);
  
  zar_read_tn1(1,mi,gi,&nast_mz); /*читаем какая минимальная зарплата действует в этом месяце*/
  sumaog=nast_mz.prog_min_tek;
  sprintf(strsql,"\n%s-Дата индексации:%d.%d Максимальная сумма индексации:%.2f\n",__FUNCTION__,mi,gi,sumaog);
  zar_pr_ins(strsql);

  if(sumaog == 0.)
   {
    sprintf(strsql,"%s-Прожиточный минимум равен нолю!\n",__FUNCTION__);
    zar_pr_ins(strsql);
    continue;

   }
  int kol_mes_tabl=tabl_ind.mi.kolih();
  sprintf(strsql,"%s-Количество месяцев в таблице=%d\n",__FUNCTION__,kol_mes_tabl);
  zar_pr_ins(strsql);

  procind=1.;

  short dpr,mpr,gpr;

  dpr=1; mpr=mi; gpr=gi;
  iceb_tu_dpm(&dpr,&mpr,&gpr,4);    
  float index=0.;
  float pred_index=1;

  if(iceb_tu_sravmydat(1,mu,gu,1,mi,gi) == 0)
   {
    sprintf(strsql,"%s-Уволен %d.%d.%d \n",__FUNCTION__,du,mu,gu);
    zar_pr_ins(strsql);
   }
  else  
  for(int kol_tabl=0; kol_tabl < kol_mes_tabl ; kol_tabl++)
   {
    sprintf(strsql,"%s-%d.%d\n",__FUNCTION__,tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl));
    zar_pr_ins(strsql);
   
    if(iceb_tu_sravmydat(1,mb,gb,1,tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl)) < 0)
     {
      if(iceb_tu_sravmydat(1,mpr,gpr,1,tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl)) > 0)
       {
        index=tabl_ind.koef.ravno(kol_tabl)/100.;
  //      index=iceb_tu_okrug(index,0.001);

        sprintf(strsql,"%s-%02d.%04d %8.2f %f * %f = %f\n",
        __FUNCTION__,
        tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl),
        tabl_ind.koef.ravno(kol_tabl),index,pred_index,index*pred_index);
        zar_pr_ins(strsql);

//        if(index*pred_index >= porog_ind)
        double koef=index*pred_index;
        koef=iceb_tu_okrug(koef,0.01);
        if(koef > porog_ind)
         {

          sprintf(strsql,"%s-Больше %.2f > %f*%f*%f=",__FUNCTION__,porog_ind,procind,index,pred_index);
          zar_pr_ins(strsql);
          procind*=index*pred_index;

          sprintf(strsql,"%f",procind);
          zar_pr_ins(strsql);

          procind=iceb_tu_okrug(procind,0.001);

          sprintf(strsql," Округляем=%f\n",procind);
          zar_pr_ins(strsql);
          
          pred_index=1.;
         }

        else
         {
          pred_index*=index;
  //        pred_index=iceb_tu_okrug(pred_index,0.001);
          sprintf(strsql,"%s- %f*%f=%f <= %f\n",__FUNCTION__,index,pred_index,index*pred_index, porog_ind);
          zar_pr_ins(strsql);
         }      
  //      sprintf(strsql,"\n");
  //      zar_pr_ins(strsql);
       }
      else
       {
        sprintf(strsql,"%s-Дату не берём в расчет так как %d.%d >= %d.%d\n",__FUNCTION__,mpr,gpr,tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl));
        zar_pr_ins(strsql);
       }
     }
    else
     {

      sprintf(strsql,"%s-Дату не берём в расчет так как %d.%d <= %d.%d\n",__FUNCTION__,mb,gb,tabl_ind.mi.ravno(kol_tabl),tabl_ind.gi.ravno(kol_tabl));
      zar_pr_ins(strsql);

     } 
    sprintf(strsql,"*********\n");
    zar_pr_ins(strsql);
   }

  sprintf(strsql,"%s-Коэффициент %f\n",__FUNCTION__,procind);
  zar_pr_ins(strsql);

  procind=iceb_tu_okrug(procind,0.001);
  sprintf(strsql,"%s-Округляем %.4f\n",__FUNCTION__,procind);
  zar_pr_ins(strsql);
   
  
   if(procind != 0.)
     sprintf(strsql,"%s-Величина прироста индекса потребительских цен:%.4f*100-100=%.4f\n",
     __FUNCTION__,
     procind,(procind*100.)-100.);
   else
     sprintf(strsql,"%s-Величина прироста индекса потребительских цен:0.\n",__FUNCTION__);
   zar_pr_ins(strsql);

  if(procind != 0.)
    procind=(procind*100.)-100.;


  /*Читаем все начисления за месяц индексации*/
  sprintf(strsql,"select knah,suma from Zarp where datz >= '%d-%d-01' \
and datz <= '%d-%d-31' and tabn=%d and prn='1' and suma <> 0.",
  gi,mi,gi,mi,tn);
  SQLCURSOR cur;
  if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
    iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);

  if(kolstr == 0)
   {
    sprintf(strsql,"%s-Не найдены начисления за %d.%d\n",__FUNCTION__,mi,gi);
    zar_pr_ins(strsql);
    continue;
   }

  suman=0.;
  while(cur.read_cursor(&row) != 0)
   {
    //Если за текущий месяц не должно входить в расчёт чтобы при пересчёте сумма не менялась
    if(atoi(row[0]) == kodindex && mmm == mi && ggg == gi)
      continue;
      
    if(provkod(kodnvrindex,atoi(row[0])) >= 0)
      continue;
    
    suman+=atof(row[1]);
   }


  insum=sumaog;

  if(suman < sumaog && iceb_tu_strstrm(harac.ravno(),gettext("Студент")) == 1)
   {
    insum=suman;
    sprintf(strsql,"%s-Студент. Сумма начислений которая индексируется-%.2f\n",__FUNCTION__,suman);
    zar_pr_ins(strsql);
 
   }
  else
   {
    sprintf(strsql,"%s-Сумма которая индексируется-%.2f\n",__FUNCTION__,insum);
    zar_pr_ins(strsql);
   }
  sprintf(strsql,"%s-Максимальная сумма индексации:%.2f Процент индексации:%f\n\
Сумма начисленная:%.2f Сумма взятая для индексации:%.2f \n",__FUNCTION__,sumaog,procind,suman,insum);
  zar_pr_ins(strsql);
      
  sumain=insum*procind/100.;

  sprintf(strsql,"%s-Расчёт индексации-%f*%f/100.=%f\n",__FUNCTION__,insum,procind,sumain);
  zar_pr_ins(strsql);

  sumain=iceb_tu_okrug(sumain,okrg);

  sprintf(strsql,"%s-Округляем до копеек-%f\n",__FUNCTION__,sumain);
  zar_pr_ins(strsql);

  sprintf(strsql,"%s-Код индексации:%d Сумма индексации:%.2f\n",__FUNCTION__,kodindex,sumain);
  zar_pr_ins(strsql);

  sumain=zarindex_tb(tn,mi,gi,sumain);/*перерасчёт в соотвецтвии с реально отработанным временем*/

  zp.mesn=mi; zp.godn=gi;
  zp.nomz=0;
  zp.podr=podr;
  strcpy(zp.shet,shet.ravno());
//  zapzarp(zp.dz,mp,gp,tn,1,kodindex,sumain,shet.ravno(),mi,gi,0,0,"",podr,"",zp);
  zapzarp(&zp,sumain,d,mi,gi,0,shet.ravno(),"",0,podr,"");

 }

//OSTANOV();
}
/******************************/

double zarindex_tb(int tn, //Табельный номер*/
short mp,short gp,double suma_ind)
{
char strsql[1024];
SQL_str row;
class SQLCURSOR cur;
int kolstr=0;
float dnei=0.;
float has=0.;
class iceb_tu_str ktvr("");

if(suma_ind == 0.)
 return(0.);
/*узнаём количество рабочих часов и дней в месяце*/
redkal(mp,gp,&dnei,&has);

sprintf(strsql,"%s-Количество рабочих дней %.2f Количество рабочих часов%.2f Сумма индексации:%.2f\n",
__FUNCTION__,dnei,has,suma_ind);

zar_pr_ins(strsql);

if(dnei == 0. && has == 0.)
 return(suma_ind);

if(iceb_t_poldan("Коды табеля входящие в расчёт индексации",&ktvr,"zarnast.alx") != 0)
 return(suma_ind);

sprintf(strsql,"%s-Коды табеля входящие в расчёт:%s\n",__FUNCTION__,ktvr.ravno());
zar_pr_ins(strsql);

/*ОПРЕДЕЛЯЕМ ОТРАБОТАННОЕ ВРЕМЯ*/
sprintf(strsql,"select kodt,dnei,has from Ztab where god=%d and mes=%d and tabn=%d",
gp,mp,tn);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }
float odnei=0.;
float ohas=0.;
while(cur.read_cursor(&row) != 0)
 {
  if(iceb_tu_proverka(ktvr.ravno(),row[0],0,0) != 0)
   continue;
  odnei+=atof(row[1]);
  ohas+=atof(row[2]);
 }

sprintf(strsql,"%s-Количество отработанных дней %.2f Количество отработанных часов %.2f\n",__FUNCTION__,odnei,ohas);
zar_pr_ins(strsql);

double nsum_ind=0.;
if(ohas == 0. && odnei == 0.)
 return(suma_ind);

if(ohas != 0. && has != 0.)
 {
  nsum_ind=suma_ind/has*ohas;
  nsum_ind=iceb_tu_okrug(nsum_ind,0.01);

  sprintf(strsql,"%s-Пересчитываем индексацию %.2f/%.2f*%.2f=%.2f\n",
  __FUNCTION__,suma_ind,has,ohas,nsum_ind);
  zar_pr_ins(strsql);
 } 
else
 {
  if(dnei == 0.)
   return(suma_ind);
  nsum_ind=suma_ind/dnei*odnei;
  nsum_ind=iceb_tu_okrug(nsum_ind,0.01);
  sprintf(strsql,"%s-Пересчитываем индексацию %.2f/%.2f*%.2f=%.2f\n",
  __FUNCTION__,suma_ind,dnei,odnei,nsum_ind);
  zar_pr_ins(strsql);
 }
return(nsum_ind); 
}

