/*$Id:$*/
/*16.01.2022	12.01.2022	Белых А.И.	xmurndsop.cpp
Расчёт распределения НДС по видам операций
*/

#include "buhg.h"

class xmurndsop_rp
 {
  public:
   class iceb_tu_str datan;
   class iceb_tu_str datak;
   class iceb_tu_str sklad;
   class iceb_tu_str prih_rash; /* "+" приход "-" расход*/
   class iceb_tu_str kod_op;
   class iceb_tu_str kod_kontr;
   class iceb_tu_str nom_dok;   

   xmurndsop_rp()
    {
     clear();
    }
   void clear()
    {
     datan.new_plus("");
     datak.new_plus("");
     sklad.new_plus("");
     prih_rash.new_plus("");
     kod_op.new_plus("");
     kod_kontr.new_plus("");
     nom_dok.new_plus("");
    }   
 };

void xmurndsop_rm(int tipz,class iceb_tu_spisok *kod_op,class iceb_tu_spisok *all_proc_nds,class iceb_tu_double *suma_dok,class iceb_tu_double *suma_nds,FILE *ff);
void xmurndsop_rrp(class xmurndsop_rp *rp,FILE *ff);
void xmurndsop_hap(class iceb_rnl_c *rh,int *kolstr,FILE *ff);

int xmurndsop(class spis_oth *oth) 
{
static class xmurndsop_rp rp;
char imaf[64],imaf_prot[64];
int kom=0,kom1=0;

class VVOD MENU(3);
class VVOD VV(0);
VV.VVOD_spisok_add_ZAG(gettext("Расчёт рапределения НДС по видам операций"));
VV.VVOD_spisok_add_ZAG(gettext("По не введенным реквизитам поиск не выполняется"));

VV.VVOD_spisok_add_data(rp.datan.ravno(),11);
VV.VVOD_spisok_add_data(rp.datak.ravno(),11);
VV.VVOD_spisok_add_data(rp.sklad.ravno(),128);
VV.VVOD_spisok_add_data(rp.prih_rash.ravno(),2);
VV.VVOD_spisok_add_data(rp.kod_op.ravno(),128);
VV.VVOD_spisok_add_data(rp.kod_kontr.ravno(),128);
VV.VVOD_spisok_add_data(rp.nom_dok.ravno(),128);

VV.VVOD_spisok_add_MD(gettext("Дата начала.............."));//0
VV.VVOD_spisok_add_MD(gettext("Дата конца..............."));//1
VV.VVOD_spisok_add_MD(gettext("Склад...(,,)............."));//2
VV.VVOD_spisok_add_MD(gettext("Приход/Расход...(+/-)...."));//3
VV.VVOD_spisok_add_MD(gettext("Код операции..(,,)......."));//4
VV.VVOD_spisok_add_MD(gettext("Код контрагента..(,,)...."));//5
VV.VVOD_spisok_add_MD(gettext("Номер документа..(,,)...."));//6

naz:;
clear();

helstr(LINES-1,0,
//"F1",gettext("помощь"),
"F2/+",gettext("поиск"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

kom=VV.vvod(0,1,1,-1,-1);

rp.datan.new_plus(VV.data_ravno(0));
rp.datak.new_plus(VV.data_ravno(1));
rp.sklad.new_plus(VV.data_ravno(2));
rp.prih_rash.new_plus(VV.data_ravno(3));
rp.kod_op.new_plus(VV.data_ravno(4));
rp.kod_kontr.new_plus(VV.data_ravno(5));
rp.nom_dok.new_plus(VV.data_ravno(6));

class iceb_tu_str kods("");
class iceb_tu_str naims("");

switch (kom)
 {
  case ESC:
  case FK10:
     return(1);
     break;

  case FK1:
    GDITE();
//    iceb_t_pdoc("matu5_10.txt");
    clear();
    goto naz;

  case PLU:
  case FK2:
  case FK5:
     break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка складов"));           //0
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка контрагентов"));      //1
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка операций приходов")); //2
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка операций расходов")); //3
    MENU.VVOD_spisok_add_MD(gettext("Выход"));

    clearstr(LINES-1,0);
    
    kom1=0;
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 4 :
      case -1:
       goto naz;

      case 0 :
        if(dirsklad(1,&kods,&naims) == 0)
         VV.data_z_plus(2,kods.ravno());
        goto naz;

      case 1 :
        vibrek("Kontragent",&kods,&naims);
        VV.VVOD_spisok_zapis_data(5,kods.ravno());
        goto naz;

      case 2 :
       if(dirprihod(1,&kods,&naims) == 0)
         VV.data_z_plus(4,kods.ravno());
        goto naz;

      case 3 :
        if(dirrashod(1,&kods,&naims) == 0)
          VV.data_z_plus(4,kods.ravno());
        goto naz;
        
     }
    goto naz;

  case FK4:
    VV.VVOD_clear_data();    
    goto naz;

  default:
    goto naz;
 }

short dn=0,mn=0,gn=0;
short dk=0,mk=0,gk=0;

if(iceb_t_rsdat(&dn,&mn,&gn,rp.datan.ravno(),&dk,&mk,&gk,rp.datak.ravno()) != 0)
 goto naz;
 
int tipz=0;
if(rp.prih_rash.ravno()[0] != '\0' )
 {
  if(iceb_tu_SRAV(rp.prih_rash.ravno(),"+",1) == 0)
    tipz=1;
  if(iceb_tu_SRAV(rp.prih_rash.ravno(),"-",1) == 0)
    tipz=2;
  if(tipz == 0)
   {
    iceb_t_soob(gettext("Не верно введён Приход/Расход !"));
    goto naz;
   }
 }

clear(); /*Очистить экран и закрасить фоновым цветом*/
GDITE();

time_t tmm;

time(&tmm);

move(0,0);

printw("%s %d.%d.%d%s %s %d.%d.%d%s\n",
gettext("Расчёт распределения НДС по видам операций\nза период с"),
dn,mn,gn,
gettext("г."),
gettext("до"),
dk,mk,gk,
gettext("г."));

/*Создаем массивы операций-материалов*/
char strsql[1024];
sprintf(strsql,"select kod from Prihod");

class SQLCURSOR cur;
class SQLCURSOR cur1;
class iceb_tu_spisok kod_op_prih;
class iceb_tu_spisok kod_op_rash;
int kolstr=0;
SQL_str row,row1;

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
  kod_op_prih.plus(row[0]);

sprintf(strsql,"select kod from Rashod");

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
  kod_op_rash.plus(row[0]);

int kolopp=kod_op_prih.kolih();
int kolopr=kod_op_rash.kolih();

printw("%s:%d\n",gettext("Количество операций приходов"),kolopp);
printw("%s:%d\n",gettext("Количество операций расходов"),kolopr);
refresh();

if(kolopp == 0 && kolopr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одной записи кодов операций !"));
  return(1);
 }

/*создаём список процентов НДС*/

class iceb_tu_spisok all_proc_nds;

sprintf(strsql,"select distinct pn from Dokummat where datd >= '%04d-%02d-%02d' \
and datd <= '%04d-%02d-%02d' and pod=1 and pn != 0.",
gn,mn,dn,gk,mk,dk);
 
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
 {
  all_proc_nds.plus(row[0]);
 }

all_proc_nds.plus("0-1");
all_proc_nds.plus("0-2");
all_proc_nds.plus("0-3");


int kolih_proc_nds=all_proc_nds.kolih();

class iceb_tu_double suma_dok_prih;
class iceb_tu_double suma_nds_prih;

class iceb_tu_double suma_dok_rash;
class iceb_tu_double suma_nds_rash;

suma_dok_prih.make_class(kolopp*kolih_proc_nds);
suma_nds_prih.make_class(kolopp*kolih_proc_nds);

suma_dok_rash.make_class(kolopr*kolih_proc_nds);
suma_nds_rash.make_class(kolopr*kolih_proc_nds);

sprintf(strsql,"select tip,datd,sklad,kontr,nomd,kodop,pn from Dokummat where datd >= '%04d-%02d-%02d' \
and datd <= '%04d-%02d-%02d' and pod=1 order by datd asc",
gn,mn,dn,gk,mk,dk);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

int vt=0;
iceb_t_poldan("Код группы возвратная тара",&vt,"matnast.alx");

int kolstr1=0;
class iceb_tu_str vid_nds("");
int nomer_nds=0;
int nomer_oper=0;
double suma=0;
double sumabn=0.;
double sumkor=0.;
double kolihmat=0.;
short dd=0,md=0,gd=0;
double suma_nds=0.;
double suma_dok=0.;
double suma_bez_nds=0.;
class iceb_tu_str proc_nds("");  

sprintf(imaf_prot,"rndsp%d.lst",getpid());

class iceb_fopen fil;
if(fil.start(imaf_prot,"w") != 0)
 return(1);


iceb_t_zagolov(gettext("Список документов вошедших в расчёт"),dn,mn,gn,dk,mk,gk,fil.ff);
xmurndsop_rrp(&rp,fil.ff);

class iceb_rnl_c rh;
xmurndsop_hap(&rh,NULL,fil.ff);

char metka_td[2];

while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);

  tipz=atoi(row[0]);

  if(rp.prih_rash.ravno()[0] == '+' && tipz == 2)
   continue;
  if(rp.prih_rash.ravno()[0] == '-' && tipz == 1)
   continue;

  if(iceb_tu_proverka(rp.sklad.ravno(),row[2],0,0) != 0)
    continue;  

  if(iceb_tu_proverka(rp.kod_op.ravno(),row[5],0,0) != 0)
    continue;  

  if(iceb_tu_proverka(rp.kod_kontr.ravno(),row[3],0,0) != 0)
    continue;  

  if(iceb_tu_proverka(rp.nom_dok.ravno(),row[4],0,0) != 0)
    continue;  

  proc_nds.new_plus(row[6]);

  if(proc_nds.ravno_atof() == 0.)
   {
    /*узнаём вид НДС этого документа*/
    sprintf(strsql,"select sodz from Dokummat2 where god=%d and nomd='%s' and sklad=%s and nomerz=11",
    atoi(row[1]),row[4],row[2]);

    if(iceb_t_sql_readkey(strsql,&row1,&cur1) <= 0)
     {
      iceb_t_soob(gettext("Не найден вид нулевого НДС"));
      continue;
     }
    else   
     {
      proc_nds.new_plus("0-");
      proc_nds.plus(row1[0]);
     }
   }


  if(tipz == 1)
   strcpy(metka_td,"+");
  else   
   strcpy(metka_td,"-");

  iceb_tu_rsdat(&dd,&md,&gd,row[1],2);
    
  sumzap1(dd,md,gd,row[4],atoi(row[2]),&suma,&sumabn,vt,&sumkor,tipz,&kolihmat);

  suma_nds=suma*proc_nds.ravno_atof()/100.;
  suma_nds=iceb_tu_okrug(suma_nds,0.01);

  suma_bez_nds=suma+sumabn;
  suma_dok=suma+suma_nds+sumabn;

/********************
+|  Дата    |Склад|Код кон.|Номер документа|Код оп.|НДС|   Сумма  |   НДС  |Сумма с НДС|\n");
1|1234567890|12345|12345678|123456789012345|1234567|123|1234567890|12345678|12345678901|
           tip,datd,sklad,kontr,nomd,kodop,pn
******************/
  printw("%s|%-5s|%-*s|%-*s|%-*s|%3.3g|%10.2f|%8.2f|%11.2f|\n",
  iceb_tu_datzap(row[1]),
  row[2],
  iceb_tu_kolbait(8,row[3]),
  row[3],
  iceb_tu_kolbait(15,row[4]),
  row[4],
  iceb_tu_kolbait(7,row[5]),
  row[5],
  atof(row[6]),
  suma_bez_nds,
  suma_nds,
  suma_dok);

  fprintf(fil.ff,"%s|%s|%-5s|%-*s|%-*s|%-*s|%3.3g|%10.2f|%8.2f|%11.2f|\n",
  metka_td,
  iceb_tu_datzap(row[1]),
  row[2],
  iceb_tu_kolbait(8,row[3]),
  row[3],
  iceb_tu_kolbait(15,row[4]),
  row[4],
  iceb_tu_kolbait(7,row[5]),
  row[5],
  atof(row[6]),
  suma_bez_nds,
  suma_nds,
  suma_dok);
  
  if((nomer_nds=all_proc_nds.find(proc_nds.ravno())) < 0)
   {
    sprintf(strsql,"%s %s %s!",gettext("Не нашли вид НДС"),vid_nds.ravno(),gettext("в списке видов НДС"));
    iceb_t_soob(strsql);
    continue;
   }

  if(tipz == 1)
   {
    if((nomer_oper=kod_op_prih.find(row[5])) < 0)
     {
      sprintf(strsql,"%s %s %s!",gettext("Не нашли код операции"),row[5],gettext("в списке приходных кодов операций"));
      iceb_t_soob(strsql);
      continue;
     }
    suma_dok_prih.plus(suma_dok,nomer_oper*kolih_proc_nds+nomer_nds);    
    suma_nds_prih.plus(suma_nds,nomer_oper*kolih_proc_nds+nomer_nds);    
   }
  else
   {
    if((nomer_oper=kod_op_rash.find(row[5])) < 0)
     {
      sprintf(strsql,"%s %s %s!",gettext("Не нашли код операции"),row[5],gettext("в списке расходных кодов операций"));
      iceb_t_soob(strsql);
      continue;
     }
    suma_dok_rash.plus(suma_dok,nomer_oper*kolih_proc_nds+nomer_nds);    
    suma_nds_rash.plus(suma_nds,nomer_oper*kolih_proc_nds+nomer_nds);    

   }


 }

GDITE();

fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"\
----------------------------------------------------------------------------------------\n");

iceb_t_podpis(fil.ff);
fil.end();


sprintf(imaf,"rnds%d.lst",getpid());
if(fil.start(imaf,"w") != 0)
 return(1);


iceb_t_zagolov(gettext("Распределение НДС по видам операций"),dn,mn,gn,dk,mk,gk,fil.ff);
xmurndsop_rrp(&rp,fil.ff);


fprintf(fil.ff,"\n");

if(rp.prih_rash.ravno()[0] == '\0' || rp.prih_rash.ravno()[0] == '+')
 xmurndsop_rm(1,&kod_op_prih,&all_proc_nds,&suma_dok_prih,&suma_nds_prih,fil.ff);

fprintf(fil.ff,"\n");

if(rp.prih_rash.ravno()[0] == '\0' || rp.prih_rash.ravno()[0] == '-')
 xmurndsop_rm(2,&kod_op_rash,&all_proc_nds,&suma_dok_rash,&suma_nds_rash,fil.ff);




iceb_t_podpis(fil.ff);
fil.end();



oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Распределение НДС по видам операций"));
oth->spis_imaf.plus(imaf_prot);
oth->spis_naim.plus(gettext("Протокол хода расчёта"));

iceb_t_ustpeh(oth->spis_imaf.ravno(0),0);

iceb_t_ustpeh(imaf_prot,3,&rh.orient);
iceb_t_rnl(imaf_prot,&rh,&xmurndsop_hap);



printw_vr(tmm);


OSTANOV();
return(0);
}
/***************************************/
/*распечатка массивов*/
/****************************************/

void xmurndsop_rm(int tipz, /*1-приходы 2-расходы*/
class iceb_tu_spisok *kod_op, /*коды операций*/
class iceb_tu_spisok *all_proc_nds,
class iceb_tu_double *suma_dok,
class iceb_tu_double *suma_nds,
FILE *ff)
{
class iceb_tu_str liniq("-----------------------------------------------"); /*линия над кодом и наименованием*/


if(tipz == 1)
 fprintf(ff,"%s\n",gettext("Приходные операции"));
else
 fprintf(ff,"%s\n",gettext("Расходные операции"));
 

int kolih_nds=all_proc_nds->kolih();
int kolih_oper=kod_op->kolih();

for(int nom=0; nom < kolih_nds; nom++) /*линия над числами*/
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
   liniq.plus("-----------------------");
 }

fprintf(ff,"%s\n",liniq.ravno());

/*первая строка шапки*/
fprintf(ff,"%s",gettext("\
 Код |         Наименование операции          |"));

/***********************
12345|1234567890123456789012345678901234567890|12345678901|1234567890|
*************/

for(int nom=0; nom < kolih_nds; nom++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
    fprintf(ff,"%-22s|",all_proc_nds->ravno(nom));
 }

fprintf(ff,"\n");

/*вторая строка шапки*/
fprintf(ff,"\
     |                                        |");

for(int nom=0; nom < kolih_nds; nom++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nom) != 0)
   fprintf(ff,"%s",gettext("Сумма с НДС|    НДС   |"));
 }

fprintf(ff,"\n");

fprintf(ff,"%s\n",liniq.ravno());

class iceb_tu_str naim_op("");
class iceb_tu_str kop("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double suma_d=0.;
double suma_n=0.;

for(int nom_oper=0; nom_oper < kod_op->kolih(); nom_oper++)
 {
  if(suma_dok->prov_str(kolih_oper,kolih_nds,nom_oper) == 0)
   continue;
  kop.new_plus(kod_op->ravno(nom_oper));

  if(tipz == 1)
   sprintf(strsql,"select naik from Prihod where kod='%s'",kop.ravno()); 

  if(tipz == 2)
   sprintf(strsql,"select naik from Rashod where kod='%s'",kop.ravno()); 

  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   naim_op.new_plus(row[0]);
  else
   naim_op.new_plus("");

  fprintf(ff,"%-*s|%-*.*s|",
  iceb_tu_kolbait(5,kop.ravno()),
  kop.ravno(),
  iceb_tu_kolbait(40,naim_op.ravno()),
  iceb_tu_kolbait(40,naim_op.ravno()),
  naim_op.ravno());
          
  for(int nomer_nds=0; nomer_nds < kolih_nds; nomer_nds++)
   {
    if(suma_dok->prov_kol(kolih_oper,kolih_nds,nomer_nds) == 0)
     continue;  
    suma_d=suma_dok->ravno(nom_oper*kolih_nds+nomer_nds);
    suma_n=suma_nds->ravno(nom_oper*kolih_nds+nomer_nds);

    if(suma_d != 0.)
     fprintf(ff,"%11.2f|",suma_d);
    else
     fprintf(ff,"%11s|","");

    if(suma_n != 0.)
     fprintf(ff,"%10.2f|",suma_n);
    else
     fprintf(ff,"%10s|","");
     
   }

  fprintf(ff,"\n");

 }
fprintf(ff,"%s\n",liniq.ravno());

fprintf(ff,"%*s|",iceb_tu_kolbait(46,gettext("Итого")),gettext("Итого"));

for(int nomer_nds=0; nomer_nds < kolih_nds; nomer_nds++)
 {
  if(suma_dok->prov_kol(kolih_oper,kolih_nds,nomer_nds) == 0)
     continue;  
  suma_d=suma_dok->suma_kol(kolih_oper,kolih_nds,nomer_nds);
  suma_n=suma_nds->suma_kol(kolih_oper,kolih_nds,nomer_nds);

  if(suma_d != 0.)
     fprintf(ff,"%11.2f|",suma_d);
  else
     fprintf(ff,"%11s|","");

  if(suma_n != 0.)
   fprintf(ff,"%10.2f|",suma_n);
  else
   fprintf(ff,"%10s|","");

 }
 
fprintf(ff,"\n%s\n",liniq.ravno());


}
/*********************************/
/*распечатка реквизитов поиска*/
/*******************************/
void xmurndsop_rrp(class xmurndsop_rp *rp,FILE *ff)
{
if(rp->sklad.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Склад"),rp->sklad.ravno());
if(rp->prih_rash.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Приход/расход"),rp->prih_rash.ravno());
if(rp->kod_op.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rp->kod_op.ravno());
if(rp->kod_kontr.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код контрагента"),rp->kod_kontr.ravno());
if(rp->nom_dok.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Номер документа"),rp->nom_dok.ravno());

}
/**************************************/
/*шапка*/
/**************************************/
void xmurndsop_hap(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"\
----------------------------------------------------------------------------------------\n");

fprintf(ff,"%s\n",gettext("\
 |  Дата    |Склад|Код кон.|Номер документа|Код оп.|НДС|   Сумма  |   НДС  |Сумма с НДС|"));
/****************
1234567890|12345|12345678|123456789012345|1234567|123|1234567890|12345678|12345678901|
*****************/
fprintf(ff,"\
----------------------------------------------------------------------------------------\n");

}
