/* $Id: rasprov.c,v 5.43 2013/09/26 09:43:39 sasa Exp $ */
/*05.07.2024	27.04.1999	Белых А.И.	rasprov.c
Распечатка проводок в файл
*/
#include        <errno.h>
#include        "buhg.h"

void raspitog(double,double,int,FILE*);
void rasprov_s_hap(int nomstr,int *kolstr,FILE *ff);
int rasprov_sknk(const char *koment,const char *naim_kontr,class iceb_tu_spisok *sknk);
void rasprov_up(class poiprov_rek *poi,FILE *ff);


int rasprov(SQLCURSOR *cur,
int kolstr,
class poiprov_rek *poi)
{
SQL_str         row;
char		imaf[64],imafden[64],imafsvod[64];
double		dbt,krt;
double		dbtden=0.,krtden=0.;
double		dbtmes=0.,krtmes=0.;
class iceb_tu_str naikon("");
char		strsql[512];
class iceb_tu_str shet("");
time_t tmm;
struct tm *bf;
class iceb_tu_str shetk("");
long		kol;
short		d,m,g;
short		denz,mesz;
double		debet,kredit;
int		nomer=0;
class iceb_tu_str koment("");
short dn,mn,gn;
short dk,mk,gk;
iceb_tu_rsdat(&dn,&mn,&gn,poi->datan.ravno(),1);
iceb_tu_rsdat(&dk,&mk,&gk,poi->datak.ravno(),1);


SQLCURSOR       cur1;
VVOD SOOBN(1);
SOOBN.VVOD_spisok_add_MD(gettext("Подготовка распечаток"));
soobsh(&SOOBN,-1,-1,1);

move(LINES-1,0);
GDITE();

sprintf(imaf,"prov%d.lst",getpid());

class iceb_fopen fil_r;
if(fil_r.start(imaf,"w") != 0)
 return(1);


sprintf(imafden,"provd%d.lst",getpid());
class iceb_fopen fil_den;
if(fil_den.start(imafden,"w") != 0)
 return(1);

sprintf(imafsvod,"provs%d.lst",getpid());
class iceb_fopen fil_svod;
if(fil_svod.start(imafsvod,"w") != 0)
 return(1);

iceb_t_zagolov(gettext("Распечатка проводок"),dn,mn,gn,dk,mk,gk,fil_r.ff);
iceb_t_zagolov(gettext("Распечатка проводок"),dn,mn,gn,dk,mk,gk,fil_den.ff);
iceb_t_zagolov(gettext("Свод по счетам"),dn,mn,gn,dk,mk,gk,fil_svod.ff);

/*распечатка условий поиска*/
rasprov_up(poi,fil_r.ff);
rasprov_up(poi,fil_den.ff);
rasprov_up(poi,fil_svod.ff);

rapsap(1,NULL,fil_r.ff);

rapsap(1,NULL,fil_den.ff);

iceb_tu_spisok SHET(0);
iceb_tu_double DEB(0); //Массив содержимого кодов начислений
iceb_tu_double KRE(0); //Массив содержимого кодов начислений
class iceb_tu_spisok sknk;

mesz=denz=0;
kol=0;
dbt=krt=0.;
cur->poz_cursor(0);
long kol_prov=0;
while(cur->read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kol);
  if(provprov(row,poi) != 0)
    continue;
  
  kol_prov++;
  
  iceb_tu_rsdat(&d,&m,&g,row[1],2);
  debet=atof(row[9]);
  kredit=atof(row[10]);

  sprintf(strsql,"%s|%s",row[2],row[3]);
  if((nomer=SHET.find(strsql)) != -1)
   {
    DEB.plus(debet,nomer);
    KRE.plus(kredit,nomer);
   }  
  else
   {
    SHET.plus(strsql);
    DEB.plus(debet,-1);
    KRE.plus(kredit,-1);
   }
  if(denz != d)
   {
    if(denz != 0)
      raspitog(dbtden,krtden,1,fil_den.ff);
    
    dbtden=krtden=0.;
    denz=d;
   }
  if(mesz != m)
   {
    if(mesz != 0)
      raspitog(dbtmes,krtmes,2,fil_den.ff);
    
    dbtmes=krtmes=0.;
    mesz=m;
   }

  naikon.new_plus("");

  /*получение наименования контрагента*/
  buhpnk(&naikon,row[4],iceb_t_mpods(row[5]),atoi(row[15]),row[14],row[6],atoi(row[7]));

  sozkom(&koment,row[13],row[5],row[8]);

  fprintf(fil_r.ff,"%02d.%02d.%4d|%-*s|%-*s|%-*s|%-*s%*s|%-*s|%10s",
  d,m,g,
  iceb_tu_kolbait(6,row[2]),row[2],
  iceb_tu_kolbait(6,row[3]),row[3],
  iceb_tu_kolbait(7,row[4]),row[4],
  iceb_tu_kolbait(3,row[5]),row[5],
  iceb_tu_kolbait(4,row[11]),row[11],
  iceb_tu_kolbait(10,row[6]),row[6],
  iceb_tu_prnbr(debet));

  fprintf(fil_r.ff,"|%10s|%*s|%-*s|%-*.*s|%.*s\n",
  iceb_tu_prnbr(kredit),
  iceb_tu_kolbait(4,row[16]),row[16],
  iceb_tu_kolbait(4,row[8]),row[8],
  iceb_tu_kolbait(32,koment.ravno()),
  iceb_tu_kolbait(32,koment.ravno()),
  koment.ravno(),
  iceb_tu_kolbait(40,naikon.ravno()),
  naikon.ravno());


  fprintf(fil_den.ff,"%02d.%02d.%4d|%-*s|%-*s|%-*s|%-*s%*s|%-*s|%10s",
  d,m,g,
  iceb_tu_kolbait(6,row[2]),row[2],
  iceb_tu_kolbait(6,row[3]),row[3],
  iceb_tu_kolbait(7,row[4]),row[4],
  iceb_tu_kolbait(3,row[5]),row[5],
  iceb_tu_kolbait(4,row[11]),row[11],
  iceb_tu_kolbait(10,row[6]),row[6],
  iceb_tu_prnbr(debet));

  fprintf(fil_den.ff,"|%10s|%*s|%-*s|%-*.*s|%.*s\n",
  iceb_tu_prnbr(kredit),
  iceb_tu_kolbait(4,row[16]),row[16],
  iceb_tu_kolbait(4,row[8]),row[8],
  iceb_tu_kolbait(32,koment.ravno()),
  iceb_tu_kolbait(32,koment.ravno()),
  koment.ravno(),
  iceb_tu_kolbait(40,naikon.ravno()),
  naikon.ravno());

  if(rasprov_sknk(koment.ravno(),naikon.ravno(),&sknk) == 0)
   for(int nom=0; nom < sknk.kolih(); nom++)
    {
     fprintf(fil_r.ff,"%10s|%6s|%6s|%7s|%7s|%10s|%10s|%10s|%4s|%4s|%-s\n",
     "","","","","","","","","","",
     sknk.ravno(nom));
     fprintf(fil_den.ff,"%10s|%6s|%6s|%7s|%7s|%10s|%10s|%10s|%4s|%4s|%-s\n",
     "","","","","","","","","","",
     sknk.ravno(nom));
    }

  if(poi->datanz.ravno()[0] != '\0')
   {
   
    tmm=atoi(row[12]);
    bf=localtime(&tmm);

    fprintf(fil_r.ff,"%s: %d.%d.%d%s %s: %d:%d:%d\n",
    gettext("Дата записи проводки"),
    bf->tm_mday,bf->tm_mon+1,bf->tm_year+1900,
    gettext("г."),
    gettext("Время"),
    bf->tm_hour,bf->tm_min,bf->tm_sec);

    fprintf(fil_den.ff,"%s: %d.%d.%d%s %s: %d:%d:%d\n",
    gettext("Дата записи проводки"),
    bf->tm_mday,bf->tm_mon+1,bf->tm_year+1900,
    gettext("г."),
    gettext("Время"),
    bf->tm_hour,bf->tm_min,bf->tm_sec);

   }

  dbt+=debet;
  krt+=kredit;
  dbtden+=debet;
  krtden+=kredit;
  dbtmes+=debet;
  krtmes+=kredit;
 }
fprintf(fil_r.ff,"ICEB_LST_END\n");
fprintf(fil_den.ff,"ICEB_LST_END\n");

GDITE();

raspitog(dbt,krt,0,fil_r.ff);
raspitog(dbtden,krtden,1,fil_den.ff);
raspitog(dbtmes,krtmes,2,fil_den.ff);
raspitog(dbt,krt,0,fil_den.ff);

fprintf(fil_r.ff,"%s:%ld\n",gettext("Количество проводок"),kol_prov);
iceb_t_podpis(fil_r.ff);
fil_r.end();


iceb_t_podpis(fil_den.ff);
fil_den.end();

/*******************************/
//Распечатка свода по счетам

fprintf(fil_svod.ff,"\n");
rasprov_s_hap(1,NULL,fil_svod.ff);

int kolelem=SHET.kolih();

for(nomer=0; nomer < kolelem; nomer++)
 {
  strcpy(strsql,SHET.ravno(nomer));
  iceb_tu_polen(strsql,&shet,1,'|');
  iceb_tu_polen(strsql,&shetk,2,'|');
  
  fprintf(fil_svod.ff,"%-*s %-*s %10.2f %10.2f\n",
  iceb_tu_kolbait(8,shet.ravno()),shet.ravno(),
  iceb_tu_kolbait(8,shetk.ravno()),shetk.ravno(),
  DEB.ravno(nomer),
  KRE.ravno(nomer));
  
 }
fprintf(fil_svod.ff,"ICEB_LST_END\n");
fprintf(fil_svod.ff,"\
----------------------------------------\n");
fprintf(fil_svod.ff,"%*s %10.2f %10.2f\n",
iceb_tu_kolbait(17,gettext("Итого")),gettext("Итого"),dbt,krt);

iceb_t_podpis(fil_svod.ff);
fil_svod.end();

class spis_oth oth;

oth.spis_imaf.plus(imaf);
oth.spis_naim.plus(gettext("Распечатка проводок"));

oth.spis_imaf.plus(imafden);
oth.spis_naim.plus(gettext("Распечатка проводок с дневными итогами"));

oth.spis_imaf.plus(imafsvod);
oth.spis_naim.plus(gettext("Свод по счетам"));

int orient=0;

iceb_t_ustpeh(imaf,3,&orient);
iceb_t_rnl(imaf,orient,"",&rapsap);

iceb_t_ustpeh(imafden,3,&orient);
iceb_t_rnl(imafden,orient,"",&rapsap);

iceb_t_ustpeh(imafsvod,3,&orient);
iceb_t_rnl(imafsvod,orient,"",&rasprov_s_hap);

iceb_t_rabfil(&oth,"");

return(0);
}
/****************************************/
/*шапка свода*/
/*******************************************/
void rasprov_s_hap(int nomstr,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;
fprintf(ff,"\
----------------------------------------\n");
fprintf(ff,gettext("\
  Счёт  |Счёт кор|  Дебет   |  Кредит  |\n"));
fprintf(ff,"\
----------------------------------------\n");
}

/*******/
/*Шапка*/
/*******/
void	rapsap(int nomstr,int *kolstr,FILE *ff1)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;
 
fprintf(ff1,"\
----------------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(ff1,gettext("\
  Дата    | Счёт |Сч.к-т|Контра.| Кто   |Номер док.|   Дебет  |  Кредит  |КЭКЗ|К.о.|      К о м е н т а р и й       |Наименование контрагента|\n"));

fprintf(ff1,"\
----------------------------------------------------------------------------------------------------------------------------------------------\n");

}
/************************************************/
/*  список коментаниев и наименований контрагента*/
/************************************************/
int rasprov_sknk(const char *koment,const char *naim_kontr,class iceb_tu_spisok *sknk)
{
int dlinna_kom=iceb_tu_strlen(koment);
int dlinna_naim=iceb_tu_strlen(naim_kontr);

if(dlinna_kom <= 32 && dlinna_naim <= 40)
 return(1);

int nom_kom=32; 
int nom_naim=40;
char buffer[1024];
class iceb_tu_str stroka;
sknk->free_class();


for(; nom_kom <= dlinna_kom || nom_naim <= dlinna_naim;)
 {
  
  if(nom_kom <= dlinna_kom)
   sprintf(buffer,"%-*.*s|",
   iceb_tu_kolbait(32,iceb_tu_adrsimv(nom_kom,koment)),
   iceb_tu_kolbait(32,iceb_tu_adrsimv(nom_kom,koment)),
   iceb_tu_adrsimv(nom_kom,koment));
 else
   sprintf(buffer,"%32s|","");
  
  stroka.new_plus(buffer);
  
  memset(buffer,'\0',sizeof(buffer));
    
  if(nom_naim <= dlinna_naim)
   sprintf(buffer,"%.*s",
   iceb_tu_kolbait(40,iceb_tu_adrsimv(nom_naim,naim_kontr)),
   iceb_tu_adrsimv(nom_naim,naim_kontr));

  stroka.plus(buffer);

  sknk->plus(stroka.ravno());
  nom_kom+=32;
  nom_naim+=40;
 }

return(0);
}
/**********************************************/
/*условия поиск*/
/************************************************/
void rasprov_up(class poiprov_rek *poi,FILE *ff)
{



fprintf(ff,"%s:\n",gettext("Реквизиты поиска"));
if(poi->shet.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Счёт"),poi->shet.ravno());
 }
if(poi->shetk.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Счёт корреспондент"),poi->shetk.ravno());
 }
if(poi->kontr.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Код контрагента"),poi->kontr.ravno());
 }
if(poi->koment.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Коментарий"),poi->koment.ravno());
 }
if(poi->debet.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Дебет"),poi->debet.ravno());
 }
if(poi->kredit.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Кредит"),poi->kredit.ravno());
 }
if(poi->metka.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Метка проводки"),poi->metka.ravno());
 }
if(poi->nomdok.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Номер документа"),poi->nomdok.ravno());
 }
if(poi->kodop.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Код операции"),poi->kodop.ravno());
 }  
if(poi->grupak.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Группа"),poi->grupak.ravno());
 }  

if(poi->status.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Статус счетов"),poi->status.ravno());
 }  

if(poi->kekv.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("КЭКЗ"),poi->kekv.ravno());
 }  
if(poi->datanz.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s => %s\n",gettext("Поиск по дате записи"),poi->datanz.ravno(),poi->datakz.ravno());
 }  
if(poi->kod_subbal.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Код суббаланса"),poi->kod_subbal.ravno());
 }  

}