/*$Id:$*/
/*14.11.2024	14.03.2011	Белых А.И.	rasdolgi2.c
Распечатать долги предприятия по зарплате своим работникам
Расчёт применяется после 1.1.2011
*/
#include <math.h>
#include <errno.h>
#include "buhg.h"

void rasdolgi2_s(const char *data_nah,short dd,short md,short gd,const char *tabnom,const char *podr,FILE *ff);
void rasdolgi2_hap(int nomstr,int *kolstr,FILE *ff);
void rasdolgi2_hap1(int nomstr,int *kolstr,FILE *ff);


extern class iceb_tu_str kodpn_all;

extern short kodvn; /*код военного сбора*/
extern short kodvs_b; /*код военного сбора с больничного*/

extern short	*obud; /*Обязательные удержания*/
extern int kod_esv; /*Код удержания единого социального взноса*/
extern int kod_esv_bol; /*Код удержания единого социального взноса*/
extern int kod_esv_inv; /*Код удержания единого социального взноса*/
extern int kod_esv_dog; /*Код удержания единого социального взноса*/

extern int kodf_esv; /*Код фонда удержания единого социального взноса*/
extern int kodf_esv_bol; /*Код фонда удержания единого социального взноса*/
extern int kodf_esv_inv; /*Код фонда удержания единого социального взноса*/
extern int kodf_esv_dog; /*Код фонда удержания единого социального взноса*/

int rasdolgi2(const char *data_nah,
const char *data_rash,
const char *podr,
const char *tabnom,
int mras,
class spis_oth *oth)
{
short mes_nah,god_nah;
short dd,md,gd;
if(iceb_tu_rsdat1(&mes_nah,&god_nah,data_nah) != 0)
 {
  iceb_t_soob(gettext("Не верно введена дата начисления !"));
  return(1);
 }
if(iceb_tu_rsdat(&dd,&md,&gd,data_rash,0) != 0)
 {
  iceb_t_soob(gettext("Не верно введена дата долга !"));
  return(1);
 }

char imaf[64];
sprintf(imaf,"golg2%d.lst",getpid());
char imaf_soc[64];
sprintf(imaf_soc,"golg2s%d.lst",getpid());
char imaf_prot[64];
sprintf(imaf_prot,"golgp2%d.lst",getpid());

class iceb_fopen fil;
if(fil.start(imaf,"w") != 0)
 return(1);

class iceb_fopen ff_prot;

if(ff_prot.start(imaf_prot,"w") != 0)
 return(1);
class iceb_fopen ff_soc;

if(ff_soc.start(imaf_soc,"w") != 0)
 return(1);

rasdolgi2_s(data_nah,dd,md,gd,tabnom,podr,fil.ff);
rasdolgi2_s(data_nah,dd,md,gd,tabnom,podr,ff_soc.ff);
rasdolgi2_s(data_nah,dd,md,gd,tabnom,podr,ff_prot.ff);

zarrnesv();
int kolstr=0;
int kolstr1=0;
int kolstr2=0;
SQL_str row,row1;
class SQLCURSOR cur,cur1;
char strsql[1024];
sprintf(strsql,"select tabn,podr from Zarn where god=%d and mes=%d \
order by podr,tabn asc",god_nah,mes_nah);
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr ==  0)
 {
  iceb_t_soob(gettext("Не найдено ни одной записи!"));
  return(1);
 }


rasdolgi2_hap1(1,NULL,fil.ff);
rasdolgi2_hap(1,NULL,ff_soc.ff);

const int RAZMER_MAS=13;
double suma_str[RAZMER_MAS];
double suma_str_mes[RAZMER_MAS];
double suma_str_dolg[RAZMER_MAS];
double isuma_str[RAZMER_MAS];
double isuma_str_dolg[RAZMER_MAS];

memset(isuma_str,'\0',sizeof(isuma_str));
memset(isuma_str_dolg,'\0',sizeof(isuma_str_dolg));
class iceb_tu_str fio("");
int tabn=0;
int knah=0;
double sumanu=0.;
double i_suma_uder=0.;
while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);
  if(iceb_tu_proverka(podr,row[1],0,0) != 0)
    continue;

  if(iceb_tu_proverka(tabnom,row[0],0,0) != 0)
    continue;
  tabn=atoi(row[0]);  
  fio.new_plus("");
  sprintf(strsql,"select fio from Kartb where tabn=%d",tabn);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
    fio.new_plus(row1[0]);

  fprintf(ff_prot.ff,"\n%d %s\n",tabn,fio.ravno());

  /*Узнаём какая сумма к выплате и суммы всех отчислений*/
  memset(suma_str,'\0',sizeof(suma_str));
  memset(suma_str_dolg,'\0',sizeof(suma_str_dolg));

  
  sprintf(strsql,"select prn,knah,suma,datz,godn,mesn from Zarp where \
 datz >= '%04d-%d-%d' and datz <= '%04d-%d-%d' and tabn=%s and suma <> 0.",
  god_nah,mes_nah,1,god_nah,mes_nah,31,row[0]);
  if((kolstr2=cur1.make_cursor(&bd,strsql)) < 0)
   {
    iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
    continue;
   }

  memset(suma_str_mes,'\0',sizeof(suma_str_mes));    

  while(cur1.read_cursor(&row1) != 0)
   {
    knah=atoi(row1[1]);
    sumanu=atof(row1[2]);
    if(atoi(row1[0]) == 1)
     {
      suma_str_mes[0]+=sumanu;
     }
    else
     {
      if(knah == kod_esv)
       suma_str_mes[4]+=sumanu;
      if(knah == kod_esv_bol)
       suma_str_mes[6]+=sumanu;
      if(knah == kod_esv_inv)
       suma_str_mes[8]+=sumanu;
      if(knah == kod_esv_dog)
       suma_str_mes[10]+=sumanu;

      if(iceb_tu_proverka(kodpn_all.ravno(),knah,0,1) == 0)
       suma_str_mes[11]+=sumanu;

      if(knah == kodvn || knah == kodvs_b)
       suma_str_mes[12]+=sumanu;



      if(provkod(obud,knah) >= 0)
       {
        suma_str_mes[1]+=sumanu;
        continue;  
       }        
     }
   }
  suma_str_mes[2]=suma_str_mes[0]+suma_str_mes[1];    

  fprintf(ff_prot.ff,"Cумма всех начислений=%.2f\n",suma_str_mes[0]);
  fprintf(ff_prot.ff,"Cумма обязательных удержаний=%.2f\n",suma_str_mes[1]);
  fprintf(ff_prot.ff,"Cумма к выдаче=%.2f\n",suma_str_mes[2]);
  
  /*определяем сумму всех удержаний в счёт этого месяца*/
  double suma_uder=prbper1(mes_nah,god_nah,dd,md,gd,tabn,ff_prot.ff);
  fprintf(ff_prot.ff,"Сумма удержаний в счёт этого месяца=%.2f\n",suma_uder);
  suma_str_dolg[2]+=suma_str_mes[0]+suma_uder;
  
  if(suma_str_mes[0] + suma_uder < -0.01)
   {
    sprintf(strsql,"%s %s\n%s %.2f %s %.2f. %s!\n%s=%.2f",
    row[0],fio.ravno(),
    gettext("Сумма удержаний"),
    suma_uder,
    gettext("больше суммы начислений"),
    suma_str_mes[0],
    gettext("Это ошибка"),
    gettext("Разница"),
    suma_str_mes[0]+suma_uder);

    iceb_t_soob(strsql);
   }

  double koef=0.;
  if(fabs(suma_str_mes[0]+suma_uder) > 0.009 && fabs(suma_str_mes[2]) > 0.009)
    koef=(suma_str_mes[0]+suma_uder)/suma_str_mes[2];

  fprintf(ff_prot.ff,"Коэффициент: (%.2f %.2f)/%.2f=%f\n",
  suma_str_mes[0],suma_uder,suma_str_mes[2],koef);

  if(mras == 1 && fabs(suma_str_mes[0]+suma_uder) < 0.009 )
    continue;
  i_suma_uder+=suma_uder;
  
  /*Смотрим начисления на фонд зарплаты*/
  sprintf(strsql,"select kodz,sumap from Zarsocz where datz='%04d-%02d-01' and tabn=%s",god_nah,mes_nah,row[0]);
  if((kolstr2=cur1.make_cursor(&bd,strsql)) < 0)
   {
    iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
    continue;
   }

  int kod_fonda=0;

  while(cur1.read_cursor(&row1) != 0)
   {
    kod_fonda=atoi(row1[0]);
    sumanu=atof(row1[1]);

    if(kod_fonda == kodf_esv)
     suma_str_mes[3]+=sumanu;    
    if(kod_fonda == kodf_esv_bol)
     suma_str_mes[5]+=sumanu;    
    if(kod_fonda == kodf_esv_inv)
     suma_str_mes[7]+=sumanu;    
    if(kod_fonda == kodf_esv_dog)
     suma_str_mes[9]+=sumanu;    

   }

  for(int nomm=0; nomm < RAZMER_MAS; nomm++)
    suma_str[nomm]+=suma_str_mes[nomm];

  /*Делаем расчёт налогов на долг*/
  if(koef != 0.)
   for(int nomm=3; nomm < RAZMER_MAS; nomm++)
    {
     if(fabs(suma_str_mes[nomm]) > 0.009)
      {
       fprintf(ff_prot.ff,"%s-nomm=%d %.2f+%.2f*%f=",__FUNCTION__,nomm,suma_str_dolg[nomm],suma_str_mes[nomm],koef);
       suma_str_dolg[nomm]+=suma_str_mes[nomm]*koef;
       fprintf(ff_prot.ff,"%.2f\n",suma_str_dolg[nomm]);
      }
    }

  fprintf(fil.ff,"%-5d %-*.*s %10.2f %10.2f %10.2f\n",
  tabn,
  iceb_tu_kolbait(30,fio.ravno()),iceb_tu_kolbait(30,fio.ravno()),fio.ravno(),
  suma_str_mes[0],suma_uder,suma_str_mes[0]+suma_uder);

  fprintf(ff_soc.ff,"%5s %-*.*s %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f\n",
  row[0],
  iceb_tu_kolbait(30,fio.ravno()),
  iceb_tu_kolbait(30,fio.ravno()),
  fio.ravno(),
  suma_str[0],
  suma_str[1],
  suma_str[2],
  suma_str[3],
  suma_str[4],
  suma_str[5],
  suma_str[6],
  suma_str[7],
  suma_str[8],
  suma_str[9],
  suma_str[10],
  suma_str[11],
  suma_str[12],
  suma_str[3]+suma_str[9],
  suma_str[4]+suma_str[10]);

  fprintf(ff_soc.ff,"%*s %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f\n",
  iceb_tu_kolbait(58,gettext("Долг")),
  gettext("Долг"),
  suma_str_dolg[2],
  suma_str_dolg[3],
  suma_str_dolg[4],
  suma_str_dolg[5],
  suma_str_dolg[6],
  suma_str_dolg[7],
  suma_str_dolg[8],
  suma_str_dolg[9],
  suma_str_dolg[10],
  suma_str_dolg[11],
  suma_str_dolg[12],
  suma_str_dolg[3]+suma_str_dolg[9],
  suma_str_dolg[4]+suma_str_dolg[10]);



  for(int nomm=0; nomm < RAZMER_MAS; nomm++)
   {
    isuma_str[nomm]+=suma_str[nomm];
    isuma_str_dolg[nomm]+=suma_str_dolg[nomm];
   }  

 }

fprintf(ff_soc.ff,"ICEB_LST_END\n");
fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"\
----------------------------------------------------------------------\n");
fprintf(fil.ff,"%*s %10.2f %10.2f %10.2f\n",
iceb_tu_kolbait(36,gettext("Итого")),
gettext("Итого"),
isuma_str[0],i_suma_uder,isuma_str[0]+i_suma_uder);

fprintf(ff_soc.ff,"\
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

fprintf(ff_soc.ff,"%*s %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f\n",
iceb_tu_kolbait(36,gettext("Итого начислено")),
gettext("Итого начислено"),
isuma_str[0],
isuma_str[1],
isuma_str[2],
isuma_str[3],
isuma_str[4],
isuma_str[5],
isuma_str[6],
isuma_str[7],
isuma_str[8],
isuma_str[9],
isuma_str[10],
isuma_str[11],
isuma_str[12],
isuma_str[3]+isuma_str[9],
isuma_str[4]+isuma_str[10]);

fprintf(ff_soc.ff,"\
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

fprintf(ff_soc.ff,"%*s %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f\n",
iceb_tu_kolbait(58,gettext("Итого долгов")),
gettext("Итого долгов"),
isuma_str_dolg[2],
isuma_str_dolg[3],
isuma_str_dolg[4],
isuma_str_dolg[5],
isuma_str_dolg[6],
isuma_str_dolg[7],
isuma_str_dolg[8],
isuma_str_dolg[9],
isuma_str_dolg[10],
isuma_str_dolg[11],
isuma_str_dolg[12],
isuma_str_dolg[4]+isuma_str_dolg[9],
isuma_str_dolg[4]+isuma_str_dolg[10]);
 



iceb_t_podpis(fil.ff);
fil.end();
iceb_t_podpis(ff_soc.ff);
ff_soc.end();
iceb_t_podpis(ff_prot.ff);
ff_prot.end();

oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Распечатка долгов"));

oth->spis_imaf.plus(imaf_soc);
oth->spis_naim.plus(gettext("Расчёт долгов по соц. фондам"));

oth->spis_imaf.plus(imaf_prot);
oth->spis_naim.plus(gettext("Протокол розрахунку"));

iceb_t_ustpeh(oth->spis_imaf.ravno(0),3,&kolstr);
iceb_t_rnl(oth->spis_imaf.ravno(0),kolstr,"",&rasdolgi2_hap1);

iceb_t_ustpeh(oth->spis_imaf.ravno(1),3,&kolstr);
iceb_t_rnl(oth->spis_imaf.ravno(1),kolstr,"",&rasdolgi2_hap);

iceb_t_ustpeh(oth->spis_imaf.ravno(2),3);



return(0);
}
/****************************************/
/*Шапка файла*/
/******************************************/
void rasdolgi2_s(const char *data_nah,
short dd,short md,short gd,
const char *tabnom,
const char *podr,
FILE *ff)
{

struct  tm      *bf;
time_t tmm;
time(&tmm);
bf=localtime(&tmm);

fprintf(ff,"%s\n\
%s %s %s %d.%d.%d%s\n\
%s %d.%d.%d%s  %s: %02d:%02d\n",
iceb_t_get_pnk("00",0),
gettext("Долг по зарплате за"),
data_nah,
gettext("на"),
dd,md,gd,
gettext("г."),
gettext("По состоянию на"),
bf->tm_mday,bf->tm_mon+1,bf->tm_year+1900,
gettext("г."),
gettext("Время"),
bf->tm_hour,bf->tm_min);

if(tabnom[0] != '\0')
 fprintf(ff,"%s:%s\n",gettext("Табельный номер"),tabnom);

if(podr[0] != '\0')
 fprintf(ff,"%s:%s\n",gettext("Подразделение"),podr);
 
}
/*************************************************************************************/
/*шапка*/
/***********************************************************************************/
void rasdolgi2_hap(int nomstr,int *kolstr,FILE *ff)
{

if(kolstr != NULL)
 *kolstr+=6;
 


fprintf(ff,"\
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(ff,"\
 Т/н |       Прізвище               |Нараховано|Обов'язков|До видачі |   ЄСВ               |  ЄСВ з лікарняних   |   ЄСВ з інвалідів   |  ЄСВ з договорів    |Прибуткови|Військовий|  6+12    |   7+13   |\n\
     |                              |          |і утриман.|          |Нарахуван.|Утримання |Нарахуван.|Утримання |Нарахуван.|Утримання |Нарахуван.|Утримання |й податок |   збір   |          |          |\n");

fprintf(ff,"\
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(ff,"\
  1  |               2              |    3     |    4     |    5     |    6     |    7     |    8     |    9     |    10    |   11     |    12    |   13     |    14    |   15     |   16     |    17    |\n");
/*********
                                         0          1          2          3         4           5          6           7         8          9         10        11
                                                               
12345 123456789012345678901234567890 1234567890 1234567890 1234567890
**********/
fprintf(ff,"\
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
}
/***************************************************************/
/*шапка*/
/******************************************/
void rasdolgi2_hap1(int nomstr,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr+=3;

fprintf(ff,"\
----------------------------------------------------------------------\n");
fprintf(ff,gettext(" Т/н | Фамилия  , Імя , Отчество    |Начислено | Удержано |  Долг    |\n"));
fprintf(ff,"\
----------------------------------------------------------------------\n");
}
