/*$Id: $*/
/*26.01.2026	15.01.2011	Белых А.И.	ras_podoh1.c
Расчёт подоходного налога
Возвращает сумму подоходного налога
*/
#include <math.h>
#include        "buhg.h"

//extern char	*shetb; /*Бюджетные счета*/
extern double   okrg; /*Округление*/
extern short    *kodmp;   /*Коды благотворит. помощи*/
extern short    *kn_bsl; //Коды начислений на которые не распространяется льгота по подоходному налогу
extern short    kodpn;   /*Код подоходного налога*/
extern short	metkarnb; //0-Расчёт налогов для бюджета пропорциональный 1-последовательный
extern short kodpn_sbol; /*Код подоходного с больничного*/
extern short   *kodbl; /*Код больничного*/
extern float  kof_prog_min; //Коэффициент прожиточного минимума

extern class iceb_tu_spisok skndr; /*список кодов начисления для любого количества настроек расчёта*/
extern class iceb_tu_int kudzr;    /*код удержания для каждой строки списка начислений*/

double prosmas(short*,short,short,double*);
double zarsbsl(int tabnom,short mp,short gp,double *suma_bsl_b,double *suma_bsl_start,double *suma_bsl_start_b);
double ras_podor1_rpnsb(int tbn,short mr,short gr,int podr,int metka_zap,double suma_nahisl,double lgota);
double ras_podoh1_stip(short mr,short gr,int tabn,class zar_sumtn *tnsum);
double ras_podoh1_dpn(short mr,short gr,int tabn,class zar_sumtn *tnsum,double suma_pod_nal,int podr);

double ras_podoh1(int tn, //Табельный номер*/
short mp,short gp,
int podr,
int metka_zap, //0-делать запись 1-нет
double suma_boln,
const char *uder_only)
{
char strsql[2048];
SQL_str row;
class iceb_tu_str shet("");
class iceb_tu_str shetbb("");
double nah=0.;
class ZARP     zp;
short		d;
class SQLCURSOR cur;
int metka_p_boln=0;
double bb=0.;
double sumanb=0.;
double sumabu=0.;

double suma_s_soc_lg=0.;
class zar_sumtn tnsum;

if(suma_boln != 0.)
 metka_p_boln=1;
iceb_tu_dpm(&d,&mp,&gp,5);

zp.dz=d;
zp.mesn=mp; zp.godn=gp;
zp.nomz=0;
zp.podr=podr;

sprintf(strsql,"\n%s-Рачёт подоходного налога после 1.1.2011\n\
---------------------------------------------------\n",__FUNCTION__);
zar_pr_ins(strsql);

if(iceb_tu_proverka(uder_only,kodpn,0,0) != 0)
 {
  sprintf(strsql,"Код %d исключён из расчёта\n",kodpn);
  zar_pr_ins(strsql);
  return(0.);    
 }




/*Проверяем есть ли код удержания подоходного налога в списке*/

sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tn,kodpn);
if(sql_readkey(&bd,strsql,&row,&cur) <= 0)
 {
  sprintf(strsql,"%s-Не введено удержание подоходного налога !\n",__FUNCTION__);
  zar_pr_ins(strsql);
  return(0.);
 }
shet.new_plus(row[0]);

sprintf(strsql,"select shet,shetb from Uder where kod=%d",kodpn);
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"%s-Не найден код удержания %d в справочнике удержаний!\n",__FUNCTION__,kodpn);
  zar_pr_ins(strsql);
  return(0.);
 }
shetbb.new_plus(row[1]);
if(shetbb.getdlinna() > 1)
  shet.new_plus(row[0]);

zar_sumtn(mp,gp,tn,0,&tnsum); /*читаем всё что нужно для расчёта*/

/*для студентов со стипендии налог считается по другому*/
sprintf(strsql,"select harac from Kartb where tabn=%d",tn);
if(iceb_t_sql_readkey(strsql,&row,&cur) <= 0)
 {
  sprintf(strsql,"%s-Не найден карточка для табельного номера %d",__FUNCTION__,tn);
  zar_pr_ins(strsql);
 }

sprintf(strsql,"%s-Характер работы-%s\n",__FUNCTION__,row[0]);
zar_pr_ins(strsql);

if(iceb_tu_strstrm(row[0],"студент") == 1)
  nah=ras_podoh1_stip(mp,gp,tn,&tnsum);
else
  nah=podohrs2016(tn,mp,gp,0,metka_p_boln,&tnsum);

double nah_zap=nah;


if(kodpn_sbol != 0 && suma_boln == 0.) /*нужно определить сколько подоходного налога приходится на больничные и записать их отдельно*/
 {
  nah_zap-=ras_podor1_rpnsb(tn,mp,gp,podr,metka_zap,suma_s_soc_lg,tnsum.suma_lgot);
 }


class iceb_tu_str koment("");
//if(shetb == NULL || shetb[0] == '\0')
if(shetbb.getdlinna() <= 1)
 {
  sprintf(strsql,"%s-Нет бюжетных счетов расчёт без дробления на бюжет и хозрасчёт\n",__FUNCTION__);
  zar_pr_ins(strsql);
  strcpy(zp.shet,shet.ravno());
  if(metka_zap == 0)
   {
    double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum,nah_zap,podr);
    nah_zap-=pod_nal;
    zapzarp(d,mp,gp,tn,2,kodpn,nah_zap,shet.ravno(),mp,gp,0,0,"",podr,"",zp);
   }   
   
 }
else
 {

  class zar_sumtn tnsum_b; 

  zar_sumtn(mp,gp,tn,1,&tnsum_b); /*читаем всё что нужно для расчёта только бюджета*/
  
  double bb2=0.;
  if(metkarnb == 1) //Последовательный метод расчёта налогов
   {
    sprintf(strsql,"\n%s-Расчёт подоходного для бюджетных начислений\n",__FUNCTION__);
    zar_pr_ins(strsql);
      
    bb2=podohrs2016(tn,mp,gp,1,metka_p_boln,&tnsum_b);
    sprintf(strsql,"%s-Бюджет последовательный:%.2f Счёт:%s\n",__FUNCTION__,bb2,shetbb.ravno());
    zar_pr_ins(strsql);
   } 

  if(metkarnb == 0) //Пропорциональный метод расчёта налогов
   {

    sprintf(strsql,"%s-Пропорционально:Разбивка суммы:%.2f не бюджет=%.2f бюджет:%.2f\n",__FUNCTION__,bb,sumanb,sumabu);
    zar_pr_ins(strsql);

    sumabu=tnsum_b.suma_nah_all_podoh;


    if(sumabu != 0.)
     {
      
      if(tnsum.suma_nah_all_podoh != 0.)
       {
        bb=tnsum.suma_nah_all_podoh-tnsum_b.suma_nah_all_podoh;
        //Если хозрасчёт не равен нолю то долю определять надо
        if(bb != 0.)
         bb2=nah_zap*sumabu/tnsum.suma_nah_all_podoh;
        else
         bb2=nah_zap;
       }      

     }
   }

  bb2=iceb_tu_okrug(bb2,okrg);

  sprintf(strsql,"%s-Бюджет:%.2f Счёт:%s %f\n",__FUNCTION__,bb2,shetbb.ravno(),bb2);
  zar_pr_ins(strsql);
  if(shetbb.getdlinna() > 1)
   {
    if(metka_zap == 0)
     {

      double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum_b,bb2,podr);
      double pn=bb2-pod_nal;

      koment.new_plus(gettext("Общий фонд"));
      strcpy(zp.shet,shetbb.ravno());

      zapzarp(d,mp,gp,tn,2,kodpn,pn,shetbb.ravno(),mp,gp,0,0,koment.ravno(),podr,"",zp);
     }
   }

  bb2=nah_zap-bb2;
  bb2=iceb_tu_okrug(bb2,okrg);

  sprintf(strsql,"%s-Хозрасчёт:%.2f(%.2f) Счёт:%s\n",__FUNCTION__,bb2,nah_zap,shet.ravno());
  zar_pr_ins(strsql);
  if(shet.getdlinna() > 1)
   {
    class zar_sumtn tnsum_h; 

    zar_sumtn(mp,gp,tn,2,&tnsum_h); /*читаем всё что нужно для расчёта только хозрасчёта*/
 
    double pod_nal=ras_podoh1_dpn(mp,gp,tn,&tnsum_h,bb2,podr);
    bb2-=pod_nal;
 
    koment.new_plus(gettext("Специальный фонд"));
    strcpy(zp.shet,shet.ravno());
    if(metka_zap == 0)
      zapzarp(d,mp,gp,tn,2,kodpn,bb2,shet.ravno(),mp,gp,0,0,koment.ravno(),podr,"",zp);
   }
  
 }


return(nah);
}

/********************************/
/*Узнаём сумму больничных в счёт расчётного месяца и сумму единого социального взноса с больничных*/
/***********************************************/
double ras_podog1_sb(int tabn,
short mr,short gr,double *suma_esv_s_bol)
{
extern int kod_esv_bol; /*Код удержания единого социального взноса с больничного*/
extern int kod_esv_bol_inv; /*Код удержания единого социального взноса с больничных для инвалидов*/
SQL_str row;
class SQLCURSOR cur;
char strsql[512];
int kolstr=0;
*suma_esv_s_bol=0.;
double boln=0.;
sprintf(strsql,"select prn,knah,suma,mesn from Zarp where tabn=%d and datz >= '%04d-%02d-01' and datz <= '%04d-%02d-31' \
and suma <> 0.",tabn,gr,mr,gr,mr);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(0.);
 }

if(kolstr == 0)
 {
  return(0.);
 }
double nah_suma_bol=0.;
while(cur.read_cursor(&row) != 0)
 {
  if(atoi(row[0]) == 1)
   {  
    
    if(provkod(kodbl,atoi(row[1])) >= 0)
     {
      if(mr == atoi(row[3]))
       nah_suma_bol+=atof(row[2]);
      boln+=atof(row[2]);
     }
   }
  else
   {
    int knah=atoi(row[1]);
    if(kod_esv_bol == knah || kod_esv_bol_inv == knah)
     *suma_esv_s_bol+=atof(row[2]);
   }
 }
if(nah_suma_bol > 0.)
 {
  double bb=*suma_esv_s_bol;
  *suma_esv_s_bol=*suma_esv_s_bol*nah_suma_bol/boln;
  sprintf(strsql,"%s-Вычисляем сумму единого социального взноса приходящююся на больничный=%.2f*%.2f/%.2f=%.2f\n",
  __FUNCTION__,bb,nah_suma_bol,boln,*suma_esv_s_bol);
  zar_pr_ins(strsql);
 }

return(nah_suma_bol);

}
/*******************************/
/*Расчёт доли подоходного налога с больничного*/
/*************************************************/
double ras_podor1_rpnsb(int tbn,short mr,short gr,int podr,int metka_zap,double suma_nahisl,double lgota)
{
extern float  ppn; //Процент подоходного налога
float proc_pn=ppn;

char strsql[1024];
double suma_esv_s_bol=0.;
double suma_boln= ras_podog1_sb(tbn,mr,gr,&suma_esv_s_bol);
double suma_pn_s_bol=0.;
if(iceb_tu_sravmydat(1,1,2016,1,mr,gr) <= 0)
 proc_pn=ICEB_PROCENT_PODOH_NAL_2016;
 
if(suma_boln != 0.)
 {  
  double suma_lgot_for_bol=0.;
  if(lgota > 0.)
   {
    if(suma_nahisl > 0.)
      suma_lgot_for_bol=lgota*suma_boln/suma_nahisl;
    else
      suma_lgot_for_bol=lgota;
   }  

  suma_pn_s_bol=(suma_boln-suma_lgot_for_bol+suma_esv_s_bol)*proc_pn/100.;

  if(suma_pn_s_bol < 0.)
   suma_pn_s_bol=0.;
  else
   suma_pn_s_bol*=-1;
   
  sprintf(strsql,"%s-Определяем сколько подоходного налога приходится на больничные\n",__FUNCTION__);
  zar_pr_ins(strsql);

  suma_pn_s_bol=iceb_tu_okrug(suma_pn_s_bol,okrg);  

  sprintf(strsql,"%s-(%.2f-%.2f+%.2f)*%.2f=%.2f\n",__FUNCTION__,suma_boln,suma_lgot_for_bol,suma_esv_s_bol,proc_pn/100.,suma_pn_s_bol);
  zar_pr_ins(strsql);
 }

short d=1;

iceb_tu_dpm(&d,&mr,&gr,5);

class ZARP     zp;
zp.dz=d;
zp.mesn=mr; zp.godn=gr;
zp.nomz=0;
zp.podr=podr;

class iceb_tu_str shet("");
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tbn,kodpn_sbol);
if(sql_readkey(&bd,strsql,&row,&cur) > 0)
  shet.new_plus(row[0]);
else
 {
  sprintf(strsql,"select shet from Uder where kod=%d",kodpn_sbol);
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   shet.new_plus(row[0]);
 }

if(shet.getdlinna() <= 1)
 {
  sprintf(strsql,"%s-Не нашли счёт для кода удержания подоходного налога с больничного %d\n",__FUNCTION__,kodpn_sbol);
  zar_pr_ins(strsql);
 }
else
 if(metka_zap == 0)
  {
   strcpy(zp.shet,shet.ravno());
   zapzarp(d,mr,gr,tbn,2,kodpn_sbol,suma_pn_s_bol,shet.ravno(),mr,gr,0,0,gettext("с больничного"),podr,"",zp);
  }

return(suma_pn_s_bol);

}
/************************************************************/
/*расчёт подоходного со стипендии*/
/*********************************/
double ras_podoh1_stip(short mr,short gr,int tabn,class zar_sumtn *tnsum)
{
char strsql[1024];
class zar_read_tn1h nast_mz;
double suma_podoh=0.;

sprintf(strsql,"%s-Расчёт для стипендии\n",__FUNCTION__);
zar_pr_ins(strsql);
zar_read_tn1(1,mr,gr,&nast_mz);

sprintf(strsql,"%s-Коэффициент прожиточного минимума=%.2f\n",__FUNCTION__,kof_prog_min);
zar_pr_ins(strsql);

sprintf(strsql,"%s-Сумма всех начислений %.2f\n",__FUNCTION__,tnsum->suma_nah_all_podoh);
zar_pr_ins(strsql);

double maxsum_bn=nast_mz.prog_min_ng*kof_prog_min;
maxsum_bn=iceb_tu_okrug(maxsum_bn,10.);

sprintf(strsql,"%s-Максимальная стипендия с которой не берётся налог %.2f*%.2f=%.2f\n",__FUNCTION__,nast_mz.prog_min_ng,kof_prog_min,maxsum_bn);
zar_pr_ins(strsql);

if(maxsum_bn >= tnsum->suma_nah_all_podoh)
 {
  sprintf(strsql,"%s-Налог не берётся так как %.2f > %.2f\n",__FUNCTION__,maxsum_bn,tnsum->suma_nah_all_podoh);
  zar_pr_ins(strsql);
  return(0.);  
 }

double proc_podoh=18.;
suma_podoh=(tnsum->suma_nah_all_podoh-maxsum_bn)*proc_podoh/100.;
suma_podoh=iceb_tu_okrug(suma_podoh,okrg);

sprintf(strsql,"%s-Сумма налога (%.2f-%.2f)*%.2f/100.=%.2f\n",__FUNCTION__,tnsum->suma_nah_all_podoh,maxsum_bn,proc_podoh,suma_podoh);
zar_pr_ins(strsql);

return(suma_podoh*-1);

}
/********************************************/
/*Расчёт долей подоходного налога на заданные коды начисления*/
/*****************************************************************/

double ras_podoh1_dpn(short mr,short gr,int tabn,class zar_sumtn *tnsum,double suma_pod_nal,int podr)
{
class SQLCURSOR cur;
SQL_str row;
double suma_podoh_zap=0.; /*Записанная сумма подоходного налога*/
double suma_podoh_r=0.; /*сумма доли на одно начисление*/
class iceb_tu_str shet("");
char strsql[1024];
class ZARP     zp;
short d=0;

if(tnsum->sndrdpn.kolih() <= 0)
 return(0.);
 
iceb_tu_dpm(&d,&mr,&gr,5);

zp.tabnom=tabn;
zp.prn=2;
zp.knu=0;
zp.dz=d;
zp.mz=mr;
zp.gz=gr;
zp.mesn=mr; 
zp.godn=gr;
zp.nomz=0;
zp.podr=podr;
 
sprintf(strsql,"%s-%s\n",__FUNCTION__,gettext("Расчёт долей подоходного налога на заданные коды начислений"));
zar_pr_ins(strsql);

for(int nom=0; nom < tnsum->sndrdpn.kolih(); nom++)
 {
  if(tnsum->sndrdpn.ravno(nom) == 0.)
   continue;

  gchar *koment;
  koment=g_strdup_printf("%s-Код начисления %s Сумма начисления %.2f\n",__FUNCTION__,skndr.ravno(nom),tnsum->sndrdpn.ravno(nom));
  zar_pr_ins(koment);
  g_free(koment);      

  /*Проверяем есть ли код удержания подоходного налога в списке*/

  sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and knah=%d",tabn,kudzr.ravno(nom));
  if(sql_readkey(&bd,strsql,&row,&cur) <= 0)
   {
    sprintf(strsql,"%s-%s %d\n",__FUNCTION__,gettext("Не введено код удержания"),kudzr.ravno(nom));
    zar_pr_ins(strsql);
    return(0.);
   }
  shet.new_plus(row[0]);

  strcpy(zp.shet,shet.ravno()); 
 /*******
 расчёт доли

 пропорция:
 suma_nah_all_podoh    suma_pod_nal
 sndrdpn                   X
 
    формула расчёта
  suma_podoh_r = sndrdpn  * suma_pod_nal / suma_nah_all_podoh
******/ 

  suma_podoh_r=0.;
  if(tnsum->sndrdpn.ravno(nom) != 0. && suma_pod_nal != 0. && tnsum->suma_nah_all_podoh != 0.)
   {
    suma_podoh_r=tnsum->sndrdpn.ravno(nom)*suma_pod_nal/tnsum->suma_nah_all_podoh;
    suma_podoh_r=iceb_tu_okrug(suma_podoh_r,okrg);

    koment=g_strdup_printf("%s-%f*%f/%f=%f\n",__FUNCTION__,tnsum->sndrdpn.ravno(nom),suma_pod_nal,tnsum->suma_nah_all_podoh,suma_podoh_r);
    zar_pr_ins(koment);
    g_free(koment);      

   }
  else
   {
     if(tnsum->sndrdpn.ravno(nom) == 0.)
      {
       koment=g_strdup_printf("%s-Нулевая сумма на данное начисление!\n",__FUNCTION__);
       zar_pr_ins(koment);
       g_free(koment);      

       koment=g_strdup_printf("%s-Сумма подоходного налога для распределения равна нолю!\n",__FUNCTION__);
       zar_pr_ins(koment);
       g_free(koment);      

       koment=g_strdup_printf("%s-Сумма всех начислений равна нолю!\n",__FUNCTION__);
       zar_pr_ins(koment);
       g_free(koment);      
      }
   
   }
       
  zp.knu=kudzr.ravno(nom);

  koment=g_strdup_printf("%s-Записываем на код удержания %d\n",__FUNCTION__,kudzr.ravno(nom));
  zar_pr_ins(koment);
  g_free(koment);      

  koment=g_strdup_printf("%s-%s",gettext("Доля подоходного на код начисления"),skndr.ravno(nom));

  zapzarp(&zp,suma_podoh_r,d,mr,gr,0,shet.ravno(),koment,0,podr,"",0); 
  g_free(koment);
 
  suma_podoh_zap+=suma_podoh_r;
 
 }
 



return(suma_podoh_zap);
}
