/*$Id: opss.c,v 5.37 2013/09/26 09:43:36 sasa Exp $*/
/*22.06.2022	20.03.2005	Белых А.И.	opss.c
Отчёт по счетам списания материаллов
*/
#include        <errno.h>
#include "buhg.h"

class opss_poi
 {
  public:
   class iceb_tu_str datan;
   class iceb_tu_str datak;
   class iceb_tu_str sklad;
   class iceb_tu_str shet_sp; //Счёт списания/получения
   class iceb_tu_str shet_uh; //Счёт учёта
   class iceb_tu_str kodgrmat;
   class iceb_tu_str kodmat;
   class iceb_tu_str kodop;
   class iceb_tu_str kontr;
   class iceb_tu_str artikul;
   class iceb_tu_str prih_rash;

  opss_poi()
   {
    clean();
   }  
  void clean()
   {
    datan.new_plus("");
    datak.new_plus("");
    sklad.new_plus("");
    shet_sp.new_plus("");
    shet_uh.new_plus("");
    kodgrmat.new_plus("");
    kodmat.new_plus("");
    kodop.new_plus("");
    kontr.new_plus("");
    artikul.new_plus("");
    prih_rash.new_plus("");
   }
 };
 


class opss_svt
 {
  public:
   class iceb_tu_int kod_mat;
   class iceb_tu_spisok sheta_spis;
   class iceb_tu_double sum_svt;
  
 };

class opss_kodm_ei
 {
  public:
   class iceb_tu_spisok kodm_ei;
   class iceb_tu_spisok sheta_spis;
   class iceb_tu_double suma;
   class iceb_tu_double kolih;
   class iceb_tu_double gori_kolih;  
   class iceb_tu_double gori_suma;  
 };
class opss_svt_shet
 {
  public:
   class iceb_tu_spisok kod_gr_shet;
   class iceb_tu_spisok sheta_spis;
   class iceb_tu_double sum_svt;
  
 };
 

void opss_h(int nomlist,int *kol_str,FILE *ff);
void opss_itogo(int metka,const char *kod,double itog,FILE *ff);
void opss_rrp(class opss_poi *poi,FILE *ff);
void opss_rsvt(int metka_oth,short dn,short mn,short gn,short dk,short mk,short gk,class opss_poi *poi,class opss_svt *svt,char *imaf);
void opss_rsvt_shet(short dn,short mn,short gn,short dk,short mk,short gk,class opss_poi *poi,class opss_svt_shet *svt,char *imaf);
void opss_sklad_shet(short dn,short mn,short gn,short dk,short mk,short gk,class opss_poi *poi,class opss_svt_shet *svt,char *imaf);
void opss_ei_kolih(short dn,short mn,short gn,short dk,short mk,short gk,class opss_poi *poi,class opss_kodm_ei *svt,char *imaf);

extern double	okrcn;  /*Округление цены*/
extern double	okrg1;  /*Округление суммы*/
extern int kol_strok_na_liste;

int opss(class spis_oth *oth)
{
static class opss_poi poi;
class iceb_tu_str naim("");
int kodm;
int kgr;
char strsql[512];
int kom=0;
int kom1=0;

VVOD MENU(3);
VVOD VV(0);

VV.VVOD_spisok_add_data(poi.datan.ravno(),11);
VV.VVOD_spisok_add_data(poi.datak.ravno(),11);
VV.VVOD_spisok_add_data(poi.shet_sp.ravno(),112);
VV.VVOD_spisok_add_data(poi.shet_uh.ravno(),112);
VV.VVOD_spisok_add_data(poi.sklad.ravno(),112);
VV.VVOD_spisok_add_data(poi.kodgrmat.ravno(),112);
VV.VVOD_spisok_add_data(poi.kodmat.ravno(),112);
VV.VVOD_spisok_add_data(poi.kodop.ravno(),112);
VV.VVOD_spisok_add_data(poi.kontr.ravno(),112);
VV.VVOD_spisok_add_data(poi.artikul.ravno(),112);
VV.VVOD_spisok_add_data(poi.prih_rash.ravno(),2);

VV.VVOD_spisok_add_ZAG(gettext("Движение товарно-материальных ценностей по счетам списания/получения"));

VV.VVOD_spisok_add_MD(gettext("Дата начала...(д.м.г)..."));//0
VV.VVOD_spisok_add_MD(gettext("Дата конца....(д.м.г)..."));//1
VV.VVOD_spisok_add_MD(gettext("Счёт списания/пол. (,,)."));//2
VV.VVOD_spisok_add_MD(gettext("Счёт учёта..(,,)........"));//3
VV.VVOD_spisok_add_MD(gettext("Склад..(,,)............."));//4
VV.VVOD_spisok_add_MD(gettext("Группа материалов.(,,).."));//5
VV.VVOD_spisok_add_MD(gettext("Код материалла...(,,)..."));//6
VV.VVOD_spisok_add_MD(gettext("Код операции....(,,)...."));//7
VV.VVOD_spisok_add_MD(gettext("Код контрагента.(,,)...."));//8
VV.VVOD_spisok_add_MD(gettext("Артикул.........(,,)...."));//9
VV.VVOD_spisok_add_MD(gettext("Приход/расход...(+,-)..."));//10



naz:;
clear();

helstr(LINES-1,0,"F1",gettext("помощь"),
"F2/+",gettext("расчитать"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

kom=VV.vvod(0,1,0,-1,-1);

poi.datan.new_plus(VV.data_ravno(0));
poi.datak.new_plus(VV.data_ravno(1));
poi.shet_sp.new_plus(VV.VVOD_spisok_return_data(2));
poi.shet_uh.new_plus(VV.VVOD_spisok_return_data(3));
poi.sklad.new_plus(VV.VVOD_spisok_return_data(4));
poi.kodgrmat.new_plus(VV.VVOD_spisok_return_data(5));
poi.kodmat.new_plus(VV.VVOD_spisok_return_data(6));
poi.kodop.new_plus(VV.VVOD_spisok_return_data(7));
poi.kontr.new_plus(VV.VVOD_spisok_return_data(8));
poi.artikul.new_plus(VV.VVOD_spisok_return_data(9));
poi.prih_rash.new_plus(VV.VVOD_spisok_return_data(10));
class iceb_tu_str kods("");
class iceb_tu_str naims("");

switch (kom)
 {

  case FK10:
  case ESC:
   return(1);

  case FK1:
    GDITE();
    iceb_t_pdoc("matu5_19.txt");
    clear();
    goto naz;

  case FK2:
  case PLU:
    break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка складов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка контрагентов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка групп"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка операцій расходов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка материалов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка счетов"));
    MENU.VVOD_spisok_add_MD(gettext("Выход"));

    clearstr(LINES-1,0);
    kom1=0;    
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 6 :
      case -1:
       goto naz;

      case 0 :
        if(dirsklad(1,&kods,&naims) == 0)
         VV.data_z_plus(4,kods.ravno());
        goto naz;

      case 1 :
        vibrek("Kontragent",&poi.kontr,&naim);
        VV.VVOD_spisok_zapis_data(8,poi.kontr.ravno());
        goto naz;

      case 2 :
        vibrek("Grup",&poi.kodgrmat,&naim);
        VV.VVOD_spisok_zapis_data(5,poi.kodgrmat.ravno());
        goto naz;

      case 3 :
        if(dirrashod(1,&poi.kodop,&naim) == 0)
          VV.data_z_plus(7,poi.kodop.ravno());
        goto naz;
        
      case 4 :
        strsql[0]='\0';
        if(dirmatr(&kgr,&kodm,&naims,1,0,strsql,0,0) == 0)
         {
          VV.data_z_plus(6,kodm);
         }
        
        goto naz;

      case 5 :
        vibrek("Plansh",&naims,&naim);
        goto naz;

     }
    goto naz;

  case FK4:
    VV.VVOD_clear_data();
    goto naz;
     
  default:
    goto naz;
 }
short dn,mn,gn;
short dk,mk,gk;

if(iceb_t_rsdat(&dn,&mn,&gn,VV.VVOD_spisok_return_data(0),&dk,&mk,&gk,VV.VVOD_spisok_return_data(1)) != 0)
  goto naz;

if(poi.prih_rash.ravno_pr() == 0)
 sprintf(strsql,"select datd,sklad,nomd,nomkar,kodm,kolih,cena,ei,shet from Dokummat1 \
 where datd >= '%04d-%02d-%02d' and datd <= '%04d-%02d-%02d' and \
 nomkar <> 0 order by shet asc",
 gn,mn,dn,gk,mk,dk);
else
 sprintf(strsql,"select datd,sklad,nomd,nomkar,kodm,kolih,cena,ei,shet from Dokummat1 \
 where datd >= '%04d-%02d-%02d' and datd <= '%04d-%02d-%02d' and \
 nomkar <> 0 and tipz=%d order by shet asc",
 gn,mn,dn,gk,mk,dk,poi.prih_rash.ravno_pr());

int kolstr;
SQL_str row;
SQLCURSOR cur;
SQL_str row1;
SQLCURSOR cur1;

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одной записи !"));
  return(1);
 }

class iceb_t_tmptab tabtmp;
const char *imatmptab={"opssw"};

char zaprostmp[512];
memset(zaprostmp,'\0',sizeof(zaprostmp));

sprintf(zaprostmp,"CREATE TEMPORARY TABLE %s (\
shsp char(24) not null,\
kod_grup int not null,\
shuh char(24) not null,\
datd DATE not null,\
sklad int not null,\
nomd char(24) not null,\
kodm int not null,\
kolih double(16,6) not null,\
cena double(16,6) not null,\
ei char(24) not null,\
kodop char(24) not null,\
kontr char(24) not null,\
naim char(112) not null) ENGINE = MYISAM",imatmptab);

if(tabtmp.create_tab(imatmptab,zaprostmp) != 0)
 {
  return(1);
 }  

class iceb_tu_str kodop("");
class iceb_tu_str kontr("");
class iceb_tu_str shet_uheta("");
class iceb_tu_str shet_sp("");
double kolih;
short dd,md,gd;
class iceb_tu_str kod_grup("");
int kolstr1=0;
class opss_svt svt; //по кодам материалов
class opss_svt svtg; //по группам материалов
class opss_kodm_ei svt_ei; /*по кодам материалов-единиц измерения */

class opss_svt_shet svtg_shets; //по группам материалов и счетам учёта
class opss_svt_shet sklad_shets; //по складам и счетам учёта



while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);  

  if(iceb_tu_proverka(poi.shet_sp.ravno(),row[8],1,0) != 0)
    continue;  
  if(iceb_tu_proverka(poi.sklad.ravno(),row[1],0,0) != 0)
    continue;  

  if(iceb_tu_proverka(poi.kodmat.ravno(),row[4],0,0) != 0)
    continue;  

  //читаем материал
  naim.new_plus("");
  kod_grup.new_plus("");
  sprintf(strsql,"select kodgr,naimat,artikul from Material where kodm=%s",row[4]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
   {
    naim.new_plus(row1[1]);
    if(iceb_tu_proverka(poi.kodgrmat.ravno(),row1[0],0,0) != 0)
      continue;  
    if(iceb_tu_proverka(poi.artikul.ravno(),row1[2],0,0) != 0)
      continue;  
    kod_grup.new_plus(row1[0]);
   }
  kodop.new_plus("");
  kontr.new_plus("");
  
  //читаем шапку документа
  sprintf(strsql,"select kontr,kodop from Dokummat where datd='%s' and sklad=%s and \
nomd='%s'",row[0],row[1],row[2]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
   {
    if(iceb_tu_proverka(poi.kodop.ravno(),row1[1],0,0) != 0)
      continue;  
    if(iceb_tu_proverka(poi.kontr.ravno(),row1[0],0,0) != 0)
      continue;  
    kodop.new_plus(row1[1]);
    kontr.new_plus(row1[0]);
   }

  iceb_tu_rsdat(&dd,&md,&gd,row[0],2);
  kolih=readkolk(atoi(row[1]),atoi(row[3]),dd,md,gd,row[2]);  
  if(kolih == 0.)
   continue;
   
  shet_uheta.new_plus("");

  sprintf(strsql,"select shetu from Kart where sklad=%s and nomk=%s",row[1],row[3]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
   {
     if(iceb_tu_proverka(poi.shet_uh.ravno(),row1[0],1,0) != 0)
      continue;  
    shet_uheta.new_plus(row1[0]);    
   }
  else
   {
    iceb_t_soob(gettext("Не найденa карточка !"));
   }

  shet_sp.new_plus(row[8]);
  if(shet_sp.ravno()[0] == '\0')
   shet_sp.new_plus("???");

  sprintf(strsql,"insert into %s values ('%s',%s,'%s','%s',%s,'%s',%s,%.10g,%s,'%s','%s','%s','%s')",
  imatmptab,
  shet_sp.ravno(),kod_grup.ravno(),shet_uheta.ravno(),
  row[0],row[1],row[2],row[4],kolih,row[6],row[7],
  kodop.ravno(),kontr.ravno(),naim.ravno_filtr());

  iceb_t_sql_zapis(strsql,1,0);    

  if(svt.kod_mat.find(row[4]) < 0)
   svt.kod_mat.plus(row[4]);
  if(svt.sheta_spis.find(shet_sp.ravno()) < 0)
   svt.sheta_spis.plus(shet_sp.ravno());

  if(svtg.kod_mat.find(kod_grup.ravno_atoi()) < 0)
   svtg.kod_mat.plus(kod_grup.ravno_atoi());
  if(svtg.sheta_spis.find(shet_sp.ravno()) < 0)
   svtg.sheta_spis.plus(shet_sp.ravno());
   
  sprintf(strsql,"%s|%s",kod_grup.ravno(),shet_uheta.ravno());
  if(svtg_shets.kod_gr_shet.find(strsql) < 0)
   svtg_shets.kod_gr_shet.plus(strsql);
  if(svtg_shets.sheta_spis.find(shet_sp.ravno()) < 0)
   svtg_shets.sheta_spis.plus(shet_sp.ravno());

  sprintf(strsql,"%s|%s",row[1],shet_uheta.ravno());
  if(sklad_shets.kod_gr_shet.find(strsql) < 0)
   sklad_shets.kod_gr_shet.plus(strsql);
  if(sklad_shets.sheta_spis.find(shet_sp.ravno()) < 0)
   sklad_shets.sheta_spis.plus(shet_sp.ravno());

  sprintf(strsql,"%s|%s",row[4],row[7]);
  if(svt_ei.kodm_ei.find(strsql) < 0)
   svt_ei.kodm_ei.plus(strsql);   
  if(svt_ei.sheta_spis.find(shet_sp.ravno()) < 0)
   svt_ei.sheta_spis.plus(shet_sp.ravno());   
  
 }
sprintf(strsql,"select * from %s order by shsp,kod_grup,shuh,datd asc",imatmptab);
int kolstrtmp=0;
if((kolstrtmp=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }
char imaf[64];
class iceb_fopen fil;
sprintf(imaf,"opss%d.lst",getpid());
if(fil.start(imaf,"w") != 0)
 return(1);


iceb_t_zagolov(gettext("Движение товарно-материальных ценностей по счетам списания/получения"),dn,mn,gn,dk,mk,gk,fil.ff);

//Распечатка реквизитов поиска
opss_rrp(&poi,fil.ff);


//Шапка 

opss_h(1,NULL,fil.ff);


double suma;
double cena;
class iceb_tu_str shet_sp_z("");
class iceb_tu_str shet_uheta_z("");
double itogo_shetu=0.;
double itogo_shets=0.;
double itogo_kod_grup=0.;
class iceb_tu_str sklad("");
class iceb_tu_str nomd("");
class iceb_tu_str kodmat("");
char ei[64];
class iceb_tu_str kod_grup_z("");

svt.sum_svt.make_class(svt.kod_mat.kolih()*svt.sheta_spis.kolih());
svtg.sum_svt.make_class(svtg.kod_mat.kolih()*svtg.sheta_spis.kolih());
svtg_shets.sum_svt.make_class(svtg_shets.kod_gr_shet.kolih()*svtg_shets.sheta_spis.kolih());

sklad_shets.sum_svt.make_class(sklad_shets.kod_gr_shet.kolih()*sklad_shets.sheta_spis.kolih());

svt_ei.kolih.make_class(svt_ei.kodm_ei.kolih()*svt_ei.sheta_spis.kolih());
svt_ei.suma.make_class(svt_ei.kodm_ei.kolih()*svt_ei.sheta_spis.kolih());
svt_ei.gori_kolih.make_class(svt_ei.sheta_spis.kolih());
svt_ei.gori_suma.make_class(svt_ei.sheta_spis.kolih());
int nomer_kod_mat=0;
int nomer_sheta_spis=0;
while(cur.read_cursor(&row) != 0)
 {

  shet_sp.new_plus(row[0]);
  kod_grup.new_plus(row[1]);
  shet_uheta.new_plus(row[2]);
  iceb_tu_rsdat(&dd,&md,&gd,row[3],2);
  sklad.new_plus(row[4]);
  nomd.new_plus(row[5]);
  kodmat.new_plus(row[6]);
  kolih=atof(row[7]);
  cena=atof(row[8]);
  strncpy(ei,row[9],sizeof(ei)-1);
  kodop.new_plus(row[10]);
  kontr.new_plus(row[11]);
  naim.new_plus(row[12]);

  if(iceb_tu_SRAV(kod_grup_z.ravno(),kod_grup.ravno(),0) != 0)
   {
    if(kod_grup_z.ravno()[0] != '\0')
     {

      opss_itogo(3,kod_grup_z.ravno(),itogo_kod_grup,fil.ff);
      itogo_kod_grup=0.;

     }    
    kod_grup_z.new_plus(kod_grup.ravno());
   }

  if(iceb_tu_SRAV(shet_uheta_z.ravno(),shet_uheta.ravno(),0) != 0)
   {
    if(shet_uheta_z.ravno()[0] != '\0')
     {

      opss_itogo(1,shet_uheta_z.ravno(),itogo_shetu,fil.ff);
      itogo_shetu=0.;

      fprintf(fil.ff,"\n");
     }    
    shet_uheta_z.new_plus(shet_uheta.ravno());
   }

  if(iceb_tu_SRAV(shet_sp_z.ravno(),shet_sp.ravno(),0) != 0)
   {
    if(shet_sp_z.ravno()[0] != '\0')
     {

      opss_itogo(1,shet_uheta_z.ravno(),itogo_shetu,fil.ff);
      itogo_shetu=0.;

      
      opss_itogo(3,kod_grup_z.ravno(),itogo_kod_grup,fil.ff);
      itogo_kod_grup=0.;

      opss_itogo(2,shet_sp_z.ravno(),itogo_shets,fil.ff);
      itogo_shets=0.;

      
      
      fprintf(fil.ff,"\n");
     }    
    shet_sp_z.new_plus(shet_sp.ravno());
   }

  
  cena=iceb_tu_okrug(cena,okrcn);
  
  suma=cena*kolih;
  suma=iceb_tu_okrug(suma,okrg1);
  itogo_shetu+=suma;
  itogo_shets+=suma;  
  itogo_kod_grup+=suma;
  

  fprintf(fil.ff,"%-8s %-*.*s %-*s %-*s %10.2f %-*s %8.8g %10.10g %02d.%02d.%d %-*s %-5s %-*s %-*s\n",
  kodmat.ravno(),
  iceb_tu_kolbait(20,naim.ravno()),iceb_tu_kolbait(20,naim.ravno()),naim.ravno(),
  iceb_tu_kolbait(10,shet_sp.ravno()),shet_sp.ravno(),
  iceb_tu_kolbait(10,shet_uheta.ravno()),shet_uheta.ravno(),
  suma,
  iceb_tu_kolbait(6,ei),
  ei,
  kolih,cena,dd,md,gd,
  iceb_tu_kolbait(9,nomd.ravno()),nomd.ravno(),
  sklad.ravno(),
  iceb_tu_kolbait(6,kodop.ravno()),kodop.ravno(),
  iceb_tu_kolbait(7,kontr.ravno()),kontr.ravno());

  nomer_kod_mat=svt.kod_mat.find(kodmat.ravno_atoi());
  nomer_sheta_spis=svt.sheta_spis.find(shet_sp.ravno());
  svt.sum_svt.plus(suma,nomer_kod_mat*svt.sheta_spis.kolih()+nomer_sheta_spis);

  nomer_kod_mat=svtg.kod_mat.find(kod_grup.ravno_atoi());
  nomer_sheta_spis=svtg.sheta_spis.find(shet_sp.ravno());
  svtg.sum_svt.plus(suma,nomer_kod_mat*svtg.sheta_spis.kolih()+nomer_sheta_spis);
  
  sprintf(strsql,"%s|%s",kod_grup.ravno(),shet_uheta.ravno());
  nomer_kod_mat=svtg_shets.kod_gr_shet.find(strsql);
  nomer_sheta_spis=svtg_shets.sheta_spis.find(shet_sp.ravno());
  svtg_shets.sum_svt.plus(suma,nomer_kod_mat*svtg_shets.sheta_spis.kolih()+nomer_sheta_spis);

  sprintf(strsql,"%s|%s",row[4],shet_uheta.ravno());
  nomer_kod_mat=sklad_shets.kod_gr_shet.find(strsql);
  nomer_sheta_spis=sklad_shets.sheta_spis.find(shet_sp.ravno());
  sklad_shets.sum_svt.plus(suma,nomer_kod_mat*sklad_shets.sheta_spis.kolih()+nomer_sheta_spis);

  sprintf(strsql,"%s|%s",kodmat.ravno(),ei);
  nomer_kod_mat=svt_ei.kodm_ei.find(strsql);
  nomer_sheta_spis=svt_ei.sheta_spis.find(shet_sp.ravno());
  svt_ei.suma.plus(suma,nomer_kod_mat*svt_ei.sheta_spis.kolih()+nomer_sheta_spis);
  svt_ei.kolih.plus(kolih,nomer_kod_mat*svt_ei.sheta_spis.kolih()+nomer_sheta_spis);
  svt_ei.gori_kolih.plus(kolih,nomer_sheta_spis);    
  svt_ei.gori_suma.plus(suma,nomer_sheta_spis);    
 }

fprintf(fil.ff,"ICEB_LST_END\n");

GDITE();

opss_itogo(3,kod_grup_z.ravno(),itogo_kod_grup,fil.ff);
opss_itogo(1,shet_uheta_z.ravno(),itogo_shetu,fil.ff);
opss_itogo(2,shet_sp_z.ravno(),itogo_shets,fil.ff);

iceb_t_podpis(fil.ff);

fil.end();

char imaf_svt[64];
opss_rsvt(0,dn,mn,gn,dk,mk,gk,&poi,&svt,imaf_svt);


char imaf_svtg[64];
opss_rsvt(1,dn,mn,gn,dk,mk,gk,&poi,&svtg,imaf_svtg);

char imaf_svtg_shet[64];
opss_rsvt_shet(dn,mn,gn,dk,mk,gk,&poi,&svtg_shets,imaf_svtg_shet);

char imaf_sklad_shet[64];
opss_sklad_shet(dn,mn,gn,dk,mk,gk,&poi,&sklad_shets,imaf_sklad_shet);

char imaf_ei[64];
opss_ei_kolih(dn,mn,gn,dk,mk,gk,&poi,&svt_ei,imaf_ei);

oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Движение товарно-материальных ценностей по счетам списания/получения"));
oth->spis_imaf.plus(imaf_svt);
oth->spis_naim.plus(gettext("Общий итог"));

iceb_t_ustpeh(imaf,3,&kolstr);
iceb_t_rnl(imaf,kolstr,"",&opss_h);

oth->spis_imaf.plus(imaf_svtg);
oth->spis_naim.plus(gettext("Общий итог по группам материалла"));
oth->spis_imaf.plus(imaf_svtg_shet);
oth->spis_naim.plus(gettext("Общий итог по счетам учёта-счетам списания/получения"));
oth->spis_imaf.plus(imaf_ei);
oth->spis_naim.plus(gettext("Общий итог по счетам с количеством"));
oth->spis_imaf.plus(imaf_sklad_shet);
oth->spis_naim.plus(gettext("Общий итог по складам"));

for(int nom=1; nom < oth->spis_imaf.kolih(); nom++)
 iceb_t_ustpeh(oth->spis_imaf.ravno(nom),0);

return(0);
 
}

/********************************/
/*шапка*/
/**********************************/

void opss_h(int nomlist,int *kol_str,FILE *ff)
{
fprintf(ff,"%110s%s N%d\n","",gettext("Лист"),nomlist);
fprintf(ff,"\
------------------------------------------------------------------------------------------------------------------------------------\n");

fprintf(ff,gettext("\
  Код   |    Наименование    |  Счёт    |   Счёт   |   Сумма  |Един. |Количec-|   Цена   |   Дата   |Номер    |Склад|Опера-|Контра-|\n"));
fprintf(ff,gettext("\
материа.|     материалла     |спис/получ|  учёта   |          |измер.|  тво   |          | документа|документа|     |ция   |гент   |\n"));

fprintf(ff,"\
------------------------------------------------------------------------------------------------------------------------------------\n");
if(kol_str != NULL)
 *kol_str+=5;


}

/*****************************/
/*Выдача итога*/
/*****************************/

void opss_itogo(int metka, //1-счёт учёта 2-счёт списания 3-по коду группы
const char *kod,double itog,FILE *ff)
{
if(itog == 0.)
 return;
 
char bros[1024];
if(metka == 1)
  sprintf(bros,"%s %s",gettext("Итого по счёту учёта"),kod);
if(metka == 2)
  sprintf(bros,"%s %s",gettext("Итого по счёту списания/получения"),kod);

if(metka == 3) //По коду группы
 {
  SQL_str row;
  class SQLCURSOR cur;
  char strsql[512];
  class iceb_tu_str naim("");
  sprintf(strsql,"select naik from Grup where kod=%s",kod);
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
    naim.new_plus(row[0]);
  else
    naim.new_plus("");
  sprintf(bros,"%s %s %s",gettext("Итого по группе"),kod,naim.ravno());

 }

fprintf(ff,"%*.*s:%10.2f\n",iceb_tu_kolbait(51,bros),iceb_tu_kolbait(51,bros),bros,itog);

}
/********************************/
/*Распечатка сводной таблицы*/
/******************************/
void opss_rsvt(int metka_oth, //0-по кодам материалов 1-по кодам групп материалов
short dn,short mn,short gn,
short dk,short mk,short gk,
class opss_poi *poi,
class opss_svt *svt,
char *imaf)
{
if(metka_oth == 0)
  sprintf(imaf,"opss_sv%d.lst",getpid());
if(metka_oth == 1)
 sprintf(imaf,"opss_svg%d.lst",getpid());
class iceb_fopen fil;
if(fil.start(imaf,"w") != 0)
 return;

iceb_t_zagolov(gettext("Движение товарно-материальных ценностей по счетам списания/получения"),dn,mn,gn,dk,mk,gk,fil.ff);


//Распечатка реквизитов поиска
opss_rrp(poi,fil.ff);

int kolih_shet=svt->sheta_spis.kolih();
int kolih_kod_mat=svt->kod_mat.kolih();

class iceb_tu_str liniq;
liniq.plus("-------------------------------------");
//          1234567890123456789012345678901234567

for(int ii=0; ii <= kolih_shet; ii++)
  liniq.plus("-----------");
//            12345678901

fprintf(fil.ff,"%s\n",liniq.ravno());

if(metka_oth == 0)
 fprintf(fil.ff,"%-*s|%-*.*s|",
 iceb_tu_kolbait(5,gettext("Код")),gettext("Код"),
 iceb_tu_kolbait(30,gettext("Наименование материалла")),
 iceb_tu_kolbait(30,gettext("Наименование материалла")),
 gettext("Наименование материалла"));

if(metka_oth == 1)
 fprintf(fil.ff,"%-*s|%-*.*s|",
 iceb_tu_kolbait(5,gettext("Код")),gettext("Код"),
 iceb_tu_kolbait(30,gettext("Наименование группы материалла")),
 iceb_tu_kolbait(30,gettext("Наименование группы материалла")),
 gettext("Наименование группы материалла"));

for(int ii=0; ii < kolih_shet; ii++)
 fprintf(fil.ff,"%-*s|",iceb_tu_kolbait(10,svt->sheta_spis.ravno(ii)),svt->sheta_spis.ravno(ii));

fprintf(fil.ff,"%*s|\n",iceb_tu_kolbait(10,gettext("Итого")),gettext("Итого"));

fprintf(fil.ff,"%s\n",liniq.ravno());

class iceb_tu_str naim_kod_mat("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double itogo_gor=0.;

for(int ii=0; ii < kolih_kod_mat; ii++)
 {
  if(metka_oth == 0)  
   sprintf(strsql,"select naimat from Material where kodm=%d",svt->kod_mat.ravno(ii));

  if(metka_oth == 1)  
   sprintf(strsql,"select naik from Grup where kod=%d",svt->kod_mat.ravno(ii));
  
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   naim_kod_mat.new_plus(row[0]);  
  else
   naim_kod_mat.new_plus("");  
  fprintf(fil.ff,"%5d|%-*.*s|",svt->kod_mat.ravno(ii),
  iceb_tu_kolbait(30,naim_kod_mat.ravno()),iceb_tu_kolbait(30,naim_kod_mat.ravno()),naim_kod_mat.ravno());
  itogo_gor=0.;
    
  for(int kk=0; kk < kolih_shet; kk++)
   {
    double suma=svt->sum_svt.ravno(ii*kolih_shet+kk);
    if(suma == 0.)
     fprintf(fil.ff,"%10s|","");
    else
     fprintf(fil.ff,"%10.2f|",suma); 
    itogo_gor+=suma;
   }
  fprintf(fil.ff,"%10.2f|\n",itogo_gor);
 }
fprintf(fil.ff,"%s\n",liniq.ravno());
fprintf(fil.ff,"%*s|",iceb_tu_kolbait(36,gettext("Итого")),gettext("Итого"));
itogo_gor=0;
double itogo_kol=0;
for(int ii=0; ii < kolih_shet; ii++)
 {
  itogo_kol=0.;  
  //считаем колонку по вертикали
  for(int kk=0; kk < kolih_kod_mat; kk++)
    itogo_kol+=svt->sum_svt.ravno(kk*kolih_shet+ii);    
  fprintf(fil.ff,"%10.2f|",itogo_kol);
  itogo_gor+=itogo_kol;
 }
fprintf(fil.ff,"%10.2f|\n",itogo_gor);


iceb_t_podpis(fil.ff);
fil.end();






}
/***********************/
/*Распечатка реквизитов поиска*/
/*****************************/
void opss_rrp(class opss_poi *poi,
FILE *ff)
{

if(poi->sklad.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Склад"),poi->sklad.ravno());
 }
if(poi->shet_sp.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Счёт списания/получения"),poi->shet_sp.ravno());
 }
if(poi->shet_uh.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Счёт учёта"),poi->shet_uh.ravno());
 }
if(poi->kodgrmat.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Группа"),poi->kodgrmat.ravno());
 }
if(poi->kodmat.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Код материалла"),poi->kodmat.ravno());
 }
if(poi->kodop.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Код операции"),poi->kodop.ravno());
 }
if(poi->kontr.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Контрагент"),poi->kontr.ravno());
 }
if(poi->artikul.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Артикул"),poi->artikul.ravno());
 }
if(poi->prih_rash.ravno()[0] != '\0')
 {
  fprintf(ff,"%s:%s\n",gettext("Приход/расход"),poi->prih_rash.ravno());
 }
}

/********************************/
/*Распечатка сводной таблицы по группам и счетам учёта*/
/******************************/
void opss_rsvt_shet(short dn,short mn,short gn,
short dk,short mk,short gk,
class opss_poi *poi,
class opss_svt_shet *svt,
char *imaf)
{
sprintf(imaf,"opss_svg_sh%d.lst",getpid());
class iceb_fopen fil;
if(fil.start(imaf,"w") != 0)
 return;

iceb_t_zagolov(gettext("Движение товарно-материальных ценностей по счетам списания/получения"),dn,mn,gn,dk,mk,gk,fil.ff);

//Распечатка реквизитов поиска
opss_rrp(poi,fil.ff);

int kolih_shet=svt->sheta_spis.kolih();
int kolih_kod_mat=svt->kod_gr_shet.kolih();

class iceb_tu_str liniq;
liniq.plus("----------------------------------------------");
//          1234567890123456789012345678901234567

for(int ii=0; ii <= kolih_shet; ii++)
  liniq.plus("-----------");
//            12345678901

fprintf(fil.ff,"%s\n",liniq.ravno());

fprintf(fil.ff,"%-*s|%-*.*s|%-*.*s|",
iceb_tu_kolbait(5,gettext("Код")),gettext("Код"),
iceb_tu_kolbait(30,gettext("Наименование группы материалла")),
iceb_tu_kolbait(30,gettext("Наименование группы материалла")),
gettext("Наименование группы материалла"),
iceb_tu_kolbait(8,gettext("Счёт")),
iceb_tu_kolbait(8,gettext("Счёт")),
gettext("Счёт"));

for(int ii=0; ii < kolih_shet; ii++)
 fprintf(fil.ff,"%-*s|",iceb_tu_kolbait(10,svt->sheta_spis.ravno(ii)),svt->sheta_spis.ravno(ii));

fprintf(fil.ff,"%*s|\n",iceb_tu_kolbait(10,gettext("Итого")),gettext("Итого"));

fprintf(fil.ff,"%s\n",liniq.ravno());

class iceb_tu_str naim_kod_mat("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double itogo_gor=0.;
char kod_gr[64];
char shet_uheta[64];

for(int ii=0; ii < kolih_kod_mat; ii++)
 {
  iceb_tu_polen(svt->kod_gr_shet.ravno(ii),kod_gr,sizeof(kod_gr),1,'|');
  iceb_tu_polen(svt->kod_gr_shet.ravno(ii),shet_uheta,sizeof(shet_uheta),2,'|');
    

  sprintf(strsql,"select naik from Grup where kod=%s",kod_gr);
  
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   naim_kod_mat.new_plus(row[0]);  
  else
   naim_kod_mat.new_plus("");  
  fprintf(fil.ff,"%5s|%-*.*s|%-*.*s|",
  kod_gr,
  iceb_tu_kolbait(30,naim_kod_mat.ravno()),iceb_tu_kolbait(30,naim_kod_mat.ravno()),naim_kod_mat.ravno(),
  iceb_tu_kolbait(8,shet_uheta),iceb_tu_kolbait(8,shet_uheta),shet_uheta);
  
  itogo_gor=0.;
    
  for(int kk=0; kk < kolih_shet; kk++)
   {
    double ss=svt->sum_svt.ravno(ii*kolih_shet+kk);
    if(ss != 0.)
     {
      fprintf(fil.ff,"%10.2f|",ss);
      itogo_gor+=ss;
     }
    else
      fprintf(fil.ff,"%10s|","");
     
   }
  fprintf(fil.ff,"%10.2f|\n",itogo_gor);
 }
fprintf(fil.ff,"%s\n",liniq.ravno());
fprintf(fil.ff,"%*s",iceb_tu_kolbait(45,gettext("Итого")),gettext("Итого"));
itogo_gor=0;
double itogo_kol=0;
for(int ii=0; ii < kolih_shet; ii++)
 {
  itogo_kol=0.;  
  //считаем колонку по вертикали
  for(int kk=0; kk < kolih_kod_mat; kk++)
    itogo_kol+=svt->sum_svt.ravno(kk*kolih_shet+ii);    
  fprintf(fil.ff,"|%10.2f",itogo_kol);
  itogo_gor+=itogo_kol;
 }
fprintf(fil.ff,"|%10.2f|\n",itogo_gor);


iceb_t_podpis(fil.ff);
fil.end();

}

/********************************/
/*Распечатка сводной таблицы по складам и счетам учёта*/
/******************************/
void opss_sklad_shet(short dn,short mn,short gn,
short dk,short mk,short gk,
class opss_poi *poi,
class opss_svt_shet *svt,
char *imaf)
{
sprintf(imaf,"opss_skl_sh%d.lst",getpid());
class iceb_fopen fil;
if(fil.start(imaf,"w") != 0)
 return;
 

iceb_t_zagolov(gettext("Движение товарно-материальных ценностей по счетам списания/получения"),dn,mn,gn,dk,mk,gk,fil.ff);

//Распечатка реквизитов поиска
opss_rrp(poi,fil.ff);
int kolih_shet=svt->sheta_spis.kolih();
int kolih_kod_mat=svt->kod_gr_shet.kolih();

class iceb_tu_str liniq;
liniq.plus("----------------------------------------------");
//          1234567890123456789012345678901234567

for(int ii=0; ii <= kolih_shet; ii++)
  liniq.plus("-----------");
//            12345678901

fprintf(fil.ff,"%s\n",liniq.ravno());

fprintf(fil.ff,"%-*s|%-*.*s|%-*.*s|",
iceb_tu_kolbait(5,gettext("Код")),gettext("Код"),
iceb_tu_kolbait(30,gettext("Наименование склада")),
iceb_tu_kolbait(30,gettext("Наименование склада")),
gettext("Наименование склада"),
iceb_tu_kolbait(8,gettext("Счёт")),
iceb_tu_kolbait(8,gettext("Счёт")),
gettext("Счёт"));

for(int ii=0; ii < kolih_shet; ii++)
 fprintf(fil.ff,"%-*s|",iceb_tu_kolbait(10,svt->sheta_spis.ravno(ii)),svt->sheta_spis.ravno(ii));

fprintf(fil.ff,"%*s|\n",iceb_tu_kolbait(10,gettext("Итого")),gettext("Итого"));

fprintf(fil.ff,"%s\n",liniq.ravno());

class iceb_tu_str naim_skl("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double itogo_gor=0.;
char kod_skl[64];
char shet_uheta[64];

for(int ii=0; ii < kolih_kod_mat; ii++)
 {
  iceb_tu_polen(svt->kod_gr_shet.ravno(ii),kod_skl,sizeof(kod_skl),1,'|');
  iceb_tu_polen(svt->kod_gr_shet.ravno(ii),shet_uheta,sizeof(shet_uheta),2,'|');
    

  sprintf(strsql,"select naik from Sklad where kod=%s",kod_skl);
  
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   naim_skl.new_plus(row[0]);  
  else
   naim_skl.new_plus("");  
  
  fprintf(fil.ff,"%5s|%-*.*s|%-*.*s|",
  kod_skl,
  iceb_tu_kolbait(30,naim_skl.ravno()),iceb_tu_kolbait(30,naim_skl.ravno()),naim_skl.ravno(),
  iceb_tu_kolbait(8,shet_uheta),iceb_tu_kolbait(8,shet_uheta),shet_uheta);
  
  itogo_gor=0.;
    
  for(int kk=0; kk < kolih_shet; kk++)
   {
    double ss=svt->sum_svt.ravno(ii*kolih_shet+kk);
    if(ss != 0.)
     {
      fprintf(fil.ff,"%10.2f|",ss);
      itogo_gor+=ss;
     }
    else
      fprintf(fil.ff,"%10s|","");
     
   }
  fprintf(fil.ff,"%10.2f|\n",itogo_gor);
 }
fprintf(fil.ff,"%s\n",liniq.ravno());
fprintf(fil.ff,"%*s",iceb_tu_kolbait(45,gettext("Итого")),gettext("Итого"));
itogo_gor=0;
double itogo_kol=0;
for(int ii=0; ii < kolih_shet; ii++)
 {
  itogo_kol=0.;  
  //считаем колонку по вертикали
  for(int kk=0; kk < kolih_kod_mat; kk++)
    itogo_kol+=svt->sum_svt.ravno(kk*kolih_shet+ii);    
  fprintf(fil.ff,"|%10.2f",itogo_kol);
  itogo_gor+=itogo_kol;
 }
fprintf(fil.ff,"|%10.2f|\n",itogo_gor);


iceb_t_podpis(fil.ff);
fil.end();

}
/*********************************/
/*Распечатка сводной таблицы по кодам материалов-единицам измерения с количеством и суммами*/
/**********************************/
void opss_ei_kolih(short dn,short mn,short gn,
short dk,short mk,short gk,
class opss_poi *poi,
class opss_kodm_ei *svt,
char *imaf)
{
sprintf(imaf,"opss_eik%d.lst",getpid());
class iceb_fopen fil;
if(fil.start(imaf,"w") != 0)
 return;

iceb_t_zagolov(gettext("Движение товарно-материальных ценностей по счетам списания/получения"),dn,mn,gn,dk,mk,gk,fil.ff);

//Распечатка реквизитов поиска
opss_rrp(poi,fil.ff);
int kolih_shet=svt->sheta_spis.kolih();
int kolih_km_ei=svt->kodm_ei.kolih();

class iceb_tu_str liniq;
liniq.plus("--------------------------------------------");
//          1234567890123456789012345678901234567

for(int ii=0; ii <= kolih_shet; ii++)
  liniq.plus("----------------------");
//            12345678901

fprintf(fil.ff,"%s\n",liniq.ravno());

fprintf(fil.ff,"%-*s|%-*.*s|%-*.*s|",
iceb_tu_kolbait(5,gettext("Код")),gettext("Код"),
iceb_tu_kolbait(30,gettext("Наименование материалла")),
iceb_tu_kolbait(30,gettext("Наименование материалла")),
gettext("Наименование материалла"),
iceb_tu_kolbait(6,gettext("Единица")),
iceb_tu_kolbait(6,gettext("Единица")),
gettext("Единица"));


for(int ii=0; ii < kolih_shet; ii++)
 fprintf(fil.ff,"%-*s|",iceb_tu_kolbait(21,svt->sheta_spis.ravno(ii)),svt->sheta_spis.ravno(ii));

fprintf(fil.ff,"%-*s|\n",iceb_tu_kolbait(21,gettext("Итого")),gettext("Итого"));



fprintf(fil.ff,"%5s|%30s|%*.*s|","","",
iceb_tu_kolbait(6,gettext("измерения")),
iceb_tu_kolbait(6,gettext("измерения")),
gettext("измерения"));

for(int ii=0; ii < kolih_shet+1; ii++)
 fprintf(fil.ff,"%-*.*s|%-*.*s|",
 iceb_tu_kolbait(10,gettext("Количество")),
 iceb_tu_kolbait(10,gettext("Количество")),
 gettext("Количество"),
 iceb_tu_kolbait(10,gettext("Сумма")),
 iceb_tu_kolbait(10,gettext("Сумма")),
 gettext("Сумма"));

fprintf(fil.ff,"\n");


fprintf(fil.ff,"%s\n",liniq.ravno());
class iceb_tu_str ei("");
int kodmat=0;
class iceb_tu_str naim_kod_mat("");
char strsql[512];
SQL_str row;
class SQLCURSOR cur;
double itogo_gor_kolih=0.;
double itogo_gor_suma=0.;
double kolih=0.;
double suma=0.;
for(int nom_km_ei=0; nom_km_ei < kolih_km_ei; nom_km_ei++)
 {
  iceb_tu_polen(svt->kodm_ei.ravno(nom_km_ei),&kodmat,1,'|');
  iceb_tu_polen(svt->kodm_ei.ravno(nom_km_ei),&ei,2,'|');
    

  sprintf(strsql,"select naimat from Material where kodm=%d",kodmat);
  
  if(iceb_t_sql_readkey(strsql,&row,&cur) == 1)
   naim_kod_mat.new_plus(row[0]);  
  else
   naim_kod_mat.new_plus("");  
  fprintf(fil.ff,"%5d|%-*.*s|%-*.*s|",
  kodmat,
  iceb_tu_kolbait(30,naim_kod_mat.ravno()),iceb_tu_kolbait(30,naim_kod_mat.ravno()),naim_kod_mat.ravno(),
  iceb_tu_kolbait(6,ei.ravno()),iceb_tu_kolbait(6,ei.ravno()),ei.ravno());
  
  itogo_gor_kolih=itogo_gor_suma=0.;
    
  for(int nom_shet=0; nom_shet < kolih_shet; nom_shet++)
   {
    suma=svt->suma.ravno(nom_km_ei*kolih_shet+nom_shet);
    kolih=svt->kolih.ravno(nom_km_ei*kolih_shet+nom_shet);
    if(kolih != 0. || suma != 0.)
     {    
      fprintf(fil.ff,"%10.2f|%10.2f|",kolih,suma);
      itogo_gor_kolih+=kolih;
      itogo_gor_suma+=suma;
     }
    else
     fprintf(fil.ff,"%10s|%10s|","","");
   }
  fprintf(fil.ff,"%10.2f|%10.2f|\n",itogo_gor_kolih,itogo_gor_suma);
 }
fprintf(fil.ff,"%s\n",liniq.ravno());
fprintf(fil.ff,"%*s|",iceb_tu_kolbait(43,gettext("Итого")),gettext("Итого"));

for(int nom_shet=0; nom_shet < kolih_shet; nom_shet++)
 fprintf(fil.ff,"%10.2f|%10.2f|",svt->gori_kolih.ravno(nom_shet),svt->gori_suma.ravno(nom_shet));
 
fprintf(fil.ff,"%10.2f|%10.2f|\n",svt->gori_kolih.suma(),svt->gori_suma.suma());

iceb_t_podpis(fil.ff);
fil.end();

}
