/* $Id: kredit.c,v 5.22 2013/09/26 09:43:35 sasa Exp $ */
/*16.06.2023    01.12.1992      Белых А.И.      kredit.c
Подпрограмма расчёта регулярных удержаний. Это может быть кредит, исполнительный лист или любое регулярное удержание
*/
#include        "buhg.h"

extern struct ZAR zar;
void kreditr(int tn,short mp,short gp,int podr,int metka_r,const char *knnr,const char *kunr,double procent,int ku);

void kredit(int tn,short mp,short gp,int podr,const char *uder_only)
{
int             ku=0;   /*Код начисления*/
short		d,m,g;
SQL_str         row;
char		strsql[1024];
char buffer[2048];
class iceb_tu_str shet("");
class ZARP	zp;
class SQLCURSOR cur;

sprintf(strsql,"\n%s-Расчёт регулярного удержания\n----------------------------------------------\n",__FUNCTION__);
zar_pr_ins(strsql);

sprintf(strsql,"select ku,sp,mu,dd,knnr,kunr from Zarrud where tn=%d",tn);
/*************
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"%s-Ненайдено настройки для удержания!\n",__FUNCTION__);
  zar_pr_ins(strsql);
  return;
 }
****************/
sprintf(buffer,"%s-%s\n",__FUNCTION__,strsql);
zar_pr_ins(buffer);

int kolstr=0;  
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,__FUNCTION__,strsql);
  return;
 }

if(kolstr == 0)
 {
  sprintf(strsql,"%s-Нет настроек на табельный номер %d!\n",__FUNCTION__,tn);
  zar_pr_ins(strsql);
  return;  
 }
 
while(cur.read_cursor(&row) != 0)
 {

  sprintf(strsql,"%s-%s|%s|%s|%s|%s|%s|\n",__FUNCTION__,row[0],row[1],row[2],row[3],row[4],row[5]);
  zar_pr_ins(strsql);

  ku=atoi(row[0]);

  if(iceb_tu_proverka(uder_only,ku,0,0) != 0)
   {
    sprintf(strsql,"%s-Код %d исключён из расчёта\n",__FUNCTION__,ku);
    zar_pr_ins(strsql);
    continue;
   }

  d=0;
  iceb_tu_rsdat(&d,&m,&g,row[3],2);
  if(d != 0 && mp > m && gp >= g)
   {
    sprintf(strsql,"%s-Закончилcя срок действия. Расчёт не производим!\n",__FUNCTION__);
    zar_pr_ins(strsql);
    return;
   }
 
  kreditr(tn,mp,gp,podr,atoi(row[2]),row[4],row[5],atof(row[1]),atoi(row[0]));
 }

}

/*****************************************************/

void kreditr(int tn,short mp,short gp,int podr,int metka_r,const char *knnr,const char *kunr,double procent,int ku)
{
double          nah=0.;
short		d=0;
SQL_str         row;
char		strsql[1024];
class iceb_tu_str shet("");
class ZARP	zp;
class SQLCURSOR cur;
double suma_uder=0;

if(metka_r == 1)
 {
  sprintf(strsql,"%s-Процент от суммы начисленной %f\n",__FUNCTION__,procent);
  zar_pr_ins(strsql);
  //Узнаём всю сумму начиления
  sprintf(strsql,"select prn,knah,suma from Zarp where datz >= '%04d-%02d-01' and datz <= '%04d-%02d-31' and tabn=%d and suma <> 0.",
  gp,mp,gp,mp,tn);
  int kolstr=0;  
  if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
   {
    iceb_t_msql_error(&bd,__FUNCTION__,strsql);
   }
  double suma=0.;

  if(kolstr > 0)
   while(cur.read_cursor(&row) != 0)
    {
     sprintf(strsql,"%s-%s|%s|%s\n",__FUNCTION__,row[0],row[1],row[2]);
     zar_pr_ins(strsql);
     
     if(atoi(row[0]) == 1)
      {
       if(iceb_tu_proverka(row[1],knnr,0,0) == 0)
        continue;
       suma+=atof(row[2]);
      }
     else
      {
       if(iceb_tu_proverka(row[1],kunr,0,0) == 0)
         suma_uder+=atof(row[2]);
      }
    }

  sprintf(strsql,"%s-Сумма начислений :%.2f процент=%f\n",__FUNCTION__,suma,procent);
  zar_pr_ins(strsql);
  
  suma=suma+suma_uder; /*удержание отрицательное*/

  sprintf(strsql,"%s-Сумма начислений взятых в расчёт:%.2f\n",__FUNCTION__,suma);
  zar_pr_ins(strsql);
  
  if(suma > 0.)   
   {
    nah=suma*procent/100.;
    nah=iceb_tu_okrug(nah,0.01);
     
   }
 }
else
 {
  sprintf(strsql,"%s-Стабильная сумма\n",__FUNCTION__);
  zar_pr_ins(strsql);
  nah=procent;
  
 }


if(nah == 0.)
 {
  sprintf(strsql,"%s-Начисленная сумма равна нолю\n",__FUNCTION__);
  zar_pr_ins(strsql);
 }

sprintf(strsql,"%s-Код удержания %d. Сумма удержания %.2f\n",__FUNCTION__,ku,nah);
zar_pr_ins(strsql);
 
SQLCURSOR curr;
/*Проверяем есть ли код удержания в списке*/
sprintf(strsql,"select shet from Zarn1 where tabn=%d and prn='2' and \
knah=%d",tn,ku); 
if(sql_readkey(&bd,strsql,&row,&curr) != 1)
 {
  sprintf(strsql,"%s-Не введён код удержания %d в список удержаний !\n",__FUNCTION__,ku);
  zar_pr_ins(strsql);
  return;
 }
shet.new_plus(row[0]);

nah=nah*(-1);

iceb_tu_dpm(&d,&mp,&gp,5);

zp.dz=d;
zp.mesn=mp; zp.godn=gp;
zp.nomz=0;
zp.podr=podr;
strcpy(zp.shet,shet.ravno());
zapzarp(d,mp,gp,tn,2,ku,nah,shet.ravno(),mp,gp,0,0,"",podr,"",zp); 
}

