/*$Id:*/
/*25.08.2025	22.07.2025	Белых А.И.	buhrdk.cpp
Акт инвентаризации расчётов с дебиторами и кредиторами
Наказ міністерства фінансів України від 17.06.2015 р. N572
*/
#include        "buhg.h"

void buhrdk_sapdeb(FILE *ff);
void buhrdk_sapkre(FILE *ff);
int buhrdk_zvt(const char *kontr,const char *shet,double deb,double kre,const char *imatab,int metka);
void buhrdk_zag(short dk,short mk,short gk,FILE *ff);
void buhrdk_kon(FILE *ff);
void buhrdk_rz(const char *naimshet,int metka,const char *imatmptab,FILE *ff_act,FILE *ff_csv,FILE *ff_prot);


extern short	startgodb; /*Стартовый год*/

int buhrdk(class spis_oth *oth)
{
char strsql[1024];
static class iceb_tu_str datsl("");
static class iceb_tu_str shetd("");
static class iceb_tu_str shetk("");
class iceb_tu_str naimshetk("");
class iceb_tu_str naimshetd("");
short dk=0,mk=0,gk=0;
SQLCURSOR cur;
SQL_str         row;
int		kom1=0;
class VVOD MENU(3);
class VVOD VV(0);



if(datsl.ravno()[0] == '\0')
 {
  short    dt=0,mt=0,gt=0;
  iceb_tu_poltekdat(&dt,&mt,&gt);
  sprintf(strsql,"%02d.%02d.%d",dt,mt,gt);
  datsl.new_plus(strsql);
 } 


VV.VVOD_spisok_add_ZAG(gettext("Расчёт акта инвентаризации расчётов с дебиторами и кредиторами"));

VV.VVOD_spisok_add_MD(gettext("Дата расчёта сальдо..(д.м.г).."));
VV.VVOD_spisok_add_MD(gettext("Счёт дебета..................."));
VV.VVOD_spisok_add_MD(gettext("Счёт кредита.................."));

VV.VVOD_spisok_add_data(datsl.ravno(),11);
VV.VVOD_spisok_add_data(shetd.ravno(),30);
VV.VVOD_spisok_add_data(shetk.ravno(),30);

naz:;
clear();

helstr(LINES-1,0,"F1",gettext("помощь"),
"F2/+",gettext("расчитать"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

nazz:;

int par=VV.vvod(0,1,1,-1,-1);

datsl.new_plus(VV.data_ravno(0));
shetd.new_plus(VV.data_ravno(1));
shetk.new_plus(VV.data_ravno(2));


switch(par)
 {
  case FK1:   /*Помощь*/
   GDITE();
//   iceb_t_pdoc("buhg5_3.txt");
   clear();
   goto naz;
   
  case PLU:
  case FK2:
   break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_ZAG(gettext("Выберите  нужное и нажмите Enter"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка для выбора дебетового счёта"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка для выбора кредитового счёта"));
    MENU.VVOD_spisok_add_MD(gettext("Выход"));

    clearstr(LINES-1,0);
    kom1=0;    
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 3 :
      case -1:
       goto naz;
      case 0 :
     //   vibrek("Plansh",&shetd);
        if(dirshet(&shetd,&naimshetd,1) == 0)
         VV.VVOD_spisok_zapis_data(1,shetd.ravno());
        goto naz;
      case 1 :
//        vibrek("Plansh",&shetk);
        if(dirshet(&shetk,&naimshetk,1) == 0)
          VV.VVOD_spisok_zapis_data(2,shetk.ravno());
        goto naz;
      }
     goto naz;
     
  case ESC:
  case FK10:
   return(1);

  case FK4:
    VV.VVOD_clear_data();
    goto naz;
   
  default:
   goto nazz;
 }

if(iceb_tu_rsdat(&dk,&mk,&gk,datsl.ravno(),1) != 0)
  goto naz;

if(shetd.getdlinna() <= 1 && shetk.getdlinna() <= 1)
 {
  iceb_t_soob(gettext("Не введено ни одного счёта!"));
  goto naz;
 }

if(shetd.getdlinna() > 1)
 {
  /*проверяем чтобы у счетов было развёрнутое сальдо*/
  sprintf(strsql,"select nais,saldo from Plansh where ns='%s'",shetd.ravno());
  if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
   {
    sprintf(strsql,"%s %s %s!",gettext("Не найден счёт"),shetd.ravno(),gettext("в плане счётов"));
    iceb_t_soob(strsql);
    goto naz;
   }


  if(atoi(row[1]) != 3)
   {
    sprintf(strsql,"%s %s %s!",gettext("Счёт"),shetd.ravno(),gettext("имеет свёрнутое сальдо"));
    iceb_t_soob(strsql);
    goto naz;
     
   }
  naimshetd.new_plus(shetd.ravno());
  naimshetd.plus(" ",row[0]);
 }
if(shetk.getdlinna() > 1) /*Кредитового счёта может и не быть*/
 {
 
  sprintf(strsql,"select nais,saldo from Plansh where ns='%s'",shetk.ravno());
  if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
   {
    sprintf(strsql,"%s %s %s!",gettext("Не найден счёт"),shetk.ravno(),gettext("в плане счётов"));
    iceb_t_soob(strsql);
    goto naz;
   }

  if(atoi(row[1]) != 3)
   {
    sprintf(strsql,"%s %s %s!",gettext("Счёт"),shetk.ravno(),gettext("имеет свёрнутое сальдо"));
    iceb_t_soob(strsql);
    goto naz;
     
   }
  naimshetk.new_plus(shetk.ravno());
  naimshetk.plus(" ",row[0]);
  
 } 




GDITE();

time_t          tmm;
time(&tmm);

short godn=startgodb;
if(startgodb == 0 || startgodb > gk)
 godn=gk;


class iceb_t_tmptab tabtmp;
const char *imatmptab={"saldoall"};
char zaprostmp[512];
memset(zaprostmp,'\0',sizeof(zaprostmp));

sprintf(zaprostmp,"CREATE TEMPORARY TABLE %s (\
kod_kontr char(32) not null DEFAULT '',\
sh char(32) NOT NULL DEFAULT '',\
deb DOUBLE(15,2) NOT NULL DEFAULT 0.,\
kre DOUBLE(15,2) NOT NULL DEFAULT 0.,\
mt SMALLINT NOT NULL DEFAULT 0, \
unique(kod_kontr,sh)) ENGINE = MYISAM",imatmptab);


if(tabtmp.create_tab(imatmptab,zaprostmp) != 0)
 {
  return(1);
 }  


/*смотрим стартовое сальдо*/
int kolstr=0;
sprintf(strsql,"select ns,kodkon,deb,kre from Saldo where kkk='%d' and gs=%d",1,godn);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);

if(kolstr > 0)
while(cur.read_cursor(&row) != 0)
 {

  if(iceb_tu_proverka(shetd.ravno(),row[0],3,1) == 0)
   buhrdk_zvt(row[1],row[0],atof(row[2]),atof(row[3]),imatmptab,0);

  if(iceb_tu_proverka(shetk.ravno(),row[0],3,1) == 0)
   buhrdk_zvt(row[1],row[0],atof(row[2]),atof(row[3]),imatmptab,1);

 }

//printw("%s\n",gettext("Просматриваем проводки"));
GDITE();
sprintf(strsql,"select datp,sh,shk,kodkon,deb,kre from Prov \
where val=0 and datp >= '%04d-%02d-%02d' and datp <= '%04d-%02d-%02d' \
and (sh like '%s%%' or sh like '%s%%') \
order by datp,sh asc",godn,1,1,gk,mk,dk,shetd.ravno(),shetk.ravno());
/*****************
sprintf(strsql,"select datp,sh,shk,kodkon,deb,kre from Prov \
where val=0 and datp >= '%04d-%02d-%02d' and datp <= '%04d-%02d-%02d' \
order by datp,sh asc",godn,1,1,gk,mk,dk);
********************/
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);

if(kolstr == 0)
 {
  sprintf(strsql,"%s c 1.1.%d %s %d.%d.%d",
  gettext("Не найдено проводок за период с"),
  godn,
  gettext("по"),
  dk,mk,gk);

  iceb_t_soob(strsql);  

  return(1);
 } 

int kolstr1=0;

while(cur.read_cursor(&row) != 0)
 {
  kolstr1++;
  strzag(LINES-1,0,kolstr,kolstr1);

  if(iceb_tu_proverka(shetd.ravno(),row[1],3,1) == 0)
   {
    buhrdk_zvt(row[3],row[1],atof(row[4]),atof(row[5]),imatmptab,0);
   }

  if(iceb_tu_proverka(shetk.ravno(),row[1],3,1) == 0)
   {
    buhrdk_zvt(row[3],row[1],atof(row[4]),atof(row[5]),imatmptab,1);
   }


 }

char imaf_prot[64];
sprintf(imaf_prot,"rdkp%d.lst",getpid());
class iceb_fopen fil_prot;
if(fil_prot.start(imaf_prot,"w") != 0)
 return(1);

char imaf_csv[64];
sprintf(imaf_csv,"rdk%d.csv",getpid());
class iceb_fopen fil_csv;
if(fil_csv.start(imaf_csv,"w") != 0)
 return(1);

buhrdk_zag(dk,mk,gk,fil_csv.ff);

fprintf(fil_csv.ff,"\
                                1. За дебіторською заборгованістю\n");



 
iceb_t_zagolov(gettext("Протокол хода расчёта акта инвентаризации расчётов с дебиторами и кредиторами"),0,0,0,dk,mk,gk,fil_prot.ff);  
 
char imaf_act[64];
sprintf(imaf_act,"rdka%d.lst",getpid());
class iceb_fopen fil_act;
if(fil_act.start(imaf_act,"w") != 0)
 return(1);

buhrdk_zag(dk,mk,gk,fil_act.ff);

if(shetd.getdlinna() > 1)
 {

  fprintf(fil_act.ff,"\
                                1. За дебіторською заборгованістю\n");
  fprintf(fil_csv.ff,"\
                                1. За дебіторською заборгованістю\n");
  fprintf(fil_csv.ff,"\
Найменування|ЄДРПОУ (Реєстраційний номер облікової картки платника податків або серія та номер паспорта)|\
Найменування субрахунку|Всього|Заборгованість, що підтверджена дебіторами|Заборгованість, що не підтверджена дебіторами|\
Із загальної суми, вказаної в графі 4, зазначається заборгованіть, за якою минув срок позовної давності (додаток: \
довідка до акта інвентарізації розрахунків про дебіторську і кредиторську заборгованості, щодо яких срок позовної \
давності минув|\n");

  buhrdk_sapdeb(fil_act.ff);
  fprintf(fil_prot.ff,"Смотрим дебеты\n");

  buhrdk_rz(naimshetd.ravno(),0,imatmptab,fil_act.ff,fil_csv.ff,fil_prot.ff);
 }                      

if(shetk.getdlinna() > 1)
 {
  
  fprintf(fil_prot.ff,"\n\nСмотрим кредиты\n");
  if(shetk.getdlinna() > 1)
    fprintf(fil_act.ff,"\f");
  
  fprintf(fil_act.ff,"\
                                 2. За кредиторською заборгованістю\n");
  fprintf(fil_csv.ff,"\
                                 2. За кредиторською заборгованістю\n");
  fprintf(fil_csv.ff,"\
Найменування|ЄДРПОУ (Реєстраційний номер облікової картки платника податків або серія та номер паспорта)|\
Найменування субрахунку|Всього|Заборгованість, що підтверджена кредіторами|Заборгованість, що не підтверджена кредіторами|\
Із загальної суми, вказаної в графі 4, зазначається заборгованіть, за якою минув срок позовної давності (додаток: \
довідка до акта інвентарізації розрахунків про дебіторську і кредиторську заборгованості, щодо яких срок позовної \
давності минув|\n");

  buhrdk_sapkre(fil_act.ff);
                        
  buhrdk_rz(naimshetk.ravno(),1,imatmptab,fil_act.ff,fil_csv.ff,fil_prot.ff);
 
 }

buhrdk_kon(fil_act.ff);
buhrdk_kon(fil_csv.ff);


 
fil_prot.end();
fil_act.end();
fil_csv.end();

move(LINES-2,0);
printw_vr(tmm);
OSTANOV();

oth->spis_imaf.plus(imaf_act);
oth->spis_naim.plus(gettext("Акт инвентаризации расчётов с дебеторами и кредиторами"));
oth->spis_imaf.plus(imaf_prot);
oth->spis_naim.plus(gettext("Протокол хода расчёта"));

for(int nom=0; nom < oth->spis_imaf.kolih(); nom++)
 iceb_t_ustpeh(oth->spis_imaf.ravno(nom),3);

oth->spis_imaf.plus(imaf_csv);
oth->spis_naim.plus(gettext("Файл для загрузки отчёта в электронные таблицы"));


return(0);
}

/******************************************************************/
/*Запись в промежуточную таблицу*/
/*******************************************************************/
int buhrdk_zvt(const char *kontr,const char *shet,double deb,double kre,
const char *imatab,
int metka) /*0-дебетовый счёт 1-кредитовый*/
{
char strsql[512];

sprintf(strsql,"select deb from %s where kod_kontr='%s' and sh='%s'",imatab,kontr,shet);
if(iceb_t_sql_readkey(strsql) == 1)
 {
  sprintf(strsql,"update %s set deb=deb+%.2f,kre=kre+%.2f where kod_kontr='%s' and sh='%s'",
  imatab,deb,kre,kontr,shet); 
 }
else
 {  
  sprintf(strsql,"insert into %s values('%s','%s',%.2f,%.2f,%d)",imatab,kontr,shet,deb,kre,metka);
 }
if(iceb_t_sql_zapis(strsql,1,0) != 0)
 return(1);
return(0);
}

/*********************************************************/
/*Шапка дебетовой таблицы*/
/*********************************************************/
void buhrdk_sapdeb(FILE *ff)
{


fprintf(ff,"\
--------------------------------------------------------------------------------------------------------------------------------------\n\
                                                   |                    |              |Сума дебіторської заборго|                   |\n\
                                                   |                    |              |ваності за даними бухгалт|Із загальної суми  |\n\
               Дебітор                             |                    |              |  ерського обіку         |вказаної в графі 4 |\n\
                                                   |                    |              |(витрати майбутніх       |зазначається забор |\n\
                                                   |                    |              |      періодів)          |гованість, за якою |\n\
                                                   |                    |              |-------------------------|минув срок позовної|\n\
                                                   |                    |              |     у тому числі        |давності (додаток: |\n\
---------------------------------------------------|                    |              |--------------|----------|довідка до акта    |\n\
          Найменування                  |  ЄДРПОУ  |     Найменування   |   Всього     |Заборгованість|Заборгован|інвентаризації роз |\n\
                                        |(реєстраці|      субрахунку    |              |, що підтверд-|ість що не|рахунків про дебіт-|\n\
                                        |йний номер|                    |              |   жена       |підтвердже|орську і кредиторс-|\n\
                                        |облікової |                    |              | дебіторами   |на дебіто-|ьку заборгованості |\n\
                                        |  картки  |                    |              |              | рами     |щодо яких срок поз |\n\
                                        | платника |                    |              |              |          |овної давності     |\n\
                                        | податків |                    |              |              |          |    минув)         |\n\
                                        |або серія |                    |              |              |          |                   |\n\
                                        | та номер |                    |              |              |          |                   |\n\
                                        |паспорта) |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                  ,|\n\
                                        |          |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                   |\n\
-------------------------------------------------------------------------------------------------------------------------------------|\n\
                   1                    |    2     |          3         |       4      |      5       |     6    |         7         |\n\
-------------------------------------------------------------------------------------------------------------------------------------|\n");



/******
1234567890123456789012345678901234567890|1234567890|12345678901234567890|12345678901234|12345678901234|1234567890|1234567890123456789|
************/

}
/*********************************************************/
/*Шапка кредитовой таблицы*/
/*********************************************************/
void buhrdk_sapkre(FILE *ff)
{


fprintf(ff,"\
--------------------------------------------------------------------------------------------------------------------------------------\n\
                                                   |                    |              |Сума кредітоської заборго|                   |\n\
                                                   |                    |              |ваності за даними бухгалт|Із загальної суми  |\n\
               Кредітор                            |                    |              |  ерського обіку         |вказаної в графі 4 |\n\
                                                   |                    |              |(витрати майбутніх       |зазначається забор |\n\
                                                   |                    |              |      періодів)          |гованість, за якою |\n\
                                                   |                    |              |-------------------------|минув срок позовної|\n\
                                                   |                    |              |     у тому числі        |давності (додаток: |\n\
---------------------------------------------------|                    |              |--------------|----------|довідка до акта    |\n\
          Найменування                  |  ЄДРПОУ  |     Найменування   |   Всього     |Заборгованість|Заборгован|інвентаризації роз |\n\
                                        |(реєстраці|      субрахунку    |              |, що підтверд-|ість що не|рахунків про дебіт-|\n\
                                        |йний номер|                    |              |   жена       |підтвердже|орську і кредиторс-|\n\
                                        |облікової |                    |              | кредиторами  |на кредито|ьку заборгованості |\n\
                                        |  картки  |                    |              |              | рами     |щодо яких срок поз |\n\
                                        | платника |                    |              |              |          |овної давності     |\n\
                                        | податків |                    |              |              |          |    минув)         |\n\
                                        |або серія |                    |              |              |          |                   |\n\
                                        | та номер |                    |              |              |          |                   |\n\
                                        |паспорта) |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                  ,|\n\
                                        |          |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                   |\n\
                                        |          |                    |              |              |          |                   |\n\
-------------------------------------------------------------------------------------------------------------------------------------|\n\
                   1                    |    2     |          3         |       4      |      5       |     6    |         7         |\n\
-------------------------------------------------------------------------------------------------------------------------------------|\n");



/******
1234567890123456789012345678901234567890|1234567890|12345678901234567890|12345678901234|12345678901234|1234567890|1234567890123456789|
************/

}
/******************************************************************/
/*Заголовок документа*/
/******************************************************************/
void buhrdk_zag(short dk,short mk,short gk,FILE *ff)
{
fprintf(ff,"\
                                                                             ЗАТВЕРДЖЕНО\n\
                                                                             Наказ Міністерства фінансів України\n\
                                                                             17 червня 2015 року N 572\n\
%s\n\
Ідентифікаційний код за ЄДРПОУ %s\n\n\
                                              АКТ\n\
                     інвентарізації розрахунків з дебіторами і кредиторами\n\n\
                               \"___\" ____________________20  р.\n",
iceb_t_get_pnk("00",1),
iceb_t_get_edrpou("00"));                   
                                                      

fprintf(ff,"\
На підставі розпорядчого документа від \"____\"_____________20__ р. N     проведено інвентарізацію\n\
розрахунків за дебіторською і кредиторською заборгованностями (доходатми і витратами майбутніх\n\
періодів) станом на %02d.%02d.%d р.\n",dk,mk,gk);

fprintf(ff,"\
                            Інвентаризація: розпочата \"____\"__________________20____ р.\n\
                                            закінчена \"____\"__________________20____ р.\n");
                                            
fprintf(ff,"При інвентарізації встановлено таке:\n");


}
/****************************************************************/
/*Концовка*/
/***************************************************************/
void buhrdk_kon(FILE *ff)
{

fprintf(ff,"\n\n\
              Голова комісії:  _____________________________________________________  ________________ ______________________\n\
                                                    (Посада)                              (Підпис)            (Призвище)\n\n\
               Члени комісії:  _____________________________________________________  ________________ ______________________\n\
                                                    (Посада)                              (Підпис)            (Призвище)\n\n\
                               _____________________________________________________  ________________ ______________________\n\
                                                    (Посада)                              (Підпис)            (Призвище)\n\n\
                               _____________________________________________________  ________________ ______________________\n\
                                                    (Посада)                              (Підпис)            (Призвище)\n\n\
                               _____________________________________________________  ________________ ______________________\n\
                                                    (Посада)                              (Підпис)            (Призвище)\n");
}
/*********************************************************/
/*розрахунок*/
/************************************************************/
void buhrdk_rz(const char *naimshet,int metka,const char *imatmptab,FILE *ff_act,FILE *ff_csv,FILE *ff_prot)
{
char strsql[1024];
int kolstr=0;
SQLCURSOR cur;
SQL_str         row;

sprintf(strsql,"select * from %s where mt=%d",imatmptab,metka);
//sprintf(strsql,"select * from %s",imatmptab);
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);

class iceb_tu_str naim_kontr("");
class iceb_tu_str edrpou("");
double itogo=0.;
double deb=0.,kre=0.;
int kolstr1=0;
double saldo=0.;

while(cur.read_cursor(&row) != 0)
 {
  kolstr1++;
  strzag(LINES-1,0,kolstr,kolstr1);
  deb=atof(row[2]);
  kre=atof(row[3]);

  fprintf(ff_prot,"%-10s %-10s %15s %15s %s ",row[0],row[1],row[2],row[3],row[4]);

  if(metka == 0)
   { 
    if(kre >= deb)
     {
      fprintf(ff_prot,"Кредит больше или равен дебету\n");
      continue;
     }
    else
     {
      saldo=deb-kre;
      fprintf(ff_prot,"%10.2f Сальдо дебетовое\n",saldo);

     }
   }
  else
   {
    if(deb >= kre)
     {
      fprintf(ff_prot,"Дебет больше или равен кредиту\n");
      continue;
     }
    else
     {
      saldo=kre-deb;

      fprintf(ff_prot,"%10.2f Сальдо кредитовое\n",saldo);
     }  
   }

  itogo+=saldo;
  
  naim_kontr.new_plus(iceb_t_get_pnk(row[0],1));
  edrpou.new_plus(iceb_t_get_edrpou(row[0]));  
/******
1234567890123456789012345678901234567890|1234567890|12345678901234567890|12345678901234|12345678901234|1234567890|1234567890123456789|
************/
  fprintf(ff_act,"%-*.*s|%-10s|%-*.*s|%14.2f|%14.2f|%10s|%19s|\n",
  iceb_tu_kolbait(40,naim_kontr.ravno()),
  iceb_tu_kolbait(40,naim_kontr.ravno()),
  naim_kontr.ravno(),
  edrpou.ravno(),
  iceb_tu_kolbait(20,naimshet),
  iceb_tu_kolbait(20,naimshet),
  naimshet,
  saldo,
  saldo,
  "","");
  int nm=20;  
  for(int nom=40; nom < iceb_tu_strlen(naim_kontr.ravno()); nom+=40)
   {
    fprintf(ff_act,"%-*.*s|%10s|%-*.*s|%14s|%14s|%10s|%19s|\n", 
    iceb_tu_kolbait(40,iceb_tu_adrsimv(nom,naim_kontr.ravno())),
    iceb_tu_kolbait(40,iceb_tu_adrsimv(nom,naim_kontr.ravno())),
    iceb_tu_adrsimv(nom,naim_kontr.ravno()),
    "",
    iceb_tu_kolbait(20,iceb_tu_adrsimv(nm,naimshet)),
    iceb_tu_kolbait(20,iceb_tu_adrsimv(nm,naimshet)),
    iceb_tu_adrsimv(nm,naimshet),
    "","","","");
    nm+=20;  
   }

  fprintf(ff_csv,"%s|%s|%s|%.2f|%.2f|%s|%s|\n",
  naim_kontr.ravno(),
  edrpou.ravno(),
  naimshet,
  saldo,
  saldo,
  "","");


 }

fprintf(ff_act,"\
--------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(ff_act,"%*.*s|%14.2f|%14.2f|\n",
iceb_tu_kolbait(72,gettext("Итого")),
iceb_tu_kolbait(72,gettext("Итого")),
gettext("Итого"),
itogo,
itogo);

}
