/*$Id:$*/
/*14.07.2024	07.11.2006	Белых А.И.	balans_f2.c
Расчёт баланса по форме 2 (Звіт про фінансові результати форма 2)
*/
#include <errno.h>
#include "buhg.h"

void balans_f2_r(int metka_ras,int metkabd,const char *sheta,GLKTMP *PROM,int nomer_kod,double *suma_kod1,iceb_tu_spisok *kod,const char *kod_subbal);
void balans_f2_r1(int metkabd,const char *sheta,GLKTMP *PROM,double *k1,int nomer_kod,const char *kod_subbal);
void balans_f2_r2(const char *kodi,double *k1,double *suma_kod1,iceb_tu_spisok *kod);

extern char     *sbshet; //Список бюджетных счетов

void  balans_f2(int metkabd, //0-хозрасчёт 1-бюджет
short dn,short mn,short gn,
short dk,short mk,short gk,
char *imaf,GLKTMP *PROM,const char *kod_subbal)
{
char strsql[1024];
SQL_str row;
SQLCURSOR cur;
class iceb_tu_str naim_org("");
class iceb_tu_str adres("");
SQL_str row_alx;
class SQLCURSOR cur_alx;
int kolstr=0;

//читаем реквизиты организации
sprintf(strsql,"select naikon,adres,pnaim from Kontragent where kodkon='00'");

if(sql_readkey(&bd,strsql,&row,&cur) == 1)
 {
  if(row[2][0] != '\0')
   naim_org.new_plus(row[2]);
  else
   naim_org.new_plus(row[0]);

  adres.new_plus(row[1]);
  
   
 }


class iceb_tu_str bros("");

sprintf(strsql,"select str from Alx where fil='glk_balans_n2.alx' order by ns asc");
if((kolstr=cur_alx.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return;
 }

if(kolstr == 0)
 {
  sprintf(strsql,"%s glk_balans_n2.alx",gettext("Не найдены настройки"));
  iceb_t_soob(strsql);
  return;
 }

class iceb_tu_spisok kod;
class iceb_tu_spisok sheta;

class iceb_tu_str stroka("");
int kk=0;
while(cur_alx.read_cursor(&row_alx) != 0)
 {
  if(row_alx[0][0] == '#')
   continue;
  if(iceb_tu_polen(row_alx[0],&bros,1,'|') != 0)
   continue;
  if(bros.ravno()[0] == '\0')
   continue;
  kod.plus(bros.ravno());
  iceb_tu_polen(row_alx[0],&bros,2,'|');

  iceb_t_fplus(1,bros.ravno(),&sheta,&cur_alx);
  kk++;
  
 }

double suma_kod1[kod.kolih()]; //Суммы по кодам
memset(&suma_kod1,'\0',sizeof(suma_kod1));

for(int ii=0; ii < kod.kolih(); ii++) //Сначала считаем настройки со счетами
  balans_f2_r(0,metkabd,sheta.ravno(ii),PROM,ii,suma_kod1,&kod,kod_subbal);


for(int ii=0; ii < kod.kolih(); ii++) //Потом считаем настройки с номерами строк
  balans_f2_r(1,metkabd,sheta.ravno(ii),PROM,ii,suma_kod1,&kod,kod_subbal);


sprintf(strsql,"select str from Alx where fil='glk_balans2.alx' order by ns asc");
if((kolstr=cur_alx.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return;
 }

if(kolstr == 0)
 {
  iceb_t_soob("Не найдены настройки glk_balans2.alx");
  return;
 }


sprintf(imaf,"b_f2_%d.lst",getpid());
FILE *ff_bal;
if((ff_bal = fopen(imaf,"w")) == NULL)
 {
  error_op_nfil(imaf,errno,"");
  return;
 }
fprintf(ff_bal,"\x1B\x33%c\n",30); /*Уменьшаем межстрочный интервал*/

int nomer_koda=0;


while(cur_alx.read_cursor(&row_alx) != 0)
 {
  if(row_alx[0][0] == '#')
   continue;

  stroka.new_plus(row_alx[0]);
  
  if(iceb_tu_SRAV("Підприємство",stroka.ravno(),1) == 0)
   {
    iceb_tu_vstav(&stroka,naim_org.ravno(),14,66,1);
   }
  if(iceb_tu_SRAV("Адреса",stroka.ravno(),1) == 0)
   {
    iceb_tu_vstav(&stroka,adres.ravno(),8,66,1);
   }
  if(iceb_tu_strstrm(stroka.ravno(),"на_______") == 1)
   {
    sprintf(strsql,"%02d.%02d.%d р.",dk,mk,gk);
    iceb_tu_vstav(&stroka,strsql,29,68,1);
   }

  if(iceb_tu_strstrm(stroka.ravno(),"за _______") == 1)
   {
    sprintf(strsql,"%s %02d.%02d.%d %s %02d.%02d.%d",
    gettext("период с"),
    dn,mn,gn,
    gettext("по"),
    dk,mk,gk);
    iceb_tu_vstav(&stroka,strsql,33,70,1);
   }
  
  

  if(iceb_tu_polen(stroka.ravno(),&bros,3,'|') == 0)
  if(iceb_tu_polen(stroka.ravno(),strsql,sizeof(strsql),4,'|') == 0)
   if(bros.ravno()[0] != '\0' && strsql[0] == '\0')
    {
     bros.ud_lp(); //удаляем лидирующие пробелы
     if((nomer_koda=kod.find(bros.ravno())) < 0)
      {
       sprintf(strsql,gettext("Не найден код строки %s в настройках !"),bros.ravno());
       iceb_tu_vstav(&stroka,strsql,73,184,1);
//       iceb_t_soob(strsql);
      }
     else
      {
       sprintf(strsql,"%12.2f",suma_kod1[nomer_koda]);
       iceb_tu_vstav(&stroka,strsql,73,84,1);
      }
    }  
  fprintf(ff_bal,"%s",stroka.ravno());
 }
iceb_t_podpis(ff_bal);

fclose(ff_bal);
}

/**********************************/
/*Расчёт*/
/**********************************/

void balans_f2_r(int metka_ras,int metkabd,const char *sheta,GLKTMP *PROM,
int nomer_kod,double *suma_kod1,iceb_tu_spisok *kod,const char *kod_subbal)
{
double k1=0.;
if(sheta[0] == '\0')
 return;

if(iceb_tu_pole2(sheta,':') == 0) //если нет ":" значит суммируются уже посчитанные колонки
 {
  if(metka_ras == 0)
   return;
    
  balans_f2_r2(sheta,&k1,suma_kod1,kod);

  suma_kod1[nomer_kod]+=k1;

  return;
 }

if(metka_ras == 1)
 return;

int kolpol=iceb_tu_pole2(sheta,';');
if(kolpol == 0)
 {
  balans_f2_r1(metkabd,sheta,PROM,&k1,nomer_kod,kod_subbal);
  suma_kod1[nomer_kod]+=k1;
  return;
 }
 
class iceb_tu_str shet_metka("");
for(int i=0; i < kolpol; i++)
 {
  iceb_tu_polen(sheta,&shet_metka,i+1,';');
  if(shet_metka.ravno()[0] == '\0')
   continue;
  balans_f2_r1(metkabd,shet_metka.ravno(),PROM,&k1,nomer_kod,kod_subbal);
 }

suma_kod1[nomer_kod]+=k1;
}
/***********************/
/*                      */
/*************************/
void balans_f2_r1(int metkabd,const char *sheta,GLKTMP *PROM,double *k1,
int nomer_kod,const char *kod_subbal)
{
class iceb_tu_str shet("");
class iceb_tu_str shetk("");
class iceb_tu_str metka("");
class iceb_tu_str znak("");
class iceb_tu_str delit("");
class iceb_tu_str shet_mas("");
SQL_str row;
class SQLCURSOR cur;
char strsql[1024];

iceb_tu_polen(sheta,&znak,1,':');
iceb_tu_polen(sheta,&shet,2,':');
iceb_tu_polen(sheta,&shetk,3,':');
iceb_tu_polen(sheta,&metka,4,':');
iceb_tu_polen(sheta,&delit,2,'/');
//printw("znak=%s shet=%s shetk=%s metka=%s delit=%s\n",znak.ravno(),shet,shetk,metka.ravno(),delit.ravno());
double razdel=delit.ravno_atof();
if(razdel == 0)
 razdel=1.;
 
int nom_shetd;
int nom_shetk;
int kol_shet=PROM->masf.kolih();

for(nom_shetd=0; nom_shetd < kol_shet; nom_shetd++)
 {
  shet_mas.new_plus(PROM->masf.ravno(nom_shetd));

  if(iceb_tu_proverka(shet.ravno(),shet_mas.ravno(),1,0) != 0)
   continue;

  if(sbshet != NULL)
   {
    if(metkabd == 0) //хозрасчёт
     if(iceb_tu_proverka(sbshet,shet_mas.ravno(),1,0) == 0)
      continue;

   if(metkabd == 1) //бюджет
    if(iceb_tu_proverka(sbshet,shet_mas.ravno(),1,0) != 0)
      continue;
   }

  if(kod_subbal[0] != '\0')
   {
    sprintf(strsql,"select ksb from Plansh where ns='%s'",shet_mas.ravno());
    
    if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
     {
      sprintf(strsql,"%s-%s %s %s",__FUNCTION__,gettext("Нет счета"),shet_mas.ravno(),gettext("в плане счетов"));
      iceb_t_soob(strsql);
      continue;
     }

    if(iceb_tu_proverka(kod_subbal,row[0],0,0) != 0)
     continue;
   }

  
  for(nom_shetk=0; nom_shetk < kol_shet ; nom_shetk++)
   {
    if(sbshet != NULL)
     {
      if(metkabd == 0) //хозрасчёт
       if(iceb_tu_proverka(sbshet,PROM->masf.ravno(nom_shetk),1,0) == 0)
         continue;

      if(metkabd == 1) //бюджет
       if(iceb_tu_proverka(sbshet,PROM->masf.ravno(nom_shetk),1,0) != 0)
         continue;
     }
    if(iceb_tu_proverka(shetk.ravno(),PROM->masf.ravno(nom_shetk),1,0) != 0)
     continue;
   
    if(metka.ravno()[0] == 'k') //кредит
     {
      if(znak.ravno()[0] == '+')
       {
        *k1+=PROM->pe.ravno(nom_shetk*kol_shet+nom_shetd)/razdel;
       }
      if(znak.ravno()[0] == '-')
       {
        *k1-=PROM->pe.ravno(nom_shetk*kol_shet+nom_shetd)/razdel;
       }

     }
    if(metka.ravno()[0] == 'd') //дебит
     {
      if(znak.ravno()[0] == '+')
       {
        *k1+=PROM->pe.ravno(nom_shetd*kol_shet+nom_shetk)/razdel;
       }
      if(znak.ravno()[0] == '-')
       {
        *k1-=PROM->pe.ravno(nom_shetd*kol_shet+nom_shetk)/razdel;
       }
     }
   }
 }

}
/**************************************/
/*Подсчёт итогов по кодам */
/***************************************/
void balans_f2_r2(const char *kodip,double *k1,
double *suma_kod1,class iceb_tu_spisok *kod)
{
*k1=0.;
int nom_kod=0;
short metka=1;
class iceb_tu_str kodi(kodip);

int kolpol=iceb_tu_pole2(kodi.ravno(),',');
if(kolpol == 0)
 {
  if(kodi.ravno_atoi() < 0)
   metka=-1;  

  kodi.udsimv("+-");
      
  if((nom_kod=kod->find(kodi.ravno())) < 0)
   return;

  *k1+=suma_kod1[nom_kod]*metka;
  return;
 }
class iceb_tu_str kodd("");

for(int i=0; i < kolpol; i++)
 {

  if(iceb_tu_polen(kodi.ravno(),&kodd,i+1,',') != 0)
   break;
  if(kodd.ravno()[0] == '\0')
   continue;
  metka=1;
  if(kodd.ravno_atoi() < 0)
   metka=-1;

  kodd.udsimv("+-");

  if((nom_kod=kod->find(kodd.ravno())) < 0)
   continue;
  *k1+=suma_kod1[nom_kod]*metka;
 }

}
