/*$Id: b_privatinvest.c,v 5.15 2013/09/26 09:43:28 sasa Exp $*/
/*17.03.2012	03.06.2004	Белых А.И.	b_privatinvest.c
Формирование файла для банка "Приватинвест"

Реквизиты 24,25,26,27,28,29,30 должны быть все одновременно заполнены или одновременно пустые

Реквизиты 13,14,15,16 используются в исключительных ситуациях, когда банк имеет возможность 
платить деньги в национальной валюте другим банкам минуя СЕП.

Реквизиты 17-21 используются когда банковская система имеет возможность платить деньги в валюте
минуя СЕП. Данные поля можно не заполнять, но в этом случае будет иметь место неадекватное 
отоброжение информации при просмотре платежей (т.е. данные реквизиты будут утеряны при проводках


 1 (10) порядкрвый номер 
        Обязателен для заполнения
 2 (14) счёт по дебету
        Обязателен для заполнения
 3 (14) счёт по кредиту
        Обязателен для заполнения
 4 (20) сумма
        Обязателен для заполнения
 5 (3)  символ при отсутствии необходимо заполнять 0
        Обязателен для заполнения
 6 (2)  вид операции при отсутствии необходимо заполнять 6
        Обязателен для заполнения
 7 (10) номер документа при отсутствии необходимо заполнять номером строки 
        Обязателен для заполнения
 8 (10) Дата документа Значение должно быть в формате yyyy\mm\dd
        Обязателен для заполнения
 9 (10) Дата проводки  Значение должно быть в формате yyyy\mm\dd по умолчанию необходимо заполнять текущей датой
        Обязателен для заполнения
10 (3)  Код валюты в которой выполняется проводка Ведущие нули необязательны
        Обязателен для заполнения
11 (160) Назначение платежа
        Обязателен для заполнения
12 (9)  МФО банка Для внутренних проводок заполняется значением МФО банка
        Обязателен для заполнения
13 (38) Наименование банка 
        Обязателен для платежей в национальной валюте за пределы банка
14 (14) Счёт клиента получателя
        Обязателен для платежей в национальной валюте за пределы банка
15 (38) Наименование клиента получателя 
        Обязателен для платежей в национальной валюте за пределы банка
16 (10) СКПО клиента получателя 
        Обязателен для платежей в национальной валюте за пределы банка
17 (20) Счёт иностранного банка получателя 
        Обязателен для платежей в валюте за пределы банка
18 (40) Наименование иностранного банка получателя
        Обязателен для платежей в валюте за пределы банка
19 (20) Счёт иностранного клиента получателя
        Обязателен для платежей в валюте за пределы банка
20 (40) Наименование иностранного клиента получателя
        Обязателен для платежей в валюте за пределы банка
21 (3)  Код страны
        Обязателен для платежей в валюте за пределы банка
22 (3)  Код валюты по счёту дебета Код валюты в которой открыт счёт по дебету. Ведущие ноли не обязательны
        Обязателен 
23 (3)  Код валюты по счёту кредита Код валюты в которой открыт счёт по кредиту. Ведущие ноли не обязательны
        Обязателен 
24 (64) Название документа
        Обязателен для платежей согласно инструкции N
25 (16) серия документа
        Обязателен для платежей согласно инструкции N
26 (32) Номер документа
        Обязателен для платежей согласно инструкции N
27 (128) Кем выдан документ
        Обязателен для платежей согласно инструкции N
28 (10) Дата выдачи документа Значение должно быть в формате yyyy\mm\dd
        Обязателен для платежей согласно инструкции N
29 (64) Адрес
        Обязателен для платежей согласно инструкции N
30 (10) Дата рождения Значение должно быть в формате yyyy\mm\dd
        Обязателен для платежей согласно инструкции N
31 (10) Номер депозита Если файл заканчивается из "4К-Депозитов", то данные поля являются обязательными -
        для закачки депозитов, чтобы операции автоматически подключились к договорам. Если файл
        закачивается из "4К-BANK", то данные поля (31,32) в файл включать не надо.

Пример записи

1|10023800001701|29099824701701|11.02|32|3|1|2003\06\06|2003\06\06|980|┤═ ╞╝А╚Цё╗ ї╒"Ої╙Ц  111111-11111-1111-575|353489|─│ "▐Ю╗╒═Б╗ґ╒╔АБ" ё.≈╔Юґ╗ё╝╒|29099824701701|▓Ю═ґї╗БґК╘ АГ╔Б|09809192||||||980|980|||||||
2|29099824701701|12007019000001|11.02|000|2|2|2003\06\06|2003\06\06|980|┤═ ╞╝А╚Цё╗ ї╒"Ої╙Ц  ⌠╙ЮБ╔╚╔╙╝╛|353348|─│ "─┌─▀°"|260053425|┌─▓ "⌠╙ЮБ╔╚╔╙╝╛"|1856416076||||||980|980|||||||


 */


#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int	b_privatinvest(const char *tabl)
{
char		imaf1[32];
FILE		*ff1;
class iceb_tu_str koment("");
char		strsql[1024];
short		d,m,g;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }
 


sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  error_op_nfil(imaf1,errno,"");
  return(1);
 }

int nomstr=0;
short dt,mt,gt;
iceb_tu_poltekdat(&dt,&mt,&gt);

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);

  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);
  
  fprintf(ff1,"%d|%s|%s|%.2f|%s|%s|%s|%d\\%d\\%d|%d\\%d\\%d|%s|%.*s|%s|%s|%s|%s|%s||||||980|980|||||||\n",
  ++nomstr, //1
  rec.nsh.ravno(),  //2
  rec.nsh1.ravno(), //3
  rec.sumd, //4
  "000",    //5
  "6",      //6
  row[1], //7
  rec.gd,rec.md,rec.dd,//8
  gt,mt,dt, //9
  "980",    //10
  iceb_tu_kolbait(160,koment.ravno()),koment.ravno(),   //11
  rec.mfo1.ravno(), //12
  rec.naiban1.ravno(), //13
  rec.nsh1.ravno(),   //14
  rec.naior1.ravno(), //15
  rec.kod1.ravno());  //16
 }

fclose(ff1);
iceb_t_perecod(2,imaf1);
return(0);
}
