/*$Id:$*/
/*10.02.2023	26.02.2021	Белых А.И.	b_privat_csv.cpp
Платёжка в формате csv

Шановний клієнт! Просимо звернути увагу, якщо у одержувача відсутній Код
ЄДРПОУ/ІПН, обов'язково введіть у поле OKPO_B - 0000000000 та коректно заповніть
поля “Серія паспорту отримувача (SER_PAS_В)” та “Номер паспорту отримувача
(NOM_PAS_В.)”. Якщо Ви маєте "Електронний паспорт громадянина України" коректно
заповніть “Номер паспорту отримувача (NOM_PAS_В.)”, а поле “Серія паспорту
отримувача (SER_PAS_В)” залиште пустим.




Назва поля     Опис поля                                                      Приклад

N_D            Номер документу                                                77
SUMMA          Сума платежу                                                   2015.99
COUNT_A        Номер рахунку платника                                         UA003052990000026001555777001
NAME_B         Найменування отримувача                                        ТОВ Львів
COUNT_B        Номер рахунку/картки (рахунок тільки уформаті IBAN) отримувача UA003052990000026001555777001/1234123412341234
N_P            Призначення платежу                                            Оплата згідно угоди 22 від 01.01.2015р., ПДВ ...
OKPO_B         Код ЄДРПОУ / ІПН отримувача                                    13422702
SER_PAS_В      Серія паспорту отримувача АК
NOM_PAS_В      Номер паспорту/id паспортуотримувача                           126126 (126126126 для id паспорту)

*/

#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int b_privat_csv(const char *tabl) /*выгрузка в csv файл*/
{
char		imaf1[64];
FILE		*ff1;
class iceb_tu_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }







sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  error_op_nfil(imaf1,errno,__FUNCTION__);
  return(1);
 }

fprintf(ff1,"\
N_D;SUMMA;COUNT_A;NAME_B;COUNT_B;N_P;OKPO_B;SER_PAS_B;NOM_PAS_B\n");

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);

  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  fprintf(ff1,"%s;%.2f;%s;%s;%s;\"%s\";%s;%s;%s;\r\n",
  rec.nomdk.ravno(),
  rec.sumd,
  rec.nsh.ravno(),
  rec.naior1.ravno(),
  rec.nsh1.ravno(),
  koment.ravno(),
  rec.kod1.ravno(),
  "",
  "");
 }

fclose(ff1);

return(0);
}
 