/*$Id:$*/
/*06.04.2023	18.11.2022	Белых А.И.	b_corpex_xml.cpp

Экспорт платёжки для системы "CORPEX"

                    !!!!!!!!!!!новый формат !!!!!!!!!!!!!!!

               Імпорт платіжної інструкції в національній валюті
                            (XML формат)
Файл імпорту містить блоки даних Загальні платіжні реквізити, Отримувач, Фактичний Отримувач та
Фактичний Платник. Зазначені блоки даних та поля в цих блоках мають визначені умови використання
та обробки. Основними умовами можна виділити наступне:
1. Блоки Загальні платіжні реквізити та Отримувач завжди є обов’язковими в файлі
2. Блок Фактичний Платник є обов’язковим якщо поле ISULTIMATEDEBTOR має значення «1»
3. Блок Фактичний Отримувач є обов’язковим якщо поле ISULTIMATECREDITOR має значення «1»
4. Поля даних адреси є обов’язковими, якщо будь-яку поле адреси заповнене, або якщо поле
IDTYPE має значення «NA» або «TRAN»
5. Поля даних дати та місця народження або поля даних адреси є обов’язковими, якщо поле
IDTYPE має значення «UNKN»

Опис полів

Тип даних    Опис
N         Числовий
F         Логічне значення: 1 або 0
AN        Буквено-цифровий
D         Дата (YYYY-MM-DD)
M         Обов’язкове
O         Необов’язковий ()

Назва поля                  Тип даних          Опис     
                      Загальні платіжні реквізити
---------------------------------------------------------------
DEBITACCOUNT                AN,29,M       Номер рахунку Платника
PONUMBER                    AN,35,O       Унікальний ідентифікатор (номер) інструкції
DATEVAL                     D,O           Дата валютування інструкції
AMOUNT                      N,16+2,M      Сума коштів переказу
DETAILS                     AN,420,M      Призначення платіжної інструкції
VAT                         AN,40,M       Поле ПДВ
                             
                           Отримувач
----------------------------------------------------------------
CREDITORACCOUNT             AN,34,M       Номер рахунку Отримувача
CREDITORACCOUNTNOTIBAN      F,O           Наразі не використовується
CREDITORAGENTACCOUNT        AN,29,O       Наразі не використовується
CREDITORNAME                N,140,M       Найменування
CREDITORCNTRYRES            N,3,M         Країна резидентності (ISO 3166-1 числовий)
CREDITORIDTYPE              AN,8,M        Пропрієтарне (власне) значення:
                                          для юридичних осіб - USCR, TRAN, NA
                                          для фізичних осіб - RNRCT, PSPT, OT, UNKN
CREDITORID                  AN,35,M       Код ідентифікації. Заповнюється значенням:   
                                          000000000 , якщо CREDITORIDTYPE = NA
                                          99999 , якщо CREDITORIDTYPE = UNKN
CREDITORCONTACTPERSON       AN,140,O      Ім’я за яким можна ідентифікувати учасника
CREDITORCONTACTMOBILEPHONE  AN,14,O       В форматі +380-ХХХХХХХХХ
                         
          Дані адреси Отримувача (Місце знаходження)
--------------------------------------------------------------------------
CREDITORSTREET              AN,70,O       Вулиця
CREDITORBUILDING            AN,16,M       Номер будівлі, якщо відсутній вказати «б/н»
CREDITORAPARTMAN            AN,70,O       Номер квартири або офісу
CREDITORZIP                 AN,16,O       Поштовий індекс
CREDITORCITY                AN,35,M       Назва населеного пункту
CREDITORDISTRICT            AN,35,O       Назва району
CREDITORREGION              AN,35,O       Назва області
CREDITORCNTRY               N,3,O         Код країни (ISO 3166-1 числовий)

      Дата і місце народження отримувача
--------------------------------------------------------------------------
CREDITORDOB                 D,M           Дата народження
CREDITORCITYOFBIRTH         AN,35,M       Населений пункт, в якому народилася особа
CREDITORCNTRYOFBIRTH        N,3,M         Країна, де народилася особа, код (ISO 3166-1 числовий)

        Фактичний отримувач
--------------------------------------------------------------------------
ISULTIMATECREDITOR          F,O           0 або незаповнене – Фактичний Отримувач відсутній;
                                          1 – Фактичний Отримувач присутній, поля
                                          Фактичного Отримувача є обов’язковими
ULTIMATECREDITORNAME        AN,140,M      Найменування
ULTIMATECREDITORCNTRYRES    N,3,M         Країна резидентності (ISO 3166-1 числовий)
ULTIMATECREDITORIDTYPE      AN,8,M        Пропрієтарне (власне) значення:
                                          для юридичних осіб - USCR, TRAN, NA
                                          для фізичних осіб - RNRCT, PSPT, OT, UNKN
ULTIMATECREDITORID          AN,35,M       Код ідентифікації. Заповнюється значенням:
                                          000000000 , якщо CREDITORIDTYPE = NA
                                          99999 , якщо CREDITORIDTYPE = UNKN

                 Дані адреси Фактичного Отримувача (Місцезнаходження)
-----------------------------------------------------------------------------------
ULTIMATECREDITORSTREET      AN,70,O       Вулиця
ULTIMATECREDITORBUILDING    AN,16,M       Номер будівлі, якщо відсутній вказати «б/н»
ULTIMATECREDITORAPARTMAN    AN,70,O       Номер квартири або офісу
ULTIMATECREDITORZIP         AN,16,O       Поштовий індекс
ULTIMATECREDITORCITY        AN,35,M       Назва населеного пункту
ULTIMATECREDITORDISTRICT    AN,35,O       Назва району
ULTIMATECREDITORREGION      AN,35,O       Назва області
ULTIMATECREDITORCNTRY       N,3,O         Код країни (ISO 3166-1 числовий)

                   Дата і місце народження Фактичного Отримувача
-------------------------------------------------------------------------------------
ULTIMATECREDITORDOB         D,M           Дата народження
ULTIMATECREDITORCITYOFBIRTH AN,35,M       Населений пункт, в якому народилася особа
ULTIMATECREDITORCNTRYOFBIRTH N,3,M        Країна, де народилася особа, код (ISO 3166-1 числовий)

                                Фактичний Платник
---------------------------------------------------------------------------------------
ISULTIMATEDEBTOR             F,O          0 або незаповнене – Фактичний Платник
                                          відсутній;
                                          1 – Фактичний Платник присутній, поля
                                          Фактичного Платника є обов’язковими
ULTIMATEDEBTORNAME           AN,140,M     Найменування
ULTIMATEDEBTORCNTRYRES       N,3,M        Країна резидентності (ISO 3166-1 числовий)
ULTIMATEDEBTORIDTYPE         AN,8,M       Пропрієтарне (власне) значення:
                                          для юридичних осіб - USCR, TRAN, NA
                                          для фізичних осіб - RNRCT, PSPT, OT, UNKN

ULTIMATEDEBTORID             AN,35,M      Код ідентифікації. Заповнюється значенням:
                                          000000000 , якщо CREDITORIDTYPE = NA
                                          99999 , якщо CREDITORIDTYPE = UNKN

                         Дані адреси Фактичного Платника (Місцезнаходження)
-------------------------------------------------------------------------------------------
ULTIMATEDEBTORSTREET         AN,70,O      Вулиця
ULTIMATEDEBTORBUILDING       AN,16,M      Номер будівлі, якщо відсутній вказати «б/н»
ULTIMATEDEBTORAPARTMAN       AN,70,O      Номер квартири або офісу
ULTIMATEDEBTORZIP            AN,16,O      Поштовий індекс
ULTIMATEDEBTORCITY           AN,35,M      Назва населеного пункту
ULTIMATEDEBTORDISTRICT       AN,35,O      Назва району
ULTIMATEDEBTORREGION         AN,35,O      Назва області
ULTIMATEDEBTORCNTRY          N,3,O        Код країни (ISO 3166-1 числовий)

                          Дата і місце народження Фактичного Платника
--------------------------------------------------------------------------------------------
ULTIMATEDEBTORDOB            D,M          Дата народження
ULTIMATEDEBTORCITYOFBIRTH    AN,35,M      Населений пункт, в якому народилася особа
ULTIMATEDEBTORCNTRYOFBIRTH   N,3,M        Країна, де народилася особа, код (ISO 3166-1 числовий)


Пример файла:


<?xml version="1.0" encoding="windows-1251" ?>
<file>
	<record index="1">

		<!-- General details related fields-->

		<AMOUNT>25600.40</AMOUNT>
		<DEBITACCOUNT>UA043006140000026004002063000</DEBITACCOUNT>
		<DETAILS>Оплата за надані послуги згідно дог. №12-22-10</DETAILS>
		<VAT>В т. ч. ПДВ 4266.73 грн.</VAT>
		<PONUMBER>АА427011</PONUMBER>
		<DATEVAL>2023-02-05</DATEVAL>		
				
		<!-- CREDITOR related fields-->

		<CREDITORACCOUNT>UA473006140000026001000411000</CREDITORACCOUNT>
		<CREDITORACCOUNTNOTIBAN></CREDITORACCOUNTNOTIBAN>
		<CREDITORAGENTACCOUNT></CREDITORAGENTACCOUNT>		
		<CREDITORNAME>ТОВ КОМПАНІЯ 2</CREDITORNAME>
		<CREDITORCNTRYRES>804</CREDITORCNTRYRES>
		<CREDITORIDTYPE>USRC</CREDITORIDTYPE>
		<CREDITORID>00009998</CREDITORID>
		<CREDITORCONTACTPERSON></CREDITORCONTACTPERSON>
		<CREDITORCONTACTMOBILEPHONE></CREDITORCONTACTMOBILEPHONE>                            
		<CREDITORSTREET></CREDITORSTREET>
		<CREDITORBUILDING></CREDITORBUILDING>
		<CREDITORAPARTMAN></CREDITORAPARTMAN>
		<CREDITORZIP></CREDITORZIP>
		<CREDITORCITY></CREDITORCITY>
		<CREDITORDISTRICT></CREDITORDISTRICT>
		<CREDITORREGION></CREDITORREGION>
		<CREDITORCNTRY></CREDITORCNTRY>
		<CREDITORDOB></CREDITORDOB>
		<CREDITORCITYOFBIRTH></CREDITORCITYOFBIRTH>
		<CREDITORCNTRYOFBIRTH></CREDITORCNTRYOFBIRTH>
		
		<!-- ULTIMATECREDITOR related fields-->

		<ISULTIMATECREDITOR></ISULTIMATECREDITOR>		
		<ULTIMATECREDITORNAME></ULTIMATECREDITORNAME>
		<ULTIMATECREDITORCNTRYRES></ULTIMATECREDITORCNTRYRES>
		<ULTIMATECREDITORIDTYPE></ULTIMATECREDITORIDTYPE>
		<ULTIMATECREDITORID></ULTIMATECREDITORID>
		<ULTIMATECREDITORSTREET></ULTIMATECREDITORSTREET>
		<ULTIMATECREDITORBUILDING></ULTIMATECREDITORBUILDING>
		<ULTIMATECREDITORAPARTMAN></ULTIMATECREDITORAPARTMAN>
		<ULTIMATECREDITORZIP></ULTIMATECREDITORZIP>
		<ULTIMATECREDITORCITY></ULTIMATECREDITORCITY>
		<ULTIMATECREDITORDISTRICT></ULTIMATECREDITORDISTRICT>
		<ULTIMATECREDITORREGION></ULTIMATECREDITORREGION>
		<ULTIMATECREDITORCNTRY></ULTIMATECREDITORCNTRY>
		<ULTIMATECREDITORDOB></ULTIMATECREDITORDOB>
		<ULTIMATECREDITORCITYOFBIRTH></ULTIMATECREDITORCITYOFBIRTH>
		<ULTIMATECREDITORCNTRYOFBIRTH></ULTIMATECREDITORCNTRYOFBIRTH>
		
		<!-- ULTIMATEDEBTOR related fields-->

		<ISULTIMATEDEBTOR></ISULTIMATEDEBTOR>		
		<ULTIMATEDEBTORNAME></ULTIMATEDEBTORNAME>
		<ULTIMATEDEBTORCNTRYRES></ULTIMATEDEBTORCNTRYRES>
		<ULTIMATEDEBTORIDTYPE></ULTIMATEDEBTORIDTYPE>
		<ULTIMATEDEBTORID></ULTIMATEDEBTORID>
		<ULTIMATEDEBTORSTREET></ULTIMATEDEBTORSTREET>
		<ULTIMATEDEBTORBUILDING></ULTIMATEDEBTORBUILDING>
		<ULTIMATEDEBTORAPARTMAN></ULTIMATEDEBTORAPARTMAN>
		<ULTIMATEDEBTORZIP></ULTIMATEDEBTORZIP>
		<ULTIMATEDEBTORCITY></ULTIMATEDEBTORCITY>
		<ULTIMATEDEBTORDISTRICT></ULTIMATEDEBTORDISTRICT>
		<ULTIMATEDEBTORREGION></ULTIMATEDEBTORREGION>
		<ULTIMATEDEBTORCNTRY></ULTIMATEDEBTORCNTRY>
		<ULTIMATEDEBTORDOB></ULTIMATEDEBTORDOB>
		<ULTIMATEDEBTORCITYOFBIRTH></ULTIMATEDEBTORCITYOFBIRTH>
		<ULTIMATEDEBTORCNTRYOFBIRTH></ULTIMATEDEBTORCNTRYOFBIRTH>
	</record>
</file>


**************************/



#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int b_corpex_xml(const char *tabl)
{
char		imaf1[64];
class iceb_tu_str koment("");
char		strsql[1024];
short		d,m,g;
int pnd=0;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }

class iceb_tu_str metka_fop("");

class iceb_fopen fil_ff;

sprintf(imaf1,"plat.txt");
if(fil_ff.start(imaf1,"w") != 0)
 return(1);

fprintf(fil_ff.ff,"<?xml version= \"1.0\" encoding= \"windows-1251\"?>\r\n\
<file>\r\n");




/*Так как в системе предусморено только 40 символов для наименования организации то нужно брать короткое наименование*/

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);
  if(readpdok(tabl,g,row[1]) != 0)
     continue;
  
  class iceb_tu_str naior(rec.naior.ravno());
  class iceb_tu_str naior1(rec.naior1.ravno());
 
  if(iceb_tu_strlen(rec.naior.ravno()) > 140)
   {
    naior.new_plus(iceb_t_get_pnk(rec.kodor.ravno(),0));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 140 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_t_soob(strsql);

   }

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  class iceb_tu_str naim_kontr(iceb_tu_filtr_xml(naior1.ravno()));

  if(iceb_tu_strlen(rec.kod1.ravno()) <= 8)
   metka_fop.new_plus("USRC"); /*юридическое лицо*/
  else
   metka_fop.new_plus("RNRCT"); /*физическое лицо*/


  fprintf(fil_ff.ff," <record index=\"%d\">\r\n",++pnd);
  fprintf(fil_ff.ff,"<!-- General details related fields-->\r\n\r\n");

  fprintf(fil_ff.ff,"  <AMOUNT>%.2f</AMOUNT>\r\n",rec.sumd);
  fprintf(fil_ff.ff,"  <DEBITACCOUNT>%s</DEBITACCOUNT>\r\n",rec.nsh.ravno());
  fprintf(fil_ff.ff,"  <DETAILS>%.*s</DETAILS>\r\n",iceb_tu_kolbait(30,iceb_tu_filtr_xml(koment.ravno())),iceb_tu_filtr_xml(koment.ravno()));
  fprintf(fil_ff.ff,"  <VAT>%.2f</VAT>\r\n",rec.nds);
  fprintf(fil_ff.ff,"  <PONUMBER>%s</PONUMBER>\r\n",rec.nomdk.ravno());
  fprintf(fil_ff.ff,"  <DATEVAL>%04d-%02d-%02d</DATEVAL>\r\n",rec.gd,rec.md,rec.dd);
  
  fprintf(fil_ff.ff,"\r\n  <!-- CREDITOR related fields-->\r\n\r\n");

  fprintf(fil_ff.ff,"  <CREDITORACCOUNT>%s</CREDITORACCOUNT>\r\n",rec.nsh1.ravno());
  fprintf(fil_ff.ff,"  <CREDITORACCOUNTNOTIBAN></CREDITORACCOUNTNOTIBAN>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORAGENTACCOUNT></CREDITORAGENTACCOUNT>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORNAME>%s</CREDITORNAME>\r\n",naim_kontr.ravno());
  fprintf(fil_ff.ff,"  <CREDITORCNTRYRES>804</CREDITORCNTRYRES>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORIDTYPE>%s</CREDITORIDTYPE>\r\n",metka_fop.ravno());
  fprintf(fil_ff.ff,"  <CREDITORID>%s</CREDITORID>\r\n",rec.kod1.ravno());
  fprintf(fil_ff.ff,"  <CREDITORCONTACTPERSON></CREDITORCONTACTPERSON>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORCONTACTMOBILEPHONE></CREDITORCONTACTMOBILEPHONE>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORSTREET></CREDITORSTREET>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORBUILDING></CREDITORBUILDING>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORAPARTMAN></CREDITORAPARTMAN>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORZIP></CREDITORZIP>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORCITY></CREDITORCITY>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORDISTRICT></CREDITORDISTRICT>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORREGION></CREDITORREGION>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORCNTRY></CREDITORCNTRY>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORDOB></CREDITORDOB>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORCITYOFBIRTH></CREDITORCITYOFBIRTH>\r\n");
  fprintf(fil_ff.ff,"  <CREDITORCNTRYOFBIRTH></CREDITORCNTRYOFBIRTH>\r\n");

  fprintf(fil_ff.ff,"\r\n  <!-- ULTIMATECREDITOR related fields-->\r\n\r\n");
  
  fprintf(fil_ff.ff,"  <ISULTIMATECREDITOR></ISULTIMATECREDITOR>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORNAME></ULTIMATECREDITORNAME>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORCNTRYRES></ULTIMATECREDITORCNTRYRES>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORIDTYPE></ULTIMATECREDITORIDTYPE>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORID></ULTIMATECREDITORID>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORSTREET></ULTIMATECREDITORSTREET>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORBUILDING></ULTIMATECREDITORBUILDING>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORAPARTMAN></ULTIMATECREDITORAPARTMAN>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORZIP></ULTIMATECREDITORZIP>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORCITY></ULTIMATECREDITORCITY>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORDISTRICT></ULTIMATECREDITORDISTRICT>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORREGION></ULTIMATECREDITORREGION>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORCNTRY></ULTIMATECREDITORCNTRY>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORDOB></ULTIMATECREDITORDOB>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORCITYOFBIRTH></ULTIMATECREDITORCITYOFBIRTH>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATECREDITORCNTRYOFBIRTH></ULTIMATECREDITORCNTRYOFBIRTH>\r\n");
   
  fprintf(fil_ff.ff,"\r\n  <!-- ULTIMATEDEBTOR related fields-->\r\n\r\n");

  fprintf(fil_ff.ff,"  <ISULTIMATEDEBTOR></ISULTIMATEDEBTOR>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORNAME></ULTIMATEDEBTORNAME>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORCNTRYRES></ULTIMATEDEBTORCNTRYRES>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORIDTYPE></ULTIMATEDEBTORIDTYPE>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORID></ULTIMATEDEBTORID>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORSTREET></ULTIMATEDEBTORSTREET>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORBUILDING></ULTIMATEDEBTORBUILDING>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORAPARTMAN></ULTIMATEDEBTORAPARTMAN>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORZIP></ULTIMATEDEBTORZIP>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORCITY></ULTIMATEDEBTORCITY>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORDISTRICT></ULTIMATEDEBTORDISTRICT>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORREGION></ULTIMATEDEBTORREGION>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORCNTRY></ULTIMATEDEBTORCNTRY>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORDOB></ULTIMATEDEBTORDOB>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORCITYOFBIRTH></ULTIMATEDEBTORCITYOFBIRTH>\r\n");
  fprintf(fil_ff.ff,"  <ULTIMATEDEBTORCNTRYOFBIRTH></ULTIMATEDEBTORCNTRYOFBIRTH>\r\n");
 
  fprintf(fil_ff.ff," </record>\r\n");





 }

fprintf(fil_ff.ff,"</file>\r\n");


fil_ff.end();
iceb_t_perecod(2,imaf1);
return(0);
}

