/*$Id:$*/
/*13.07.2023	03.02.2022	Белых А.И.	b_CorpLight_dbf.cpp

Платёжка в формате dbf

Экспорт для подсистемы "CorpLight" 



 1 ndoc    Номер платёжного поручения Значение может содержать число и буквы
 2 dt      Дата документа дд.мм.рррр
 3 dv      *** Дата валютирования дд.мм.рррр Если поле пустое, то дата валютирования соотвецтвует дате документа
 4 acccli  Счёт (IBAN) плательщика
 5 acccor  Счёт (IBAN) получателя
 6 okpocor Налоговый код получетеля (ІПН, ЄДРПОУ, ЗКПО) Числовое значение
 7 namecor Наименование получателя Текст
 8 summa   Сумма платежа в копейках
 9 val     Валюта, ISO 4217 Числовий код валюти з довідника (якщо код не 980 – код країни не є обов’язковим до заповнення)	
10 nazn    Назначение платежа не более 160 символов
11 cod_cor ** Код страны нерезидента получателя(ISO 3166-1 numeric)
12 add_req * Дополнительные реквизиты Может содержать буквы или числа

* обов'язково якщо п.6 (податковий код) дорівнює 0000000000

** обов'язково якщо п.6 (податковий код) дорівнює 00000000

*** якщо поле пусте, то дата валютування відповідатиме даті документу.





*/
#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

void b_CorpLight_h(char *imaf,long kolz);

extern class REC rec;


int b_CorpLight_dbf(const char *tabl) /*выгрузка в dbf файл*/
{
char		imaf1[64];
class iceb_tu_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }





class iceb_fopen fil;

sprintf(imaf1,"plat_b.txt");

if(fil.start(imaf1,"w") != 0)
 return(1);

int suma_int=0;
double suma_double=0.,bb=0.;
 
int nomstr=0;

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);

  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  nomstr++;  

  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_tu_okrug(rec.sumd,0.01);

  bb=rec.sumd*100.;
 
  modf(bb,&suma_double);
  suma_int=(int)suma_double;


  fprintf(fil.ff," %-*s%04d%02d%02d%8s%-29s%-29s%-29s%-*.*s%20d%4s%-*.*s%20d%-160s%-36s",
  iceb_tu_kolbait(35,rec.nomdk.ravno()),
  rec.nomdk.ravno(),
  rec.gd,rec.md,rec.dd,
  "",
  rec.nsh.ravno(),
  rec.nsh1.ravno(),
  rec.kod1.ravno(),
  iceb_tu_kolbait(140,rec.naior1.ravno()),
  iceb_tu_kolbait(140,rec.naior1.ravno()),
  rec.naior1.ravno(),
  suma_int,
  "980",
  iceb_tu_kolbait(164,koment.ravno()),
  iceb_tu_kolbait(164,koment.ravno()),
  koment.ravno(),
  804,
  "",
  "");

 }

fputc(26, fil.ff);

fil.end();

iceb_t_perecod(2,imaf1);

char imafdbf[64];

sprintf(imafdbf,"plat.txt");
b_CorpLight_h(imafdbf,nomstr);

/*Сливаем два файла*/
iceb_t_cat(imafdbf,imaf1);
unlink(imaf1);
return(0);

}

/******************************/
/*Создаем заголовок файла dbf*/
/******************************/
void b_CorpLight_f(DBASE_FIELD *f,const char *fn,char  ft,int l1,int l2,
int *header_len,int *rec_len)
{

strncpy(f->name, fn,sizeof(f->name)-1);
f->type = ft;
f->length = l1;
f->dec_point = l2;
*header_len=*header_len+sizeof(DBASE_FIELD);
*rec_len=*rec_len+l1;
}

/***********************************************/
void b_CorpLight_h(char *imaf,long kolz)
{
time_t		tmm;
struct  tm      *bf;
DBASE_HEAD  h;
int fd;
int i;
int header_len, rec_len;
#define kolpol  13
DBASE_FIELD f[kolpol];
memset(&f, '\0', sizeof(f));

class iceb_fopen fil;

if(fil.start(imaf,"w") != 0)
 return;
memset(&h,'\0',sizeof(h));

h.version = 3;

time(&tmm);
bf=localtime(&tmm);

h.l_update[0] = bf->tm_year+1900-2000;       /* yymmdd for last update*/
h.l_update[1] = bf->tm_mon+1;       /* yymmdd for last update*/
h.l_update[2] = bf->tm_mday;       /* yymmdd for last update*/

h.count = kolz;              /* number of records in file*/

header_len = sizeof(h);
rec_len = 0;
int shetshik=0;


b_CorpLight_f(&f[shetshik++],"NDOC", 'C', 35, 0,&header_len,&rec_len);//1
b_CorpLight_f(&f[shetshik++],"DT", 'D', 8, 0,&header_len,&rec_len);//2
b_CorpLight_f(&f[shetshik++],"DV", 'D', 8,0,&header_len,&rec_len);//3
b_CorpLight_f(&f[shetshik++],"ACCCLI", 'C', 29, 2,&header_len,&rec_len);//4
b_CorpLight_f(&f[shetshik++],"ACCCOR", 'C',29, 0,&header_len,&rec_len);//5
b_CorpLight_f(&f[shetshik++],"OKPOCOR", 'C',29, 0,&header_len,&rec_len);//6
b_CorpLight_f(&f[shetshik++],"NAMECOR", 'C',140, 0,&header_len,&rec_len);//7
b_CorpLight_f(&f[shetshik++],"SUMMA", 'N', 20, 0,&header_len,&rec_len);//8
b_CorpLight_f(&f[shetshik++],"VAL", 'N', 4, 0,&header_len,&rec_len);//9
b_CorpLight_f(&f[shetshik++],"NAZN", 'C',164, 0, &header_len,&rec_len);//10
b_CorpLight_f(&f[shetshik++],"COD_COR", 'N', 20, 0,&header_len,&rec_len);//11
b_CorpLight_f(&f[shetshik++],"ADD_REQ", 'C',160, 0,&header_len,&rec_len);//12
b_CorpLight_f(&f[shetshik++],"UETR", 'C',36, 0,&header_len,&rec_len);//13

h.header = header_len + 1;/* length of the header
                           * includes the \r at end
                           */
h.lrecl= rec_len + 1;     /* length of a record
                           * includes the delete
                           * byte
                          */
/*
 printw("h.header=%d h.lrecl=%d\n",h.header,h.lrecl);
*/


fd = fileno(fil.ff);

if(write(fd, &h, sizeof(h)) < 0)
 {
  printw("\n%s-%s\n",__FUNCTION__,strerror(errno));
  OSTANOV();
 }

for(i=0; i < kolpol; i++) 
 {
  if(write(fd, &f[i], sizeof(DBASE_FIELD)) < 0)
   {
    printw("\n%s-%s\n",__FUNCTION__,strerror(errno));
    OSTANOV();
   }
 }
fputc('\r', fil.ff);

fil.end();

}
