/*$Id:$*/
/*20.02.2025	10.06.2004	Белых 	raskus.c
Расчёт коммунальных услуг
*/

#include <stdio.h>
#include <iceb.h>
#include <buhg.h>
#include <unistd.h>
#include <errno.h>
class raskus_nast
 {
  public:
   class iceb_tu_str kodop;
   class iceb_tu_str kod_podr;
   
   class iceb_tu_str kod_kp;    /*код услуги*/
   class iceb_tu_str kod_kp_ei; /*единица измерения услуги*/
   class iceb_tu_str kod_kp_su; /*Счёт учёта услуги*/
   class iceb_tu_str kod_kp_ss; /*Счёт списания услуги*/

   class iceb_tu_str kod_ot;
   class iceb_tu_str kod_ot_ei;
   class iceb_tu_str kod_ot_su;
   class iceb_tu_str kod_ot_ss;

   class iceb_tu_str kod_el;
   class iceb_tu_str kod_el_ei;
   class iceb_tu_str kod_el_su;
   class iceb_tu_str kod_el_ss;

   class iceb_tu_str kod_vod;
   class iceb_tu_str kod_vod_ei;
   class iceb_tu_str kod_vod_su;
   class iceb_tu_str kod_vod_ss;

   class iceb_tu_str kod_stoki;
   class iceb_tu_str kod_stoki_ei;
   class iceb_tu_str kod_stoki_su;
   class iceb_tu_str kod_stoki_ss;

   class iceb_tu_str kod_gaz;
   class iceb_tu_str kod_gaz_ei;
   class iceb_tu_str kod_gaz_su;
   class iceb_tu_str kod_gaz_ss;

   class iceb_tu_str kod_r_gaz;
   class iceb_tu_str kod_r_gaz_ei;
   class iceb_tu_str kod_r_gaz_su;
   class iceb_tu_str kod_r_gaz_ss;

   class iceb_tu_str musor;
   class iceb_tu_str musor_ei;
   class iceb_tu_str musor_su;
   class iceb_tu_str musor_ss;
  raskus_nast()
   {
    kod_podr.plus("");
    kod_gaz.plus("");
    kod_r_gaz.plus("");
    kodop.plus("");
    kod_kp.plus("");
    kod_ot.plus("");
    kod_el.plus("");
    kod_vod.plus("");
    kod_stoki.plus("");
    musor.plus("");

    kod_gaz_ss.plus("");
    kod_r_gaz_ss.plus("");
    kod_kp_ss.plus("");
    kod_ot_ss.plus("");
    kod_el_ss.plus("");
    kod_vod_ss.plus("");
    kod_stoki_ss.plus("");
    musor_ss.plus("");

    kod_gaz_su.plus("");
    kod_r_gaz_su.plus("");
    kod_kp_su.plus("");
    kod_ot_su.plus("");
    kod_el_su.plus("");
    kod_vod_su.plus("");
    kod_stoki_su.plus("");
    musor_su.plus("");

    kod_gaz_ei.plus("");
    kod_r_gaz_ei.plus("");
    kod_kp_ei.plus("");
    kod_ot_ei.plus("");
    kod_el_ei.plus("");
    kod_vod_ei.plus("");
    kod_stoki_ei.plus("");
    musor_ei.plus("");

   }

 };

int raskus_rn(class raskus_nast *kodusl);
double raskus_so(const char *shet,const char *kontr,short mr,short gr);
int raskus_ud(short mr,short gr,const char *osnov);
void raskus_itogo(const char *koment,double *ish_dan_dom,double *summa,FILE *ff);
int raskus_zap_opl(char *nom_dom,char *nom_kv,short mn,short gn,double *suma);
int ku_saldo(const char *nom_dom,const char *nom_kv,short mr,short gr,double *suma,double *oplata,short kol_suma);
void raskus_hap(int nomlst,int *kolstr,FILE *ff);


extern SQL_baza	bd;
extern char		*imabaz;
extern char		*putnansi;

extern float kvartp; //квартирная плата
extern float otop;   //отопление
extern float elek;   //електроенергия
extern float musor_cena;       /*Цена вывоза мусора на 1 человека*/
extern float musor_kolih;
extern class iceb_tu_str shin; /*Счёт сальдо по услугам оказанных организацией*/
extern class iceb_tu_str shout; /*Счёт сальдо услугам оказанных другими организациями*/

extern float voda_cena_b_sh; /*цена воды без счётчика*/
extern float voda_kolih_b_sh; /*количество воды без счётчика*/
extern float voda_cena_po_sh; /*цена воды по счётчику*/

extern float stoki_cena_b_sh;  /*цена стока без счётчика*/
extern float stoki_kolih_b_sh; /*количество стока без счётчика*/
extern float stoki_cena_po_sh; /*цена стока по счётчику*/

extern float gaz_cena;     /*цена газа*/
extern float gaz_kolih;    /*Объём газа*/
extern float gaz_r_cena;   /*цена распределения газа*/
extern float gaz_r_kolih;  /*Объём распределения газа*/

int mfnn=1;
double	okrcn=0.01;  /*Округление цены*/
double okrg1=0.01;
void raskus()
{
class raskus_nast kodusl;

char strsql[2048];
static class iceb_tu_str nomd("");   // Номер дома
static class iceb_tu_str nomk("");   // Номер квартиры
static class iceb_tu_str data(""); /*Дата расчёта*/  
static class iceb_tu_str datdok("");
char zapros[1024];
memset (zapros,'\0',sizeof(zapros));
 
SQLCURSOR cur,cur1;
SQL_str row,row1;
int kolstr;
short mr,gr;

VVOD VV(0);
char obr[8];
memset(obr,0,sizeof(obr));

VV.VVOD_spisok_add_ZAG("Расчет комунальных услуг");

VV.VVOD_spisok_add_MD("Номер дома..............");
VV.VVOD_spisok_add_MD("Номер квартиры..........");
VV.VVOD_spisok_add_MD("Дата......(м.г).........");
VV.VVOD_spisok_add_MD("Дата документа (д.м.г)..");

VV.VVOD_spisok_add_data(nomd.ravno(),5);
VV.VVOD_spisok_add_data(nomk.ravno(),5);
VV.VVOD_spisok_add_data(data.ravno(),8);
VV.VVOD_spisok_add_data(datdok.ravno(),11);
 

naz:;

helstr(LINES-1,0,
"F1","Помощь",
"F2/+","Расчёт",
"F10","Выход",NULL);


int kom=VV.vvod(0,1,1,-1,-1);

nomd.new_plus(VV.VVOD_spisok_return_data(0));
nomk.new_plus(VV.VVOD_spisok_return_data(1));
data.new_plus(VV.VVOD_spisok_return_data(2));
datdok.new_plus(VV.data_ravno(3));

switch(kom)
 {
  case FK1:
    goto naz;

  case FK2:
    break;

  case FK10:
     return;


 }

if (iceb_tu_rsdat1(&mr,&gr,data.ravno())!=0)
 {
  iceb_t_soob("Дата введена не правильно!");
  goto naz;
 }

if(iceb_t_pbpds(mr,gr) != 0)
 goto naz;

if(datdok.getdlinna() > 1)
 {
   if(datdok.prov_dat() != 0)
    {
     iceb_t_soob("Неправильно введена дата документа!");
     goto naz;
    }
  clear();
 }

GDITE();
/*Читаем настройки для создания документов в Учёте услуг*/
if(datdok.getdlinna() > 1)
 {
  if(iceb_t_pbpds(datdok.ravno()) != 0)
   goto naz;
  if(iceb_t_pvglkni(datdok.ravno()) != 0)
   goto naz;
    
  if(raskus_rn(&kodusl) != 0)
   goto naz;
 }

class iceb_tu_str naim_00("");
class iceb_tu_str telef("");
sprintf(zapros,"select naikon,telef from Kontragent where kodkon='00'");
if(iceb_t_sql_readkey(zapros,&row,&cur) == 1)
 {
  naim_00.new_plus(row[0]);
  telef.new_plus(row[1]);
 }


int metka=0;
sprintf(zapros,"select * from Kuskvart");
char bros[100];

if(nomd.ravno()[0]!='\0')
 {
  
  sprintf(bros," where nd='%s'",nomd.ravno());
  strcat(zapros,bros);    
  metka++;
 
 }
if(nomk.ravno()[0]!='\0')
 {
  if(metka == 0)
   sprintf(bros," where nk=%s",nomk.ravno());
  else
   sprintf(bros," and nk=%s",nomk.ravno());

  strcat(zapros,bros);    

 }
strcat(zapros," order by nd,fio asc");

if((kolstr=cur.make_cursor(&bd,zapros)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),zapros);
  return;
 }
if (kolstr == 0)
 {
  iceb_t_soob("Не найдено ни одной записи!!!");
  return; 
 }


class iceb_fopen fil_sh;
char imaf_sh[64];
sprintf(imaf_sh,"shet%d.lst",getpid());
if(fil_sh.start(imaf_sh,"w") != 0) 
 return;

char imaf[100];
class iceb_fopen fil_ff;
sprintf(imaf,"kusnast%d.lst",getpid());

if(fil_ff.start(imaf,"w") != 0) 
 return;


fprintf (fil_ff.ff,"Дата:%d.%d\n",mr,gr);
fprintf (fil_ff.ff,"Квартплата:%.3f\n", kvartp);
fprintf (fil_ff.ff,"Опалення:%.3f\n",otop);

fprintf(fil_ff.ff,"Ціна газа:%.3f Об'єм газа:%.3f Ціна розподілу газу:%.3f Об'єм розподілу газу:%.3f\n",
gaz_cena,gaz_kolih,gaz_r_cena,gaz_r_kolih);
fprintf (fil_ff.ff,"Ціна води по лічільнику:%.3f Ціна води без лічильника:%.3f Об'єм води без лічильника:%.3f\n",
voda_cena_po_sh,voda_cena_b_sh,voda_kolih_b_sh);

fprintf (fil_ff.ff,"Ціна стоків по лічільнику:%.3f Ціна стоків без лічильника:%.3f Об'єм стоків без лічильника:%.3f\n",
stoki_cena_po_sh,stoki_cena_b_sh,stoki_kolih_b_sh);

fprintf (fil_ff.ff,"Електроенергия:%.3f\n",elek);
fprintf (fil_ff.ff,"Сміття:%.3f Кількість:%.3f\n",musor_cena,musor_kolih);

raskus_hap(1,NULL,fil_ff.ff);



#define ITOGO_SUMA 9
double summa[ITOGO_SUMA];
memset(summa,0,sizeof(summa));

double summa_saldo[ITOGO_SUMA];
memset(summa_saldo,0,sizeof(summa_saldo));

double oplata_mr[ITOGO_SUMA];
memset(oplata_mr,0,sizeof(oplata_mr));

double isumma[ITOGO_SUMA];
memset(isumma,0,sizeof(isumma));

double isummad[ITOGO_SUMA];
memset(isummad,0,sizeof(isummad));

int ps=0;

class iceb_tu_str nomdomz("");

#define ITOGO_DOM 7
double ish_dan[ITOGO_DOM];
memset(ish_dan,'\0',sizeof(ish_dan));

double ish_dan_dom[ITOGO_DOM];
memset(ish_dan_dom,'\0',sizeof(ish_dan_dom));

double kolih=0.;
double cena=0.;
short dd,md,gd;
iceb_tu_rsdat(&dd,&md,&gd,datdok.ravno(),1);
float voda=0;
char dopol[50];
sprintf(dopol,"за %02d.%d р.",mr,gr);
int mnds=3; /*Освобождено от НДС*/
float pnds=20.;
class iceb_tu_str naimkon("");
int nomer_sh=0;
class iceb_tu_str nomshet1("");
class iceb_tu_str nomshet2("");
int kolstr1=0;
short drs=31,mrs=mr,grs=gr;
iceb_tu_dpm(&drs,&mrs,&grs,4);
int kolih_gitelei=0;

#define SHET_ITOGO 3
double shet_itogo[SHET_ITOGO];

for(int nom=0; nom <= SHET_ITOGO; nom++)
  shet_itogo[nom]=0.;
  
while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);
  
  /*Проверяем код контрагента*/
  sprintf(strsql,"select naikon from Kontragent where kodkon='%s'",row[10]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) != 1)
   {
    sprintf(strsql,"Не найден код контрагента %s для квартиры %s в доме %s",
    row[10],row[1],row[0]);           
    iceb_t_soob(strsql);
    continue;
   }

  naimkon.new_plus(row1[0]);
    
  if(iceb_tu_SRAV(nomdomz.ravno(),row[0],0) != 0)
   {
    if(nomdomz.ravno()[0] != '\0')
     {
      raskus_itogo("Разом по дому",ish_dan_dom,isummad,fil_ff.ff);
     }

    memset(isummad,0,sizeof(isummad));
    
    nomdomz.new_plus(row[0]);
   }
   

  sprintf(zapros,"select ps,voda from Kuspm where nd='%s' and nk='%s' and data='%d-%d-%d'",
  row[0],row[1],gr,mr,1);
  
  ps=0;
  voda=0.;
  if(sql_readkey(&bd,zapros,&row1,&cur1) > 0)
   {
    ps=atoi(row1[0]);
    voda=atof(row1[1]);
   }     

  kolih_gitelei=atoi(row[3]);

  memset(summa,'\0',sizeof(summa));

  summa[0]=(atof(row[4])+atof(row[5])+atof(row[11]))*kvartp;
  summa[0]=iceb_tu_okrug(summa[0],0.01);
  
  summa[1]=0.;  
  if(row[12][0] == '0')
   {  
    summa[1]=(atof(row[4])+atof(row[5]))*otop;
    summa[1]=iceb_tu_okrug(summa[1],0.01);
   }
  
  
  summa[2]=gaz_cena*gaz_kolih*kolih_gitelei;
  summa[2]=iceb_tu_okrug(summa[2],0.01);  

  summa[3]=gaz_r_cena*gaz_r_kolih*kolih_gitelei;
  summa[3]=iceb_tu_okrug(summa[3],0.01);  
  
  
  double kol_vod=0;
  double kol_stok=0;
  float tarif_vod=0.;
  float tarif_stok=0.;

  if(atoi(row[13]) == 0) /*нет счётчика воды*/
   {  
    summa[4]=voda_kolih_b_sh*voda_cena_b_sh*kolih_gitelei;  
    summa[5]=stoki_kolih_b_sh*stoki_cena_b_sh*kolih_gitelei;

    kol_vod=voda_kolih_b_sh;
    tarif_vod=voda_cena_b_sh;
    kol_stok=stoki_kolih_b_sh;
    tarif_stok=stoki_cena_b_sh;
   }
  else /*есть счёичик воды*/
   {
    summa[4]=voda*voda_cena_po_sh;
    summa[5]=voda*stoki_cena_po_sh;

    kol_vod=voda;
    tarif_vod=voda_cena_po_sh;
    kol_stok=voda;
    tarif_stok=stoki_cena_po_sh;
   }   

  summa[4]=iceb_tu_okrug(summa[4],0.01);
  summa[5]=iceb_tu_okrug(summa[5],0.01);


  summa[6]=ps*elek;

  summa[7]=musor_cena*musor_kolih*kolih_gitelei;
  
  
  summa[8]=summa[0]+summa[1]+summa[2]+summa[3]+summa[4]+summa[5]+summa[6]+summa[7];

  raskus_zap_opl(row[0],row[1],mr,gr,summa); /*запись в таблицу оплат*/
 
 
 
  for(int nom=0; nom < ITOGO_SUMA ; nom++)
   {
    isumma[nom]+=summa[nom];
    isummad[nom]+=summa[nom];
   }

  fprintf(fil_ff.ff,"%-7s %-5s %-*s %-*.*s %4d %7.2f %7.2f %7.2f %10d %6.2f   %9.2f %8.2f %9.2f %9.2f %8.2f %8.2f %8.2f %7.2f %9.2f\n",
  row[0],row[1],
  iceb_tu_kolbait(6,row[10]),
  row[10],
  iceb_tu_kolbait(35,row[2]),
  iceb_tu_kolbait(35,row[2]),
  row[2],
  atoi(row[3]), atof(row[4]),atof(row[5]),atof(row[11]), ps,voda,
  summa[0],summa[1],summa[2],summa[3],summa[4],summa[5],summa[6],summa[7],summa[8]);

  ish_dan_dom[0]+=atof(row[3]);
  ish_dan_dom[1]+=atof(row[4]);
  ish_dan_dom[2]+=atof(row[5]);
  ish_dan_dom[3]+=atof(row[11]);

  ish_dan_dom[4]+=ps;
  ish_dan_dom[5]+=voda;

  ish_dan[0]+=atof(row[3]);
  ish_dan[1]+=atof(row[4]);
  ish_dan[2]+=atof(row[5]);
  ish_dan[3]+=atof(row[11]);
  if (row[6][0] == '1')
    ish_dan[4]+=1.;

  ish_dan[5]+=ps;
  ish_dan[6]+=voda;

 
 

#if 0
##############################
  #define RAZMER_LG 5
  double lgoti[RAZMER_LG];
  memset(lgoti,'\0',sizeof(lgoti));
    
  /*читаем льготы по квартире*/
  sprintf(strsql,"select ub,op,ee,vd,gz from Kuslg where nd=%s and nk='%s' and dt <= '%04d-%02d-01' order by dt desc limit 1",row[0],row[1],gr,mr);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
   {
    for(int nom=0; nom < RAZMER_LG; nom++)
      lgoti[nom]=atof(row1[nom]);
   }    
############################
#endif

  nomshet1.new_plus("");
  nomshet2.new_plus("");  
  
  if(datdok.getdlinna() > 1) /*Создание документов*/
   {
    sprintf(strsql,"Наші послуги за %02d.%04d р. Дом %s Кв. %s",mr,gr,row[0],row[1]);
    class iceb_tu_str osnov1(strsql);

    sprintf(strsql,"Сторонні послуги за %02d.%04d р. Дом %s Кв. %s",mr,gr,row[0],row[1]);
    class iceb_tu_str osnov2(strsql);
   
       
    if(raskus_ud(md,gd,osnov1.ravno()) != 0)
     return;
    if(raskus_ud(md,gd,osnov2.ravno()) != 0)
     return;


    class iceb_tu_str nomdok("");
    /*создаём документ на услуги которые оказывает организация*/
    class iceb_t_lock_tables kkkk("LOCK TABLES Usldokum WRITE");

    iceb_t_nomnak(datdok.ravno_god(),kodusl.kod_podr.ravno(),&nomdok,2,1,0);

    nomshet1.new_plus(nomdok.ravno());

    sprintf(strsql,"insert into Usldokum (tp,datd,podr,kontr,nomd,kodop,nds,ktoi,vrem,pn,osnov)\
 values(2,'%s',%d,'%s','%s','%s',%d,%d,%ld,%.2f,'%s')",
    datdok.ravno_sqldata(),kodusl.kod_podr.ravno_atoi(),row[10],nomdok.ravno(),kodusl.kodop.ravno(),mnds,
    getuid(),time(NULL),pnds,osnov1.ravno());
    
    if(iceb_t_sql_zapis(strsql,1,0) != 0)
     continue;
    
    kkkk.unlock();

    printw("Номер документа-%s\n",nomdok.ravno());
    refresh();
    if(summa[0] != 0.) /*Квартирная плата*/
     {    
      kolih=1.;
      cena=summa[0];        
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_kp.ravno_atoi(),kolih,cena,kodusl.kod_kp_ei.ravno(),kodusl.kod_kp_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_kp_ss.ravno(),dopol);

     }

    if(summa[1] != 0.) /*Отопление*/
     {    
      cena=summa[1];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_ot.ravno_atoi(),kolih,cena,kodusl.kod_ot_ei.ravno(),kodusl.kod_ot_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_ot_ss.ravno(),dopol);

     }

    /*подтверждаем записи в документе*/
    uslpoddok(dd,md,gd,dd,md,gd,nomdok.ravno(),kodusl.kod_podr.ravno_atoi(),2,1);
    /*Проверка подтверждения документа*/
    podudok(dd,md,gd,nomdok.ravno(),kodusl.kod_podr.ravno_atoi(),2);

    prosprus(1,kodusl.kod_podr.ravno_atoi(),dd,md,gd,nomdok.ravno(),2,mnds,kodusl.kodop.ravno(),pnds);
    /*Выполнение проводок*/
    avtprousl1(2,dd,md,gd,nomdok.ravno(),NULL);

    /*Проверка выполнения проводок*/

    prosprus(0,kodusl.kod_podr.ravno_atoi(),dd,md,gd,nomdok.ravno(),2,mnds,kodusl.kodop.ravno(),pnds);

    /*создаём документ на услуги которые оказывают сторонние организации*/
    kkkk.lock("LOCK TABLES Usldokum WRITE");

    iceb_t_nomnak(datdok.ravno_god(),kodusl.kod_podr.ravno(),&nomdok,2,1,0);

    nomshet2.new_plus(nomdok.ravno());

    sprintf(strsql,"insert into Usldokum (tp,datd,podr,kontr,nomd,kodop,nds,ktoi,vrem,pn,osnov)\
 values(2,'%s',%d,'%s','%s','%s',%d,%d,%ld,%.2f,'%s')",
    datdok.ravno_sqldata(),kodusl.kod_podr.ravno_atoi(),row[10],nomdok.ravno(),kodusl.kodop.ravno(),mnds,
    getuid(),time(NULL),pnds,osnov2.ravno());
    
    if(iceb_t_sql_zapis(strsql,1,0) != 0)
     continue;

    printw("Номер документа-%s\n",nomdok.ravno());
    
    kkkk.unlock();

    if(summa[2] != 0.) /*Газ*/
     {    
      cena=summa[2];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_gaz.ravno_atoi(),kolih,cena,kodusl.kod_gaz_ei.ravno(),kodusl.kod_gaz_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_gaz_ss.ravno(),dopol);

     }

    if(summa[3] != 0.) /*Распределение газа*/
     {    
      cena=summa[3];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_r_gaz.ravno_atoi(),kolih,cena,kodusl.kod_r_gaz_ei.ravno(),kodusl.kod_r_gaz_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_r_gaz_ss.ravno(),dopol);

     }
 

    if(summa[4] != 0.) /*Вода*/
     {    
      cena=summa[4];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_vod.ravno_atoi(),kolih,cena,kodusl.kod_vod_ei.ravno(),kodusl.kod_vod_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_vod_ss.ravno(),dopol);

     }
    if(summa[5] != 0.) /*Стоки*/
     {    
      cena=summa[5];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_stoki.ravno_atoi(),kolih,cena,kodusl.kod_stoki_ei.ravno(),kodusl.kod_stoki_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_stoki_ss.ravno(),dopol);

     }

    if(summa[6] != 0.) /*Електричество*/
     {
      cena=summa[6];
      kolih=1.;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.kod_el.ravno_atoi(),kolih,cena,kodusl.kod_el_ei.ravno(),kodusl.kod_el_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.kod_el_ss.ravno(),dopol);
     }

    if(summa[7] != 0.) //Мусор
     {    
      cena=summa[7];
      kolih=1;
      if(cena > 0.)
       zapuvdok(2,dd,md,gd,nomdok.ravno(),1,kodusl.musor.ravno_atoi(),kolih,cena,kodusl.musor_ei.ravno(),kodusl.musor_su.ravno(),kodusl.kod_podr.ravno_atoi(),kodusl.musor_ss.ravno(),dopol);

     }

    /*подтверждаем записи в документе*/
    uslpoddok(dd,md,gd,dd,md,gd,nomdok.ravno(),kodusl.kod_podr.ravno_atoi(),2,1);
    /*Проверка подтверждения документа*/
    podudok(dd,md,gd,nomdok.ravno(),kodusl.kod_podr.ravno_atoi(),2);

    prosprus(1,kodusl.kod_podr.ravno_atoi(),dd,md,gd,nomdok.ravno(),2,mnds,kodusl.kodop.ravno(),pnds);
    /*Выполнение проводок*/
    avtprousl1(2,dd,md,gd,nomdok.ravno(),NULL);

    /*Проверка выполнения проводок*/

    prosprus(0,kodusl.kod_podr.ravno_atoi(),dd,md,gd,nomdok.ravno(),2,mnds,kodusl.kodop.ravno(),pnds);
    
   }



  ku_saldo(row[0],row[1],mr,gr,summa_saldo,oplata_mr,ITOGO_SUMA); /*узнаём сальдо на начало месца и оплату в месце*/
/*********************
  printw("\n%s-",__FUNCTION__);
  for(int nom=0; nom < ITOGO_SUMA; nom++)
   printw(" %f",summa_saldo[nom]);  

  printw("\n%s-",__FUNCTION__);
  for(int nom=0; nom < ITOGO_SUMA; nom++)
   printw(" %f",oplata_mr[nom]);  
  printw("\n");    
  OSTANOV();

*****************/

  /*формирование распечатки счетов*/
//  double deb=0.,kre=0.;
//  double saldon=0.;  
  double ioplata=0.;
//  double oplata=0.;
  double k_oplate=0.; 
 // double suma_opl=0.;
  
  for(int nom=0; nom <= SHET_ITOGO; nom++)
    shet_itogo[nom]=0.;

  if(nomer_sh > 0)
   fprintf(fil_sh.ff,"\f");
  nomer_sh++;

  fprintf(fil_sh.ff,"\
                         Рахунок %s\n\
            по утриманню будинку за %d.%d р.\n\n\
Платник: %s\n",nomshet1.ravno(),mr,gr,naimkon.ravno());
  fprintf(fil_sh.ff,"\n\
Одержувач: Вінницький фаховий коледж НУХТ\n\
Код:35725833 МФО:820172\n\
Банк одержувача: Державна казначейська служба України\n\
Рахунок:UA648201720313271004202007918\n");   

  /*узнаём сальдо*/
 
    


  fprintf(fil_sh.ff,"\
-----------------------------------------------------------------------------------\n");
  fprintf(fil_sh.ff,"\
Найменування послуги| Тариф |  Об'єм  |   Борг   |Нараховано|  Оплата  | До оплати|\n");
//                   1234567 123456789 1234567890 1234567890 1234567890 1234567890
  fprintf(fil_sh.ff,"\
-----------------------------------------------------------------------------------\n");

/*****************************
  memset(strsql,'\0',sizeof(strsql));
  salork(shin.ravno(),row[10],&deb,&kre,0,strsql,strsql,"\0",1,1,grs,31,mrs,grs,"\0",0,strsql,strsql);
  saldon=deb-kre;
  sprintf(strsql,"Сальдо на 01.%02d.%04d",mr,gr);
  fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(38,strsql),strsql,saldon);
  fprintf(fil_sh.ff,"\
--------------------------------------------------\n");
*********************************************/  

  


  double obem=atof(row[4])+atof(row[5])+atof(row[11]);
  double tarif=kvartp;

  k_oplate=summa_saldo[0]+summa[0]+oplata_mr[0];

  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Утримання будинку"),"Утримання будинку",
  tarif,
  obem,
  summa_saldo[0],
  summa[0],
  oplata_mr[0],
  k_oplate);

  shet_itogo[0]+=summa_saldo[0];
  shet_itogo[1]+=summa[0];
  shet_itogo[2]+=oplata_mr[0];
  shet_itogo[3]+=k_oplate;


  k_oplate=summa[1]+summa_saldo[1]+oplata_mr[1];
  obem=atof(row[5])+atof(row[4]);
  ioplata+=k_oplate;   
  tarif=otop;
  
  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Опалення"),"Опалення",
  tarif,
  obem,
  summa_saldo[1],
  summa[1],
  oplata_mr[1],
  k_oplate);
 
  
  shet_itogo[0]+=summa_saldo[1];
  shet_itogo[1]+=summa[1];
  shet_itogo[2]+=oplata_mr[1];
  shet_itogo[3]+=k_oplate;



  fprintf(fil_sh.ff,"\
-----------------------------------------------------------------------------------\n");
//  fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(f1,"Разом"),"Разом",ioplata);  
  fprintf(fil_sh.ff,"%*s|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(38,"Разом"),
  "Разом",  
  shet_itogo[0],
  shet_itogo[1],
  shet_itogo[2],
  shet_itogo[3]);
  
//  double saldok=0.;

/*******************
  suma_opl=raskus_so(shin.ravno(),row[10],mr,gr);

  fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(38,"Оплачено"),"Оплачено",suma_opl);
  saldok=saldon+ioplata-suma_opl;

  if(saldok > 0.)
   fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(38,"До оплати"),"До оплати",saldok);
  else
   fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(38,"Сальдо"),"Сальдо",saldok);
*********************/
     
  for(int nom=0; nom <= SHET_ITOGO; nom++)
    shet_itogo[nom]=0.;


  fprintf(fil_sh.ff,"\n\n\
                         Рахунок %s\n\
             по комунальних послугах за %d.%d р.\n\n\
Платник: %s\n",nomshet2.ravno(),mr,gr,naimkon.ravno());
  fprintf(fil_sh.ff,"\n\
Одержувач: Вінницький фаховий коледж НУХТ\n\
Код:35725833 МФО:820172\n\
Банк одержувач: Державна казначейська служба України\n\
Рахунок:UA318201720343191004200007918\n");   
  
  

  fprintf(fil_sh.ff,"\
----------------------------------------------------------------------------------------\n");
  fprintf(fil_sh.ff,"\
Найменування послуги| Тариф |  Об'єм  |К.м.|   Борг   |Нараховано|  Оплата  | До оплати|\n");
  fprintf(fil_sh.ff,"\
----------------------------------------------------------------------------------------\n");



  /*узнаём сальдо*/
/*****************************
  memset(strsql,'\0',sizeof(strsql));
  deb=kre=0.;
  salork(shout.ravno(),row[10],&deb,&kre,0,strsql,strsql,"\0",1,1,grs,31,mrs,grs,"\0",0,strsql,strsql);
  saldon=deb-kre;
  sprintf(strsql,"Сальдо на 01.%02d.%04d",mr,gr);
  fprintf(fil_sh.ff,"\
%*s|%10.2f|\n",iceb_tu_kolbait(43,strsql),strsql,saldon);

  fprintf(fil_sh.ff,"\
-------------------------------------------------------\n");

***************************/


  ioplata=0.;

  k_oplate=summa[2]+summa_saldo[2]+oplata_mr[2];
  tarif=gaz_cena;
  obem=gaz_kolih;
  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4d|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Газ"),"Газ",
  tarif,
  obem,
  kolih_gitelei,
  summa_saldo[2],
  summa[2],
  oplata_mr[2],
  k_oplate);

  shet_itogo[0]+=summa_saldo[2];
  shet_itogo[1]+=summa[2];
  shet_itogo[2]+=oplata_mr[2];
  shet_itogo[3]+=k_oplate;


  k_oplate=summa[3]+summa_saldo[3]+oplata_mr[3];
  tarif=gaz_r_cena;
  obem=gaz_r_kolih;
  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4d|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Розподіл газу"),"Розподіл газу",
  tarif,
  obem,
  kolih_gitelei,
  summa_saldo[3],
  summa[3],
  oplata_mr[3],
  k_oplate);

  shet_itogo[0]+=summa_saldo[3];
  shet_itogo[1]+=summa[3];
  shet_itogo[2]+=oplata_mr[3];
  shet_itogo[3]+=k_oplate;


  k_oplate=summa[4]+summa_saldo[4]+oplata_mr[4];
  tarif=tarif_vod;
  obem=kol_vod;
  ioplata+=k_oplate;   


  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4d|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Вода"),"Вода",
  tarif,
  obem,
  kolih_gitelei,
  summa_saldo[4],
  summa[4],
  oplata_mr[4],
  k_oplate);

  shet_itogo[0]+=summa_saldo[4];
  shet_itogo[1]+=summa[4];
  shet_itogo[2]+=oplata_mr[4];
  shet_itogo[3]+=k_oplate;

  k_oplate=summa[5]+summa_saldo[5]+oplata_mr[5];
  tarif=tarif_stok;
  obem=kol_stok;
  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4d|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Стоки"),"Стоки",
  tarif,
  obem,
  kolih_gitelei,
  summa_saldo[5],
  summa[5],
  oplata_mr[5],
  k_oplate);

  shet_itogo[0]+=summa_saldo[5];
  shet_itogo[1]+=summa[5];
  shet_itogo[2]+=oplata_mr[5];
  shet_itogo[3]+=k_oplate;


  k_oplate=summa[6]+summa_saldo[6]+oplata_mr[6];
  tarif=elek;
  obem=ps;
  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4s|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Електроенергія"),"Електроенергія",
  tarif,
  obem,
  "",
  summa_saldo[6],
  summa[6],
  oplata_mr[6],
  k_oplate);


  shet_itogo[0]+=summa_saldo[6];
  shet_itogo[1]+=summa[6];
  shet_itogo[2]+=oplata_mr[6];
  shet_itogo[3]+=k_oplate;


  k_oplate=summa[7]+summa_saldo[7]+oplata_mr[7];
  tarif=musor_cena;
  obem=musor_kolih;
  ioplata+=k_oplate;   

  fprintf(fil_sh.ff,"%-*s|%7.3f|%9.3f|%4d|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(20,"Вивезення ТПВ"),"Вивезення ТПВ",
  tarif,
  obem,
  kolih_gitelei,
  summa_saldo[7],
  summa[7],
  oplata_mr[7],
  k_oplate);

  shet_itogo[0]+=summa_saldo[7];
  shet_itogo[1]+=summa[7];
  shet_itogo[2]+=oplata_mr[7];
  shet_itogo[3]+=k_oplate;



  fprintf(fil_sh.ff,"\
----------------------------------------------------------------------------------------\n");
//  fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(76,"Разом"),"Разом",ioplata);  
  fprintf(fil_sh.ff,"%*s|%10.2f|%10.2f|%10.2f|%10.2f|\n",
  iceb_tu_kolbait(43,"Разом"),
  "Разом",  
  shet_itogo[0],
  shet_itogo[1],
  shet_itogo[2],
  shet_itogo[3]);

/*****************
  suma_opl=raskus_so(shout.ravno(),row[10],mr,gr);

  fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(43,"Оплачено"),"Оплачено",suma_opl);
  saldok=0.;
  saldok=saldon+ioplata-suma_opl;
  if(saldok > 0.)
   fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(43,"До оплати"),"До оплати",saldok);
  else
   fprintf(fil_sh.ff,"%*s|%10.2f|\n",iceb_tu_kolbait(43,"Сальдо"),"Сальдо",saldok);
**********************/
 }

fprintf(fil_ff.ff,"ICEB_LST_END\n");


raskus_itogo("Разом по дому",ish_dan_dom,isummad,fil_ff.ff);

raskus_itogo("Загальний підсумок",ish_dan,isumma,fil_ff.ff);

iceb_t_podpis(fil_ff.ff);



fil_ff.end();
fil_sh.end();

if(datdok.getdlinna() > 1)
 OSTANOV();
class spis_oth oth;
oth.spis_imaf.plus(imaf);
oth.spis_naim.plus("Разрахунок комунальних послуг");
oth.spis_imaf.plus(imaf_sh);
oth.spis_naim.plus("Рахунки");



iceb_t_ustpeh(oth.spis_imaf.ravno(0),3,&kolstr);
iceb_t_rnl(oth.spis_imaf.ravno(0),kolstr,"",&raskus_hap);

iceb_t_ustpeh(oth.spis_imaf.ravno(1),3);

iceb_t_rabfil(&oth,"");

}


/***************************/
/*Чтение настроек*/
/************************/
int raskus_rn(class raskus_nast *kodusl)
{
char strsql[512];
SQL_str row;
class SQLCURSOR cur;

char stroka[1024];
FILE *ff;

if(iceb_t_alxout("kusnast.alx") != 0)
 return(1);

if((ff=fopen("kusnast.alx","r")) == NULL)
 {
  error_op_nfil("kusnast.alx",errno,0);
  return(1);
 }

while(fgets(stroka,sizeof(stroka),ff) != NULL)
 {
  if(stroka[0] == '#')
   continue;

  if(iceb_tu_SRAV("Код оплаты за квартиру|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_kp,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_kp_ss,3,'|');

    
   }
  if(iceb_tu_SRAV("Код oплаты за отопление|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_ot,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_ot_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за газ|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_gaz,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_gaz_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за распределение газа|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_r_gaz,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_r_gaz_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за воду|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_vod,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_vod_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за стоки|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_stoki,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_stoki_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за електричество|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_el,2,'|');
    iceb_tu_polen(stroka,&kodusl->kod_el_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код оплаты за мусор|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->musor,2,'|');
    iceb_tu_polen(stroka,&kodusl->musor_ss,3,'|');
   }
  if(iceb_tu_SRAV("Код операции|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kodop,2,'|');
   }
  if(iceb_tu_SRAV("Код подразделения|",stroka,1) == 0)
   {
    iceb_tu_polen(stroka,&kodusl->kod_podr,2,'|');
   }
 }

fclose(ff);
unlink("kusnast.alx");


sprintf(strsql,"select kod from Usloper2 where kod='%s'",kodusl->kodop.ravno());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
  {
   sprintf(strsql,"Не найден код операции %s !",kodusl->kodop.ravno());
  iceb_t_soob(strsql);
   return(1);
  }

sprintf(strsql,"select kod from Uslpodr where kod=%d",kodusl->kod_podr.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
  {
   sprintf(strsql,"Не найден код подразделения %d !",kodusl->kod_podr.ravno_atoi());
  iceb_t_soob(strsql);
   return(1);
  }

/*кварт-плата*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_kp.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_kp.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_kp.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_kp.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
OPSHET reksh;
if(kodusl->kod_kp_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_kp_ss.ravno(),&reksh) != 0)
 return(1);

kodusl->kod_kp_ei.new_plus(row[0]);
kodusl->kod_kp_su.new_plus(row[1]);


/*отопление*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_ot.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_ot.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_ot.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_ot.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(kodusl->kod_ot_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_ot_ss.ravno(),&reksh) != 0)
 return(1);

kodusl->kod_ot_ei.new_plus(row[0]);
kodusl->kod_ot_su.new_plus(row[1]);


/*газ*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_gaz.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_gaz.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_gaz.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_gaz.ravno());
  iceb_t_soob(strsql);
  return(1);
 }



if(kodusl->kod_gaz_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_gaz_ss.ravno(),&reksh) != 0)
 return(1);
kodusl->kod_gaz_ei.new_plus(row[0]);
kodusl->kod_gaz_su.new_plus(row[1]);

/*Распределение газа*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_r_gaz.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_r_gaz.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_r_gaz.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_r_gaz.ravno());
  iceb_t_soob(strsql);
  return(1);
 }



if(kodusl->kod_r_gaz_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_r_gaz_ss.ravno(),&reksh) != 0)
 return(1);
kodusl->kod_r_gaz_ei.new_plus(row[0]);
kodusl->kod_r_gaz_su.new_plus(row[1]);


/*вода*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_vod.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_vod.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_vod.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_vod.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(kodusl->kod_vod_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_vod_ss.ravno(),&reksh) != 0)
 return(1);
kodusl->kod_vod_ei.new_plus(row[0]);
kodusl->kod_vod_su.new_plus(row[1]);

/*стоки*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_stoki.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_stoki.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_stoki.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_stoki.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(kodusl->kod_stoki_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->kod_stoki_ss.ravno(),&reksh) != 0)
 return(1);
kodusl->kod_stoki_ei.new_plus(row[0]);
kodusl->kod_stoki_su.new_plus(row[1]);


/*мусор*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->musor.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->musor.ravno_atoi());
  iceb_t_soob(strsql);
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->musor.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->musor.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(kodusl->musor_ss.getdlinna() > 1)
if(iceb_t_prsh1(kodusl->musor_ss.ravno(),&reksh) != 0)
 return(1);
kodusl->musor_ei.new_plus(row[0]);
kodusl->musor_su.new_plus(row[1]);


/*Електроэнергия*/
sprintf(strsql,"select ei,shetu from Uslugi where kodus=%d",kodusl->kod_el.ravno_atoi());
if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не найден код услуги %d!",kodusl->kod_el.ravno_atoi());
  iceb_t_soob(strsql);
  
  return(1);
 }

if(row[0][0] == '\0')
 {
  sprintf(strsql,"Не введена единица измерения для услуги %s !",kodusl->kod_el.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(row[1][0] == '\0')
 {
  sprintf(strsql,"Не введён счёт учёта для услуги %s !",kodusl->kod_el.ravno());
  iceb_t_soob(strsql);
  return(1);
 }
if(kodusl->kod_el_ss.getdlinna() > 1)
 if(iceb_t_prsh1(kodusl->kod_el_ss.ravno(),&reksh) != 0)
  return(1);
kodusl->kod_el_ei.new_plus(row[0]);
kodusl->kod_el_su.new_plus(row[1]);

return(0);
}

/*********************************************/
/*определяем сумму оплаты*/
/*************************************/
double raskus_so(const char *shet,const char *kontr,short mr,short gr)
{
char strsql[1024];
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;
double suma=0.;
sprintf(strsql,"select kre from Prov where val=0 and datp >= '%04d-%02d-01' and datp <= '%04d-%02d-31' and \
sh='%s' and kodkon='%s' and kre <> 0.",gr,mr,gr,mr,shet,kontr);


//printw("%s-%s\n",__FUNCTION__,strsql);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,__FUNCTION__,strsql);
  return(0.);
 }
if(kolstr == 0)
  return(0.);


while(cur.read_cursor(&row) != 0)
 {
//  printw("%s-%s\n",__FUNCTION__,row[0]);
  
  suma+=atof(row[0]);
 }
return(suma);
}
/*******************************************/
/*Удаление документов*/
/*****************************************/
int raskus_ud(short mr,short gr,const char *osnov)
{

char strsql[1024];
int kolstr=0.;
SQL_str row;
class SQLCURSOR cur;
short d=0,m=0,g=0;
sprintf(strsql,"select datd,podr,nomd,tp from Usldokum where datd >= '%04d-%02d-01' and datd <= '%04d-%02d-31' \
and osnov='%s'",gr,mr,gr,mr,osnov);
//printw("%s-%s\n",__FUNCTION__,strsql);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,__FUNCTION__,strsql);
  return(1);
 }
printw("%s-kolstr=%d\n",__FUNCTION__,kolstr);
refresh();
if(kolstr == 0)
  return(0); 

while(cur.read_cursor(&row) != 0)
 {
//  printw("Удаляем документ %s %s\n",iceb_tu_datzap(row[0]),row[2]);
  iceb_tu_rsdat(&d,&m,&g,row[0],2);
  if(iceb_t_udprgr(gettext("УСЛ"),d,m,g,row[2],atoi(row[1]),atoi(row[3])) != 0)
   return(1);       
  if(uduvdok(atoi(row[3]),d,m,g,row[2],atoi(row[1]),0,0,0) != 0)
   return(1);
 }

return(0);
}
/***********************************/
/*распечатка строки итога*/
/*********************************/

void raskus_itogo(const char *koment,double *ish_dan_dom,double *summa,FILE *ff)
{

fprintf(ff,"\
--------------------------------------------------------------------------------------------------------- ------------------------------------------------------------------------------------\n");

fprintf(ff,"%*s %4.4g %7.2f %7.2f %7.2f %10.10g %6.2f   %9.2f %8.2f %9.2f %9.2f %8.2f %8.2f %8.2f %7.2f %9.2f\n\n",
iceb_tu_kolbait(56,koment), 
koment, 
ish_dan_dom[0],ish_dan_dom[1],ish_dan_dom[2],ish_dan_dom[3],ish_dan_dom[4],ish_dan_dom[5],
summa[0], summa[1], summa[2], summa[3],
summa[4], summa[5], summa[6],summa[7],summa[8]);

memset(ish_dan_dom,'\0',sizeof(double)*ITOGO_DOM);

}

/*****************************************************/
/*запись расчитанных комунальных услуг в таблицу оплат*/
/*****************************************************/

int raskus_zap_opl(char *nom_dom,char *nom_kv,
short mn,short gn,double *suma)
{
char strsql[1024];

sprintf(strsql,"delete from Kuoplata where nd='%s' and nk='%s' and dt='%04d-%02d-%02d' and pr=1",
nom_dom,nom_kv,gn,mn,1);
if(iceb_t_sql_zapis(strsql,1,0) != 0)
  return(1);


sprintf(strsql,"INSERT INTO Kuoplata (nd,nk,dt,pr,ub,op,ee,vd,gz,rgz,st,mus,ktoi,vrem) \
values ('%s','%s','%d-%d-%d',%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%d,%ld)",
nom_dom,
nom_kv,
gn,mn,1,
1,
suma[0],
suma[1],
suma[6],
suma[4],
suma[2],
suma[3],
suma[5],
suma[7],
iceb_t_getuid(),
time(NULL));

if(iceb_t_sql_zapis(strsql,1,0) != 0)
  return(1);

return(0);

}

/*************************************/
void raskus_hap(int nomlst,int *kolstr,FILE *ff)
{
fprintf(ff,"\
-------------------------------------------------------------------------------------------------------- -------------------------------------------------------------------------------------\n\
N Дома |N кв |Контр.|  Прізвище, І'мя, По-батькові      |К.ж.|Пл. кв.|Пл.кух.|Пл.бал.|Ел.лічільн| Вода | |Утрим.буд|Опалення|   Газ   |Розп.газу|  Вода  | Стоки  |Електрі.|  ТПВ  |  РАЗОМ  |\n\
-------------------------------------------------------------------------------------------------------- -------------------------------------------------------------------------------------\n");
}
