/*29.03.2023	10.06.2004	Белых 	kusnast.c
Чтение настроек
*/

#include <locale.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <iceb.h>
#include <buhg.h>

extern SQL_baza	bd;
extern char		*imabaz;
extern char		*putnansi;

float kvartp=0.; //квартирная плата
float otop=0.;   //отопление

float gaz_cena=0.;     /*цена газа*/
float gaz_kolih=0.;    /*Объём газа*/
float gaz_r_cena=0.;   /*цена распределения газа*/
float gaz_r_kolih=0.;  /*Объём распределения газа*/

float voda_cena_b_sh=0.; /*цена воды без счётчика*/
float voda_kolih_b_sh=0.; /*количество воды без счётчика*/
float voda_cena_po_sh=0.; /*цена воды по счётчику*/

float stoki_cena_b_sh=0.;  /*цена стока без счётчика*/
float stoki_kolih_b_sh=0.; /*количество стока без счётчика*/
float stoki_cena_po_sh=0.; /*цена стока по счётчику*/

float elek=0.;   //електроенергия
float musor_cena=0.;       /*цена вывоза мусора на 1 человека*/
float musor_kolih=0.;

class iceb_tu_str shin; /*Счёт сальдо по услугам оказанных организацией*/
class iceb_tu_str shout; /*Счёт сальдо услугам оказанных другими организациями*/

short		vplsh=1; /*0-двух уровневый план счетов 1-многоуровневый*/
short		startgodb=0; /*Стартовый год главной книги*/

int kusnast ()
{
SQL_str rowalx;
class SQLCURSOR curalx;
int kolstr=0;
char strsql[512];
char st1[1024];

startgodb=0;
vplsh=1;


sprintf(strsql,"select str from Alx where fil='%s' order by ns asc","kusnast.alx");

if((kolstr=curalx.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,"",strsql);
  return(1);
 }  

if(kolstr == 0)
 {
  sprintf(strsql,"%s %s",gettext("Не найден файл"),"kusnast.alx");
  iceb_t_soob(strsql);
  return(1);
 }

while(curalx.read_cursor(&rowalx) != 0)
 {
  if(rowalx[0][0] == '#')
   continue;
  printw("%s",rowalx[0]);
  refresh();
    
  iceb_tu_polen(rowalx[0],st1,sizeof(st1),1,'|');

  if(iceb_tu_SRAV(st1,"Квартирная плата",0) == 0)
   {
    iceb_tu_polen(rowalx[0],st1,sizeof(st1),2,'|');
    kvartp=iceb_tu_atof(st1);
    continue;
   }

  if(iceb_tu_SRAV(st1,"Отопление",0) == 0)
   {
    iceb_tu_polen(rowalx[0],st1,sizeof(st1),2,'|');
    otop=iceb_tu_atof(st1);
    continue;
   }

  if(iceb_tu_SRAV(st1,"Цена газа",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&gaz_cena,2,'|');
    continue;
   }
  if(iceb_tu_SRAV(st1,"Объём газа",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&gaz_kolih,2,'|');
    continue;
   }

  if(iceb_tu_SRAV(st1,"Цена распределения газа",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&gaz_r_cena,2,'|');
    continue;
   }
  if(iceb_tu_SRAV(st1,"Объём распределения газа",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&gaz_r_kolih,2,'|');
    continue;
   }

  if(iceb_tu_SRAV(st1,"Цена воды без счётчика",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&voda_cena_b_sh,2,'|');
    continue;
   }
  if(iceb_tu_SRAV(st1,"Объём воды без счётчика",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&voda_kolih_b_sh,2,'|');
    continue;
   }
 if(iceb_tu_SRAV(st1,"Цена воды по счётчику",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&voda_cena_po_sh,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Цена стоков по счётчику",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&stoki_cena_po_sh,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Цена стоков без счётчика",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&stoki_cena_b_sh,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Объём стоков без счётчика",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&stoki_kolih_b_sh,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Электроэнергия",0) == 0)
   {
    iceb_tu_polen(rowalx[0],st1,sizeof(st1),2,'|');
    elek=iceb_tu_atof(st1);
    continue;
   }


 if(iceb_tu_SRAV(st1,"Цена стоков по счётчику",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&stoki_cena_po_sh,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Цена вывоза мусора",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&musor_cena,2,'|');
    continue;
   }
 if(iceb_tu_SRAV(st1,"Объём вывоза мусора",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&musor_kolih,2,'|');
    continue;
   }

 if(iceb_tu_SRAV(st1,"Счёт сальдо 1",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&shin,2,'|');
    continue;
   }
 if(iceb_tu_SRAV(st1,"Счёт сальдо 2",0) == 0)
   {
    iceb_tu_polen(rowalx[0],&shout,2,'|');
    continue;
   }


 }

if(iceb_t_poldan("Многопорядковый план счетов",st1,"nastb.alx") == 0)
 {
 if(iceb_tu_SRAV(st1,"Вкл",1) == 0)
  vplsh=1;
 else
  vplsh=0;
 }
if(iceb_t_poldan("Стартовый год",st1,"nastb.alx") == 0)
 startgodb=atoi(st1);
   
return(0);
}


