/*$Id:$*/
/*07.07.2025	31.03.2023	Белых 	ku_oplata.cpp

*/
#include <iceb.h>
#include <buhg.h>
#include <errno.h>

class poisk
{
 public:
 class iceb_tu_str nomd;  // Номер дома
 class iceb_tu_str nomk;   // Номер квартиры
 class iceb_tu_str datan;   // Дата
 class iceb_tu_str datak;   // Дата
 class iceb_tu_str pr_rs; /*"+" только приходы "-" только расходы*/
 short mp;       // 0 - Не искать, 1 - Искать

 char zapros[1024]; 

 
 
 poisk()
  {
   clear();
  }

 void clear()
  {
   nomd.new_plus("");
   nomk.new_plus("");
   datan.new_plus("");
   datak.new_plus("");
   pr_rs.new_plus("");
   memset(zapros,'\0',sizeof(zapros));   
   mp=0;
  } 
};

void ku_oplata_udzap(SQLCURSOR *cur);
void ku_oplata_ud(int nom_zap);
void ku_oplata_poi(class poisk*);
void ku_oplatas(class poisk*);
int ku_oplata_v(int metka,int nom_zap);
void ku_oplata_rs(SQLCURSOR *cur,class poisk *data);
extern SQL_baza	bd;

void ku_oplata()
{
static class poisk qw;
int pozz=0,pozz1=0,K=0;
char strsql[1024];
int kolstr;
SQL_str row;
short		mspz=0; /*метка соответствия первой записи*/
int i=0;
short dz,mz,gz;
int kom=0;
short           x=0,y=2;
int prc=0;
char nomkvrt[20];
char nomd[20];
class iceb_t_mstr spis_menu(0);
char prih_rash[2];

SQLCURSOR curr;
VVOD VV(0);

VVOD SOOB(1);

naz1:;

GDITE();
clear();


short kls=LINES-5;
int nom_zap[kls];


if(qw.mp == 0)
 sprintf(strsql,"select * from Kuoplata order by dt desc,nd asc,nk asc");
else 
 strcpy(strsql,qw.zapros); 

class SQLCURSOR cur;
if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
if(kolstr == 0)
 {

lll:;

  ku_oplatas(&qw);

  SOOB.VVOD_delete();

  SOOB.VVOD_spisok_add_MD("Не найдено ни одной записи !");
  K=soobshw(&SOOB,stdscr,-1,-1,1,1);
  
  if(K == FK5 || K == SFK2 || K == SFK3 || K == ENTER)
     goto lll;
  if(K == KEY_RESIZE)
   goto naz1;
     
  goto vper;
 }

naz:;
GDITE();
if(kolstr != 0 && pozz >= kolstr)
  pozz = kolstr-1;


cur.poz_cursor(pozz);
mspz=2;
pozz1=0;
spis_menu.spis_str.free_class();
for(i=0; i<kls ; )
 {
  
  if(cur.read_cursor(&row) == 0)
    break;

  pozz1++;

  nom_zap[i]=atoi(row[12]);
  iceb_tu_rsdat(&dz,&mz,&gz,row[2],2);
  
  memset(prih_rash,'\0',sizeof(prih_rash));
  
  if(atoi(row[3]) == 1)  
   prih_rash[0]='+';

  if(atoi(row[3]) == 2)  
   prih_rash[0]='-';
   
  sprintf(strsql,"%s%02d.%02d|%-4s|%-4s|\
%7.6g|%8.6g|%7.6g|%7.6g|%6.6g|%6.6g|%7.6g|%6.6g",
  prih_rash,
  mz,gz,
  row[0],row[1],
  atof(row[4]),atof(row[5]),atof(row[6]),atof(row[7]),
  atof(row[8]),atof(row[9]),atof(row[10]),atof(row[11]));

  spis_menu.spis_str.plus(strsql);
  i++;
    
  if(pozz1 == 1) /*Первая запись удовлетворяет условиям поиска*/
   mspz=1;

 }

if(kom >= i)
  kom=i-1;

if(kom < 0)
 kom=0;

if(i <=kls-1)
  spis_menu.spis_str.plus(gettext("Конец списка"));

if(i == 0)
 {
  if(kolstr != 0 && pozz != 0)
   {
    //Если записи есть но не подходят по условиям поиска
    pozz--;
    goto naz;
   }
  goto lll;
 }


ku_oplatas(&qw);

prc=(pozz+pozz1)*100/kolstr;
memset(strsql,'\0',sizeof(strsql));
kom=spis_menu.menu(kom,y,x,NULL,strsql,prc,&K,"",COLS-24);

if(kom == -7) //Изменение размера экрана
  goto naz1;
  
if(kom == -3) /*Стрелка вниз*/
 {
  if(i <kls)
   {
    beep();
    goto naz;
   }
  for(i=0; i< mspz  ; )
   {
    pozz++;
    if(pozz >= kolstr)
     {
      pozz=kolstr-1;
      break;
     }
    cur.poz_cursor(pozz);
    if(cur.read_cursor(&row) == 0)
      break;

    i++;
   }
  kom=kls-1;
  goto naz;
 }
if(kom == -2) /*Стрелка вверх*/
 {
  for(i=0; i < 1 ; )
   {

    pozz--;

    if(pozz <= 0)
     {
      beep();
      pozz=0;
      goto naz;
     }

    cur.poz_cursor(pozz);
    cur.read_cursor(&row);
    i++;
   }

  goto naz;
 }
 
if(kom == -5) /*Страница вниз*/
 {
  if(i <kls)
   {
    beep();
    goto naz;
   }
  if(pozz + kls >= kolstr)
   {
    pozz=kolstr-1;
    beep();
    goto naz;  
   }
  if(i == kls)
    pozz+=pozz1;
  else
    beep();
  if(pozz >= kolstr)
   {
    pozz=kolstr-pozz1;
    beep();
    goto naz;  
   }
  goto naz;

 }

if(kom == -4) /*Страница вверх*/
 {
  GDITE();
  for(i=0; i<kls ; )
   {
    pozz--;

    if(pozz <= 0)
     {
      beep();
      pozz=0;
      goto naz;
     }

    cur.poz_cursor(pozz);
    if(cur.read_cursor(&row) == 0)
      break;
    i++;
   }
  goto naz;
 }

if(kom >= 0)
 {
  if(iceb_tu_SRAV(gettext("Конец списка"),spis_menu.spis_str.ravno(kom),0) == 0)
     goto naz;
  if(pozz+kom >= kolstr)
   goto naz;

  iceb_tu_POLE(spis_menu.spis_str.ravno(kom),nomd,1,'|');
  iceb_tu_POLE(spis_menu.spis_str.ravno(kom),nomkvrt,2,'|');
  iceb_tu_POLE(spis_menu.spis_str.ravno(kom),strsql,3,'|');
  iceb_tu_rsdat1(&mz,&gz,strsql);

 }

vper:;

switch(K)
 {  

  case FK1: //Просмотр документации
    GDITE();

    if(kolstr > 0)
      goto naz;
    else
      goto lll;

  case FK2:  
      ku_oplata_v(2,0);
      goto naz1; 
 
  case PLU:  
      ku_oplata_v(1,0);
      goto naz1; 

  case OTN:  
      ku_oplata_v(2,0);
      goto naz1; 

  case ENTER:
  case SFK2:  
      ku_oplata_v(0,nom_zap[kom]);
      goto naz1;

  case FK3:  
   ku_oplata_ud(nom_zap[kom]);
   goto naz1;

  case SFK3:  
   ku_oplata_udzap(&cur);
   goto naz1;

  case FK4:  //Поиск
    ku_oplata_poi(&qw);
    goto naz1; 

  case FK5://Печать
    ku_oplata_rs(&cur,&qw);
    clear();
    goto naz;

  case FK10:
  case ESC:
    return;
    
 }

}
/*****************************/
/*Шапка на экран*/
/***********************/

void ku_oplatas(class poisk *data)
{

move (0,0);
printw("Перегляд списку нарахувань/оплат");

move(1,0);
printw("     1       2    3     4        5       6       7      8      9      10     11");
int nomer=0;
int X=COLS-20;
move (nomer++,X);
printw ("Расшифровка полей");

mvprintw(nomer++,X,"1-Дата");
mvprintw(nomer++,X,"2-Номер дома");
mvprintw(nomer++,X,"3-Номер квартиры");
mvprintw(nomer++,X,"4-утримання будинку");
mvprintw(nomer++,X,"5-опалення");
mvprintw(nomer++,X,"6-елетроенергія");
mvprintw(nomer++,X,"7-вода");
mvprintw(nomer++,X,"8-газ");
mvprintw(nomer++,X,"9-розподіл газу");
mvprintw(nomer++,X,"10-стокі");
mvprintw(nomer++,X,"11-мусор");

if(data->mp!=0)
{
 nomer+=3;

 mvprintw(nomer++,X,"Пошук по:");

 if(data->nomd.ravno()[0]!='\0')
  mvprintw(nomer++,X,"Номер дома:%s",data->nomd.ravno());

 if(data->nomk.ravno()[0]!='\0')
  mvprintw(nomer++,X,"Номер квартіри:%s",data->nomk.ravno() );

 if(data->datan.ravno()[0]!='\0')
  mvprintw(nomer++,X,"Дата початку:%s",data->datan.ravno());

 if(data->datak.ravno()[0]!='\0')
  mvprintw(nomer++,X,"Дата кінця:%s",data->datak.ravno());
 if(data->pr_rs.ravno()[0]!='\0')
  mvprintw(nomer++,X,"Нарах./оплата:%s",data->pr_rs.ravno());

 
}



helstr(LINES-1,0,
"F1","Поміч",
"F2/-","Ввод оплати",
"+","Ввод нарахування",
"SF2","Коригування",
"F3","Видалення",
"F4","Пошук",
"F5","Друк",
"F10","Вихід",NULL);

}



/*******************************/
/*Поиск*/
/**********************/


void ku_oplata_poi(class poisk *data)
{

VVOD  VV(0);
VV.VVOD_spisok_add_ZAG("Пошук");

VV.VVOD_spisok_add_MD("Номер дома................");
VV.VVOD_spisok_add_MD("Номер квартири............");
VV.VVOD_spisok_add_MD("Дата початку.......(м.р)..");
VV.VVOD_spisok_add_MD("Дата кінця.........(м.р)..");
VV.VVOD_spisok_add_MD("Нарахування/оплата.(+/-)..");

VV.VVOD_spisok_add_data(data->nomd.ravno(),10);
VV.VVOD_spisok_add_data(data->nomk.ravno(),10);
VV.VVOD_spisok_add_data(data->datan.ravno(),8);
VV.VVOD_spisok_add_data(data->datak.ravno(),8);
VV.VVOD_spisok_add_data(data->pr_rs.ravno(),2);

naz:;

helstr(LINES-1,0,
"F1","Помощь",
"F2/+","Найти",
"F10","Выход",NULL);



int kom=VV.vvod(0,1,1,-1,-1);

data->nomd.new_plus(VV.VVOD_spisok_return_data(0));
data->nomk.new_plus(VV.VVOD_spisok_return_data(1));
data->datan.new_plus(VV.VVOD_spisok_return_data(2));
data->datak.new_plus(VV.VVOD_spisok_return_data(3));
data->pr_rs.new_plus(VV.VVOD_spisok_return_data(4));


switch(kom)
 {
  case FK1:
    goto naz;

  case FK2:
   data->mp=1;
    break;

  case FK10:
     data->mp=0;
     return;
  default:
    goto naz;
 }


short m=0,g=0,mk=0,gk=0;

if(data->datan.ravno()[0]!='\0')
 if(iceb_tu_rsdat1(&m,&g,data->datan.ravno()) != 0)
  {
   iceb_t_soob("Не правільно введена дата початку!");
   goto naz;
  }
if(data->datak.ravno()[0]!='\0')
 if(iceb_tu_rsdat1(&mk,&gk,data->datak.ravno()) != 0)
  {
   iceb_t_soob("Не правільно введена дата кінця!");
   goto naz;
  }

if(data->pr_rs.ravno()[0] != '\0')
 if(data->pr_rs.ravno()[0] != '-' && data->pr_rs.ravno()[0] != '+')
  {
   iceb_t_soob("Не правильно введено \"Нарахування/оплата\"");
   goto naz;
  }
  
char strsql[200];
memset(strsql,'\0',sizeof(strsql));
sprintf(data->zapros,"select * from Kuoplata ");
short mt=0;


if(data->nomd.ravno()[0] != '\0')
 {
  sprintf(strsql,"where nd='%s'",data->nomd.ravno());
  strcat(data->zapros,strsql);  
  mt++;
 }

if(data->nomk.ravno()[0] != '\0')
 {
  if(mt==0)
   sprintf(strsql,"where nk=%s",data->nomk.ravno());
  else
   sprintf(strsql," and nk=%s",data->nomk.ravno());
  strcat(data->zapros,strsql);  
  mt++;
 }

if(data->pr_rs.ravno()[0] == '+')
 {
  if(mt==0)
   sprintf(strsql,"where pr=1");
  else
   sprintf(strsql," and pr=1");
   
  strcat(data->zapros,strsql);  
  mt++;
 }

if(data->pr_rs.ravno()[0] == '-')
 {
  if(mt==0)
   sprintf(strsql,"where pr=2");
  else
   sprintf(strsql," and pr=2");
   
  strcat(data->zapros,strsql);  
  mt++;
 }

if(data->datan.ravno()[0] != '\0')
 {
  if(mt==0)
   {
    if(mk == 0)
      sprintf(strsql,"where dt >='%d-%d-01' and dt <='%d-%d-31'",g,m,g,m);
    else
      sprintf(strsql,"where dt >='%d-%d-01' and dt <='%d-%d-31'",g,m,gk,mk);
    
   }
  else
   {
    if(mk == 0)
      sprintf(strsql," and dt >='%d-%d-01' and dt <='%d-%d-31'",g,m,g,m);
    else
      sprintf(strsql," and dt >='%d-%d-01' and dt <='%d-%d-31'",g,m,gk,mk);
   }      
  strcat(data->zapros,strsql);  
  mt++;
 }

strcat(data->zapros," order by dt desc,nd asc,nk asc");
//printw("\n%s-%s\n",__FUNCTION__,data->zapros);
//OSTANOV();
}


/***********************************/
/*Удаление*/
/*******************************************/



void ku_oplata_ud(int nom_zap)
{
char strsql[300];
SQL_str row;
class SQLCURSOR cur;

/*узнаём дату записи чтобы проверить блокировку*/

sprintf(strsql,"select dt from Kuoplata where nz=%d",nom_zap);

if(iceb_t_sql_readkey(strsql,&row,&cur) != 1)
 {
  sprintf(strsql,"Не знайден запис з номером %d !",nom_zap);
  iceb_t_soob(strsql);
  return;
 }

if(iceb_t_pbpds(iceb_tu_datzap(row[0])) != 0)
  return;
  
VVOD DANET(1);


DANET.VVOD_spisok_add_MD(gettext("Удалить ? Вы уверены ?"));

if(danet(&DANET,2,stdscr) == 2)
 return;


sprintf(strsql,"delete from Kuoplata where nz=%d",nom_zap);


if(iceb_t_sql_zapis(strsql,1,0) != 0)
  return;

}

/**************************************************/
/*Удаление всех записей*/
/*********************************/


void ku_oplata_udzap(SQLCURSOR *cur)
{
SQL_str row;

VVOD DANET(1);


DANET.VVOD_spisok_add_MD("Видалити всі записи? Ви впевнені?");

if(danet(&DANET,2,stdscr) == 2)
 return;


GDITE();

char strsql[1024];
/*проверяем даты на блокировку*/

cur->poz_cursor(0);
while(cur->read_cursor(&row) != 0)
 {
  if(iceb_t_pbpds(iceb_tu_datzap(row[2])) != 0)
   {
    return;
   }
 }
 
cur->poz_cursor(0);
while(cur->read_cursor(&row) != 0)
 {
  sprintf(strsql,"delete from Kuoplata where nz=%s",row[12]);

  if(iceb_t_sql_zapis(strsql,1,0) != 0)
    return;

 }






}


/**************************************************/
/*Печать*/
/*********************************/


void ku_oplata_rs(SQLCURSOR *cur,class poisk *data)
{
int summa=0;
short dz,mz,gz;
SQL_str row;

FILE *ff;
char imaf[100];
sprintf(imaf,"kuslg%d.lst",getpid());
if((ff=fopen(imaf,"w")) == NULL)
 {
  error_op_nfil(imaf,errno,0);
  return;
 }


iceb_t_zagolov("Нарахування/оплати",ff);

if(data->mp!=0)
{
 fprintf (ff,"Пошук по:\n");
 if(data->nomd.ravno()[0]!='\0')
  {
   fprintf (ff,"Номеру дома:%s\n",data->nomd.ravno());
  }
 if(data->nomk.ravno()[0]!='\0')
  {
   fprintf (ff,"Номеру квартири:%s\n",data->nomk.ravno() );
  }
 if(data->datan.ravno()[0]!='\0')
  {
   fprintf (ff,"Дате початку:%s\n",data->datan.ravno());
  }
 if(data->datak.ravno()[0] != '\0')
  {
   fprintf (ff,"Дате кінця:%s\n",data->datak.ravno());
  }
 if(data->pr_rs.ravno()[0]!='\0')
  {
   fprintf (ff,"Нарахування/оплата:%s\n",data->pr_rs.ravno());
  }
}
#define MAS 8
double itogo[MAS];
memset(itogo,'\0',sizeof(itogo));
char prih_rash[2];
int nom_row=0;

fprintf(ff,"\
---------------------------------------------------------------------------------------------------------------\n\
  Дата  |N Дома |N кв |Утримання |Опалення  |Електроен.|   Вода   |   Газ    |Розпо.газа|  Стокі   |  Сміття  |\n\
---------------------------------------------------------------------------------------------------------------\n");
//                     1234567890 1234567890 1234567890 1234567890 1234567890 1234567890 1234567890 1234567890
cur->poz_cursor(0);
while(cur->read_cursor(&row) != 0)
 {
  memset(prih_rash,'\0',sizeof(prih_rash));
  
  if(atoi(row[3]) == 1)  
   prih_rash[0]='+';

  if(atoi(row[3]) == 2)  
   prih_rash[0]='-';

  summa+=atoi(row[3]);
  iceb_tu_rsdat(&dz,&mz,&gz,row[2],2);

  fprintf(ff,"%s%02d.%02d|%-7s|%-5s|\
%10.10g|%10.10g|%10.10g|%10.10g|%10.10g|%10.10g|%10.10g|%10.10g|\n",
  prih_rash,
  mz,gz,
  row[0],row[1],
  atof(row[4]),atof(row[5]),atof(row[6]),atof(row[7]),
  atof(row[8]),atof(row[9]),atof(row[10]),atof(row[11]));

  nom_row=4;
  for(int nom=0; nom < MAS; nom++)
    itogo[nom]+=atof(row[nom_row++]);
  
 } 
fprintf(ff,"\
---------------------------------------------------------------------------------------------------------------\n");
fprintf(ff,"%*s|",iceb_tu_kolbait(22,"Итого"),"Итого");
for(int nom=0; nom < MAS; nom++)
  fprintf(ff,"%10.2f|",itogo[nom]);
fprintf(ff,"\n");
iceb_t_podpis(ff);


fclose(ff);

class spis_oth oth;
oth.spis_imaf.plus(imaf);
oth.spis_naim.plus("Роздрук нарахувань/оплат");
iceb_t_ustpeh(imaf,3);
iceb_t_rabfil(&oth,"");
}
/*******************************************/
/*ввод и корректировка*/
/************************************/
int ku_oplata_v(int metka, /*0-корректировка записи 1-начисление 2-оплата*/
int nom_zap)
{
class iceb_tu_str nomd("");  // Номер дома
class iceb_tu_str nomk("");   // Номер квартиры
class iceb_tu_str data("");   // дата

#define KOL_REK 8
double suma[KOL_REK];
for(int nom=0; nom < KOL_REK; nom++)
 suma[nom]=0.;
 
short dz=1,mz=0,gz=0;
int pr_rs=metka;

class SQLCURSOR cur;
SQL_str   row;

char strsql[1024];
memset (strsql,'\0',sizeof(strsql));


VVOD  VV(0);

if (nom_zap == 0)
 {
  VV.VVOD_spisok_add_ZAG("Ввод данных");
  if(metka == 1)
   VV.VVOD_spisok_add_ZAG("Нарахування");
  if(metka == 2)
   VV.VVOD_spisok_add_ZAG("Оплата");
 }
if (nom_zap != 0)
 {

  sprintf(strsql,"\
SELECT * from  Kuoplata where nz=%d",nom_zap);

  if(iceb_t_sql_readkey(strsql,&row,&cur) < 1)
   {
    VVOD SOOB(1);
    SOOB.VVOD_spisok_add_MD("Не найдена запись для корректировки !!!");
    SOOB.VVOD_spisok_add_MD(strsql);
    soobshw(&SOOB,stdscr,-1,-1,0,1);
    return (1);

   }


  nomd.new_plus(row[0]);
  nomk.new_plus(row[1]);
  iceb_tu_rsdat(&dz,&mz,&gz,row[2],2);

  pr_rs=atoi(row[3]);  
    

  int nomkol=4;
  for(int nom=0; nom < KOL_REK; nom++)
   suma[nom]=atof(row[nomkol++]);


  VV.VVOD_spisok_add_ZAG("Коригування");
  if(pr_rs == 1)
   VV.VVOD_spisok_add_ZAG("Нарахування");
  if(pr_rs == 2)
   VV.VVOD_spisok_add_ZAG("Оплата");
  
  nomk.new_plus(row[1]);

  sprintf(strsql,"%d.%d",mz,gz);
  data.new_plus(strsql);

  sprintf(strsql,"Дом:%s Квартира:%s Дата:%d.%d",nomd.ravno(),nomk.ravno(),mz,gz);
  VV.VVOD_spisok_add_ZAG(strsql);


  kzvz(row[13],row[14],&VV);  
 }




if (nom_zap == 0)
 {
  
VV.VVOD_spisok_add_MD("Номер дома.........");
VV.VVOD_spisok_add_MD("Номер квартиры.....");
VV.VVOD_spisok_add_MD("Дата......(м.г)....");
 }
/******************
VV.VVOD_spisok_add_MD("Утримання будику...");0
VV.VVOD_spisok_add_MD("Опалення...........");1
VV.VVOD_spisok_add_MD("Електроенергія.....");2
VV.VVOD_spisok_add_MD("Вода...............");3
VV.VVOD_spisok_add_MD("Газ................");4
VV.VVOD_spisok_add_MD("Розподіл гаазу.....");5
VV.VVOD_spisok_add_MD("Стокі..............");6
VV.VVOD_spisok_add_MD("Сміття.............");7
*******************/
VV.VVOD_spisok_add_MD("Утримання будику...");
VV.VVOD_spisok_add_MD("Опалення...........");
VV.VVOD_spisok_add_MD("Газ................");
VV.VVOD_spisok_add_MD("Розподіл газу......");
VV.VVOD_spisok_add_MD("Вода...............");
VV.VVOD_spisok_add_MD("Стокі..............");
VV.VVOD_spisok_add_MD("Електроенергія.....");
VV.VVOD_spisok_add_MD("Сміття.............");


if (nom_zap == 0)
 {
    
  VV.VVOD_spisok_add_data(nomd.ravno(),10);
  VV.VVOD_spisok_add_data(nomk.ravno(),10);
  VV.VVOD_spisok_add_data(data.ravno(),8);
 }

if(pr_rs == 2)
 for(int nom=0; nom < KOL_REK; nom++)
  suma[nom]*=(-1);

VV.VVOD_spisok_add_data(suma[0],10);
VV.VVOD_spisok_add_data(suma[1],10);
VV.VVOD_spisok_add_data(suma[4],10);
VV.VVOD_spisok_add_data(suma[5],10);
VV.VVOD_spisok_add_data(suma[3],10);
VV.VVOD_spisok_add_data(suma[6],10);
VV.VVOD_spisok_add_data(suma[2],10);
VV.VVOD_spisok_add_data(suma[7],10);

naz:;

helstr(LINES-1,0,
//"F1","Помощь",
"F2/+","Запис",
"F4","Очистити",
"F10","Выход",NULL);


int kom=VV.vvod(0,1,1,-1,-1);

if (nom_zap == 0)
 {
  nomd.new_plus(VV.VVOD_spisok_return_data(0));
  nomk.new_plus(VV.VVOD_spisok_return_data(1));
  data.new_plus(VV.VVOD_spisok_return_data(2));

/*********
VV.VVOD_spisok_add_data(suma[0],10);
VV.VVOD_spisok_add_data(suma[1],10);
VV.VVOD_spisok_add_data(suma[4],10);
VV.VVOD_spisok_add_data(suma[5],10);
VV.VVOD_spisok_add_data(suma[3],10);
VV.VVOD_spisok_add_data(suma[6],10);
VV.VVOD_spisok_add_data(suma[2],10);
VV.VVOD_spisok_add_data(suma[7],10);
****************/
  suma[0]=VV.data_ravno_atof(3);
  suma[1]=VV.data_ravno_atof(4);
  suma[2]=VV.data_ravno_atof(9);
  suma[3]=VV.data_ravno_atof(7);
  suma[4]=VV.data_ravno_atof(5);
  suma[5]=VV.data_ravno_atof(6);
  suma[6]=VV.data_ravno_atof(8);
  suma[7]=VV.data_ravno_atof(10);
        
 }
else
 {
  suma[0]=VV.data_ravno_atof(0);
  suma[1]=VV.data_ravno_atof(1);
  suma[2]=VV.data_ravno_atof(6);
  suma[3]=VV.data_ravno_atof(4);
  suma[4]=VV.data_ravno_atof(2);
  suma[5]=VV.data_ravno_atof(3);
  suma[6]=VV.data_ravno_atof(5);
  suma[7]=VV.data_ravno_atof(7);

 } 


switch(kom)
 {
  case FK1:
    goto naz;

  case FK2:
    break;

  case FK4:
    VV.VVOD_clear_data();
    goto naz;

  case FK10:
     return(0);

  default:
   goto naz;
 }

short d=1,m=0,g=0;

if(iceb_tu_rsdat1(&m,&g,data.ravno()) != 0)
 {
  iceb_t_soob("Не правильно введена дата!");
  goto naz;
 }

if(iceb_t_pbpds(m,g) != 0)
 goto naz;

if(nom_zap == 0)
 {
 sprintf(strsql,"select nz from Kuoplata where nd='%s' and nk='%s' and dt='%04d-%02d-%02d' and pr=%d",
 nomd.ravno(),nomk.ravno(),g,m,d,pr_rs);

 if(sql_readkey(&bd,strsql) >= 1)
  {
   iceb_t_soob("Такий запис вже є!");
   goto naz;
  }
 }

sprintf(strsql,"select * from Kuskvart where nd='%s' and nk=%d",nomd.ravno(),nomk.ravno_atoi());
if(sql_readkey(&bd,strsql) != 1)
 {
  VVOD SOOB(1);
  SOOB.VVOD_spisok_add_MD("Такой квартиры в этом доме нету!");
  SOOB.VVOD_spisok_add_MD(strsql);
  soobshw(&SOOB,stdscr,-1,-1,0,1);
  goto naz;
 }



if(pr_rs == 2)
 for(int nom=0; nom < KOL_REK; nom++)
  suma[nom]*=(-1);




if(nom_zap == 0) 
 {
  sprintf(strsql,"\
INSERT INTO Kuoplata (nd,nk,dt,pr,ub,op,ee,vd,gz,rgz,st,mus,ktoi,vrem) \
values ('%s','%s','%d-%d-%d',%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%d,%ld)",
  nomd.ravno(),
  nomk.ravno(),
  g,m,d,
  pr_rs,
  suma[0],
  suma[1],
  suma[2],
  suma[3],
  suma[4],
  suma[5],
  suma[6],
  suma[7],
  iceb_t_getuid(),
  time(NULL));
 }
else
  sprintf(strsql,"\
update Kuoplata \
set \
ub=%.2f,\
op=%.2f,\
ee=%.2f,\
vd=%.2f,\
gz=%.2f,\
rgz=%.2f,\
st=%.2f,\
mus=%.2f,\
ktoi=%d,\
vrem=%ld \
where nz=%d", 
  suma[0],
  suma[1],
  suma[2],
  suma[3],
  suma[4],
  suma[5],
  suma[6],
  suma[7],
  iceb_t_getuid(),
  time(NULL),
  nom_zap);

if(iceb_t_sql_zapis(strsql,0,0) != 0)
  return(1);

return(0);

}
